/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyDetectorConfig;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnomalyDetectorRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, CreateAnomalyDetectorRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorName").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::anomalyDetectorName)).setter(CreateAnomalyDetectorRequest.setter(Builder::anomalyDetectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorName").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorDescription").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::anomalyDetectorDescription)).setter(CreateAnomalyDetectorRequest.setter(Builder::anomalyDetectorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorDescription").build()}).build();
    private static final SdkField<AnomalyDetectorConfig> ANOMALY_DETECTOR_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyDetectorConfig").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::anomalyDetectorConfig)).setter(CreateAnomalyDetectorRequest.setter(Builder::anomalyDetectorConfig)).constructor(AnomalyDetectorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::kmsKeyArn)).setter(CreateAnomalyDetectorRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::tags)).setter(CreateAnomalyDetectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_NAME_FIELD, ANOMALY_DETECTOR_DESCRIPTION_FIELD, ANOMALY_DETECTOR_CONFIG_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));
    private final String anomalyDetectorName;
    private final String anomalyDetectorDescription;
    private final AnomalyDetectorConfig anomalyDetectorConfig;
    private final String kmsKeyArn;
    private final Map<String, String> tags;

    private CreateAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorName = builder.anomalyDetectorName;
        this.anomalyDetectorDescription = builder.anomalyDetectorDescription;
        this.anomalyDetectorConfig = builder.anomalyDetectorConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    public final String anomalyDetectorName() {
        return this.anomalyDetectorName;
    }

    public final String anomalyDetectorDescription() {
        return this.anomalyDetectorDescription;
    }

    public final AnomalyDetectorConfig anomalyDetectorConfig() {
        return this.anomalyDetectorConfig;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalyDetectorRequest)) {
            return false;
        }
        CreateAnomalyDetectorRequest other = (CreateAnomalyDetectorRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorName(), other.anomalyDetectorName()) && Objects.equals(this.anomalyDetectorDescription(), other.anomalyDetectorDescription()) && Objects.equals(this.anomalyDetectorConfig(), other.anomalyDetectorConfig()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnomalyDetectorRequest").add("AnomalyDetectorName", (Object)this.anomalyDetectorName()).add("AnomalyDetectorDescription", (Object)this.anomalyDetectorDescription()).add("AnomalyDetectorConfig", (Object)this.anomalyDetectorConfig()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorName": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorName()));
            }
            case "AnomalyDetectorDescription": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorDescription()));
            }
            case "AnomalyDetectorConfig": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorConfig()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((CreateAnomalyDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorName;
        private String anomalyDetectorDescription;
        private AnomalyDetectorConfig anomalyDetectorConfig;
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalyDetectorRequest model) {
            super(model);
            this.anomalyDetectorName(model.anomalyDetectorName);
            this.anomalyDetectorDescription(model.anomalyDetectorDescription);
            this.anomalyDetectorConfig(model.anomalyDetectorConfig);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
        }

        public final String getAnomalyDetectorName() {
            return this.anomalyDetectorName;
        }

        public final void setAnomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
            return this;
        }

        public final String getAnomalyDetectorDescription() {
            return this.anomalyDetectorDescription;
        }

        public final void setAnomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
            return this;
        }

        public final AnomalyDetectorConfig.Builder getAnomalyDetectorConfig() {
            return this.anomalyDetectorConfig != null ? this.anomalyDetectorConfig.toBuilder() : null;
        }

        public final void setAnomalyDetectorConfig(AnomalyDetectorConfig.BuilderImpl anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig != null ? anomalyDetectorConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorConfig(AnomalyDetectorConfig anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnomalyDetectorRequest build() {
            return new CreateAnomalyDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnomalyDetectorRequest> {
        public Builder anomalyDetectorName(String var1);

        public Builder anomalyDetectorDescription(String var1);

        public Builder anomalyDetectorConfig(AnomalyDetectorConfig var1);

        default public Builder anomalyDetectorConfig(Consumer<AnomalyDetectorConfig.Builder> anomalyDetectorConfig) {
            return this.anomalyDetectorConfig((AnomalyDetectorConfig)((AnomalyDetectorConfig.Builder)AnomalyDetectorConfig.builder().applyMutation(anomalyDetectorConfig)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

