/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lookoutmetrics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricSetSummary> {
    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetArn").getter(MetricSetSummary.getter(MetricSetSummary::metricSetArn)).setter(MetricSetSummary.setter(Builder::metricSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(MetricSetSummary.getter(MetricSetSummary::anomalyDetectorArn)).setter(MetricSetSummary.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> METRIC_SET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetDescription").getter(MetricSetSummary.getter(MetricSetSummary::metricSetDescription)).setter(MetricSetSummary.setter(Builder::metricSetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDescription").build()}).build();
    private static final SdkField<String> METRIC_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetName").getter(MetricSetSummary.getter(MetricSetSummary::metricSetName)).setter(MetricSetSummary.setter(Builder::metricSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MetricSetSummary.getter(MetricSetSummary::creationTime)).setter(MetricSetSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(MetricSetSummary.getter(MetricSetSummary::lastModificationTime)).setter(MetricSetSummary.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(MetricSetSummary.getter(MetricSetSummary::tags)).setter(MetricSetSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_ARN_FIELD, ANOMALY_DETECTOR_ARN_FIELD, METRIC_SET_DESCRIPTION_FIELD, METRIC_SET_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metricSetArn;
    private final String anomalyDetectorArn;
    private final String metricSetDescription;
    private final String metricSetName;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final Map<String, String> tags;

    private MetricSetSummary(BuilderImpl builder) {
        this.metricSetArn = builder.metricSetArn;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.metricSetDescription = builder.metricSetDescription;
        this.metricSetName = builder.metricSetName;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.tags = builder.tags;
    }

    public final String metricSetArn() {
        return this.metricSetArn;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String metricSetDescription() {
        return this.metricSetDescription;
    }

    public final String metricSetName() {
        return this.metricSetName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSetSummary)) {
            return false;
        }
        MetricSetSummary other = (MetricSetSummary)obj;
        return Objects.equals(this.metricSetArn(), other.metricSetArn()) && Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.metricSetDescription(), other.metricSetDescription()) && Objects.equals(this.metricSetName(), other.metricSetName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"MetricSetSummary").add("MetricSetArn", (Object)this.metricSetArn()).add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("MetricSetDescription", (Object)this.metricSetDescription()).add("MetricSetName", (Object)this.metricSetName()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricSetArn": {
                return Optional.ofNullable(clazz.cast(this.metricSetArn()));
            }
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "MetricSetDescription": {
                return Optional.ofNullable(clazz.cast(this.metricSetDescription()));
            }
            case "MetricSetName": {
                return Optional.ofNullable(clazz.cast(this.metricSetName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricSetSummary, T> g) {
        return obj -> g.apply((MetricSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricSetArn;
        private String anomalyDetectorArn;
        private String metricSetDescription;
        private String metricSetName;
        private Instant creationTime;
        private Instant lastModificationTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSetSummary model) {
            this.metricSetArn(model.metricSetArn);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.metricSetDescription(model.metricSetDescription);
            this.metricSetName(model.metricSetName);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.tags(model.tags);
        }

        public final String getMetricSetArn() {
            return this.metricSetArn;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        @Override
        @Transient
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getMetricSetDescription() {
            return this.metricSetDescription;
        }

        public final void setMetricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
        }

        @Override
        @Transient
        public final Builder metricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
            return this;
        }

        public final String getMetricSetName() {
            return this.metricSetName;
        }

        public final void setMetricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
        }

        @Override
        @Transient
        public final Builder metricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        @Transient
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public MetricSetSummary build() {
            return new MetricSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricSetSummary> {
        public Builder metricSetArn(String var1);

        public Builder anomalyDetectorArn(String var1);

        public Builder metricSetDescription(String var1);

        public Builder metricSetName(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

