/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftSourceConfig> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(RedshiftSourceConfig.getter(RedshiftSourceConfig::clusterIdentifier)).setter(RedshiftSourceConfig.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> DATABASE_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseHost").getter(RedshiftSourceConfig.getter(RedshiftSourceConfig::databaseHost)).setter(RedshiftSourceConfig.setter(Builder::databaseHost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseHost").build()}).build();
    private static final SdkField<Integer> DATABASE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatabasePort").getter(RedshiftSourceConfig.getter(RedshiftSourceConfig::databasePort)).setter(RedshiftSourceConfig.setter(Builder::databasePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabasePort").build()}).build();
    private static final SdkField<String> SECRET_MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretManagerArn").getter(RedshiftSourceConfig.getter(RedshiftSourceConfig::secretManagerArn)).setter(RedshiftSourceConfig.setter(Builder::secretManagerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretManagerArn").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(RedshiftSourceConfig.getter(RedshiftSourceConfig::databaseName)).setter(RedshiftSourceConfig.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(RedshiftSourceConfig.getter(RedshiftSourceConfig::tableName)).setter(RedshiftSourceConfig.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(RedshiftSourceConfig.getter(RedshiftSourceConfig::roleArn)).setter(RedshiftSourceConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(RedshiftSourceConfig.getter(RedshiftSourceConfig::vpcConfiguration)).setter(RedshiftSourceConfig.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, DATABASE_HOST_FIELD, DATABASE_PORT_FIELD, SECRET_MANAGER_ARN_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, ROLE_ARN_FIELD, VPC_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterIdentifier;
    private final String databaseHost;
    private final Integer databasePort;
    private final String secretManagerArn;
    private final String databaseName;
    private final String tableName;
    private final String roleArn;
    private final VpcConfiguration vpcConfiguration;

    private RedshiftSourceConfig(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.databaseHost = builder.databaseHost;
        this.databasePort = builder.databasePort;
        this.secretManagerArn = builder.secretManagerArn;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.roleArn = builder.roleArn;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String databaseHost() {
        return this.databaseHost;
    }

    public final Integer databasePort() {
        return this.databasePort;
    }

    public final String secretManagerArn() {
        return this.secretManagerArn;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseHost());
        hashCode = 31 * hashCode + Objects.hashCode(this.databasePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftSourceConfig)) {
            return false;
        }
        RedshiftSourceConfig other = (RedshiftSourceConfig)obj;
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.databaseHost(), other.databaseHost()) && Objects.equals(this.databasePort(), other.databasePort()) && Objects.equals(this.secretManagerArn(), other.secretManagerArn()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftSourceConfig").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("DatabaseHost", (Object)this.databaseHost()).add("DatabasePort", (Object)this.databasePort()).add("SecretManagerArn", (Object)this.secretManagerArn()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("RoleArn", (Object)this.roleArn()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "DatabaseHost": {
                return Optional.ofNullable(clazz.cast(this.databaseHost()));
            }
            case "DatabasePort": {
                return Optional.ofNullable(clazz.cast(this.databasePort()));
            }
            case "SecretManagerArn": {
                return Optional.ofNullable(clazz.cast(this.secretManagerArn()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftSourceConfig, T> g) {
        return obj -> g.apply((RedshiftSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String databaseHost;
        private Integer databasePort;
        private String secretManagerArn;
        private String databaseName;
        private String tableName;
        private String roleArn;
        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftSourceConfig model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.databaseHost(model.databaseHost);
            this.databasePort(model.databasePort);
            this.secretManagerArn(model.secretManagerArn);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.roleArn(model.roleArn);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getDatabaseHost() {
            return this.databaseHost;
        }

        public final void setDatabaseHost(String databaseHost) {
            this.databaseHost = databaseHost;
        }

        @Override
        @Transient
        public final Builder databaseHost(String databaseHost) {
            this.databaseHost = databaseHost;
            return this;
        }

        public final Integer getDatabasePort() {
            return this.databasePort;
        }

        public final void setDatabasePort(Integer databasePort) {
            this.databasePort = databasePort;
        }

        @Override
        @Transient
        public final Builder databasePort(Integer databasePort) {
            this.databasePort = databasePort;
            return this;
        }

        public final String getSecretManagerArn() {
            return this.secretManagerArn;
        }

        public final void setSecretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
        }

        @Override
        @Transient
        public final Builder secretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public RedshiftSourceConfig build() {
            return new RedshiftSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftSourceConfig> {
        public Builder clusterIdentifier(String var1);

        public Builder databaseHost(String var1);

        public Builder databasePort(Integer var1);

        public Builder secretManagerArn(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder roleArn(String var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

