/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.Frequency;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.Metric;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSource;
import software.amazon.awssdk.services.lookoutmetrics.model.TagMapCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.TimestampColumn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMetricSetRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, CreateMetricSetRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::anomalyDetectorArn)).setter(CreateMetricSetRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> METRIC_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetName").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::metricSetName)).setter(CreateMetricSetRequest.setter(Builder::metricSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetName").build()}).build();
    private static final SdkField<String> METRIC_SET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetDescription").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::metricSetDescription)).setter(CreateMetricSetRequest.setter(Builder::metricSetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDescription").build()}).build();
    private static final SdkField<List<Metric>> METRIC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricList").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::metricList)).setter(CreateMetricSetRequest.setter(Builder::metricList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Offset").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::offset)).setter(CreateMetricSetRequest.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()}).build();
    private static final SdkField<TimestampColumn> TIMESTAMP_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimestampColumn").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::timestampColumn)).setter(CreateMetricSetRequest.setter(Builder::timestampColumn)).constructor(TimestampColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumn").build()}).build();
    private static final SdkField<List<String>> DIMENSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionList").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::dimensionList)).setter(CreateMetricSetRequest.setter(Builder::dimensionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_SET_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetFrequency").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::metricSetFrequencyAsString)).setter(CreateMetricSetRequest.setter(Builder::metricSetFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetFrequency").build()}).build();
    private static final SdkField<MetricSource> METRIC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricSource").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::metricSource)).setter(CreateMetricSetRequest.setter(Builder::metricSource)).constructor(MetricSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSource").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::timezone)).setter(CreateMetricSetRequest.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateMetricSetRequest.getter(CreateMetricSetRequest::tags)).setter(CreateMetricSetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, METRIC_SET_NAME_FIELD, METRIC_SET_DESCRIPTION_FIELD, METRIC_LIST_FIELD, OFFSET_FIELD, TIMESTAMP_COLUMN_FIELD, DIMENSION_LIST_FIELD, METRIC_SET_FREQUENCY_FIELD, METRIC_SOURCE_FIELD, TIMEZONE_FIELD, TAGS_FIELD));
    private final String anomalyDetectorArn;
    private final String metricSetName;
    private final String metricSetDescription;
    private final List<Metric> metricList;
    private final Integer offset;
    private final TimestampColumn timestampColumn;
    private final List<String> dimensionList;
    private final String metricSetFrequency;
    private final MetricSource metricSource;
    private final String timezone;
    private final Map<String, String> tags;

    private CreateMetricSetRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.metricSetName = builder.metricSetName;
        this.metricSetDescription = builder.metricSetDescription;
        this.metricList = builder.metricList;
        this.offset = builder.offset;
        this.timestampColumn = builder.timestampColumn;
        this.dimensionList = builder.dimensionList;
        this.metricSetFrequency = builder.metricSetFrequency;
        this.metricSource = builder.metricSource;
        this.timezone = builder.timezone;
        this.tags = builder.tags;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String metricSetName() {
        return this.metricSetName;
    }

    public final String metricSetDescription() {
        return this.metricSetDescription;
    }

    public final boolean hasMetricList() {
        return this.metricList != null && !(this.metricList instanceof SdkAutoConstructList);
    }

    public final List<Metric> metricList() {
        return this.metricList;
    }

    public final Integer offset() {
        return this.offset;
    }

    public final TimestampColumn timestampColumn() {
        return this.timestampColumn;
    }

    public final boolean hasDimensionList() {
        return this.dimensionList != null && !(this.dimensionList instanceof SdkAutoConstructList);
    }

    public final List<String> dimensionList() {
        return this.dimensionList;
    }

    public final Frequency metricSetFrequency() {
        return Frequency.fromValue(this.metricSetFrequency);
    }

    public final String metricSetFrequencyAsString() {
        return this.metricSetFrequency;
    }

    public final MetricSource metricSource() {
        return this.metricSource;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricList() ? this.metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionList() ? this.dimensionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetricSetRequest)) {
            return false;
        }
        CreateMetricSetRequest other = (CreateMetricSetRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.metricSetName(), other.metricSetName()) && Objects.equals(this.metricSetDescription(), other.metricSetDescription()) && this.hasMetricList() == other.hasMetricList() && Objects.equals(this.metricList(), other.metricList()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.timestampColumn(), other.timestampColumn()) && this.hasDimensionList() == other.hasDimensionList() && Objects.equals(this.dimensionList(), other.dimensionList()) && Objects.equals(this.metricSetFrequencyAsString(), other.metricSetFrequencyAsString()) && Objects.equals(this.metricSource(), other.metricSource()) && Objects.equals(this.timezone(), other.timezone()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMetricSetRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("MetricSetName", (Object)this.metricSetName()).add("MetricSetDescription", (Object)this.metricSetDescription()).add("MetricList", this.hasMetricList() ? this.metricList() : null).add("Offset", (Object)this.offset()).add("TimestampColumn", (Object)this.timestampColumn()).add("DimensionList", this.hasDimensionList() ? this.dimensionList() : null).add("MetricSetFrequency", (Object)this.metricSetFrequencyAsString()).add("MetricSource", (Object)this.metricSource()).add("Timezone", (Object)this.timezone()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "MetricSetName": {
                return Optional.ofNullable(clazz.cast(this.metricSetName()));
            }
            case "MetricSetDescription": {
                return Optional.ofNullable(clazz.cast(this.metricSetDescription()));
            }
            case "MetricList": {
                return Optional.ofNullable(clazz.cast(this.metricList()));
            }
            case "Offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "TimestampColumn": {
                return Optional.ofNullable(clazz.cast(this.timestampColumn()));
            }
            case "DimensionList": {
                return Optional.ofNullable(clazz.cast(this.dimensionList()));
            }
            case "MetricSetFrequency": {
                return Optional.ofNullable(clazz.cast(this.metricSetFrequencyAsString()));
            }
            case "MetricSource": {
                return Optional.ofNullable(clazz.cast(this.metricSource()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMetricSetRequest, T> g) {
        return obj -> g.apply((CreateMetricSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String metricSetName;
        private String metricSetDescription;
        private List<Metric> metricList = DefaultSdkAutoConstructList.getInstance();
        private Integer offset;
        private TimestampColumn timestampColumn;
        private List<String> dimensionList = DefaultSdkAutoConstructList.getInstance();
        private String metricSetFrequency;
        private MetricSource metricSource;
        private String timezone;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMetricSetRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.metricSetName(model.metricSetName);
            this.metricSetDescription(model.metricSetDescription);
            this.metricList(model.metricList);
            this.offset(model.offset);
            this.timestampColumn(model.timestampColumn);
            this.dimensionList(model.dimensionList);
            this.metricSetFrequency(model.metricSetFrequency);
            this.metricSource(model.metricSource);
            this.timezone(model.timezone);
            this.tags(model.tags);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getMetricSetName() {
            return this.metricSetName;
        }

        public final void setMetricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
        }

        @Override
        public final Builder metricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
            return this;
        }

        public final String getMetricSetDescription() {
            return this.metricSetDescription;
        }

        public final void setMetricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
        }

        @Override
        public final Builder metricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
            return this;
        }

        public final List<Metric.Builder> getMetricList() {
            List<Metric.Builder> result = MetricListCopier.copyToBuilder(this.metricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricList(Collection<Metric.BuilderImpl> metricList) {
            this.metricList = MetricListCopier.copyFromBuilder(metricList);
        }

        @Override
        public final Builder metricList(Collection<Metric> metricList) {
            this.metricList = MetricListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Metric ... metricList) {
            this.metricList(Arrays.asList(metricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Consumer<Metric.Builder> ... metricList) {
            this.metricList(Stream.of(metricList).map(c -> (Metric)((Metric.Builder)Metric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final TimestampColumn.Builder getTimestampColumn() {
            return this.timestampColumn != null ? this.timestampColumn.toBuilder() : null;
        }

        public final void setTimestampColumn(TimestampColumn.BuilderImpl timestampColumn) {
            this.timestampColumn = timestampColumn != null ? timestampColumn.build() : null;
        }

        @Override
        public final Builder timestampColumn(TimestampColumn timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public final Collection<String> getDimensionList() {
            if (this.dimensionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensionList;
        }

        public final void setDimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
        }

        @Override
        public final Builder dimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionList(String ... dimensionList) {
            this.dimensionList(Arrays.asList(dimensionList));
            return this;
        }

        public final String getMetricSetFrequency() {
            return this.metricSetFrequency;
        }

        public final void setMetricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
        }

        @Override
        public final Builder metricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
            return this;
        }

        @Override
        public final Builder metricSetFrequency(Frequency metricSetFrequency) {
            this.metricSetFrequency(metricSetFrequency == null ? null : metricSetFrequency.toString());
            return this;
        }

        public final MetricSource.Builder getMetricSource() {
            return this.metricSource != null ? this.metricSource.toBuilder() : null;
        }

        public final void setMetricSource(MetricSource.BuilderImpl metricSource) {
            this.metricSource = metricSource != null ? metricSource.build() : null;
        }

        @Override
        public final Builder metricSource(MetricSource metricSource) {
            this.metricSource = metricSource;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMetricSetRequest build() {
            return new CreateMetricSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMetricSetRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder metricSetName(String var1);

        public Builder metricSetDescription(String var1);

        public Builder metricList(Collection<Metric> var1);

        public Builder metricList(Metric ... var1);

        public Builder metricList(Consumer<Metric.Builder> ... var1);

        public Builder offset(Integer var1);

        public Builder timestampColumn(TimestampColumn var1);

        default public Builder timestampColumn(Consumer<TimestampColumn.Builder> timestampColumn) {
            return this.timestampColumn((TimestampColumn)((TimestampColumn.Builder)TimestampColumn.builder().applyMutation(timestampColumn)).build());
        }

        public Builder dimensionList(Collection<String> var1);

        public Builder dimensionList(String ... var1);

        public Builder metricSetFrequency(String var1);

        public Builder metricSetFrequency(Frequency var1);

        public Builder metricSource(MetricSource var1);

        default public Builder metricSource(Consumer<MetricSource.Builder> metricSource) {
            return this.metricSource((MetricSource)((MetricSource.Builder)MetricSource.builder().applyMutation(metricSource)).build());
        }

        public Builder timezone(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

