/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration that specifies the action to perform when anomalies are detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<SNSConfiguration> SNS_CONFIGURATION_FIELD = SdkField
            .<SNSConfiguration> builder(MarshallingType.SDK_POJO).memberName("SNSConfiguration")
            .getter(getter(Action::snsConfiguration)).setter(setter(Builder::snsConfiguration))
            .constructor(SNSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSConfiguration").build()).build();

    private static final SdkField<LambdaConfiguration> LAMBDA_CONFIGURATION_FIELD = SdkField
            .<LambdaConfiguration> builder(MarshallingType.SDK_POJO).memberName("LambdaConfiguration")
            .getter(getter(Action::lambdaConfiguration)).setter(setter(Builder::lambdaConfiguration))
            .constructor(LambdaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_CONFIGURATION_FIELD,
            LAMBDA_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SNSConfiguration snsConfiguration;

    private final LambdaConfiguration lambdaConfiguration;

    private Action(BuilderImpl builder) {
        this.snsConfiguration = builder.snsConfiguration;
        this.lambdaConfiguration = builder.lambdaConfiguration;
    }

    /**
     * <p>
     * A configuration for an Amazon SNS channel.
     * </p>
     * 
     * @return A configuration for an Amazon SNS channel.
     */
    public final SNSConfiguration snsConfiguration() {
        return snsConfiguration;
    }

    /**
     * <p>
     * A configuration for an AWS Lambda channel.
     * </p>
     * 
     * @return A configuration for an AWS Lambda channel.
     */
    public final LambdaConfiguration lambdaConfiguration() {
        return lambdaConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(snsConfiguration(), other.snsConfiguration())
                && Objects.equals(lambdaConfiguration(), other.lambdaConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("SNSConfiguration", snsConfiguration())
                .add("LambdaConfiguration", lambdaConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SNSConfiguration":
            return Optional.ofNullable(clazz.cast(snsConfiguration()));
        case "LambdaConfiguration":
            return Optional.ofNullable(clazz.cast(lambdaConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * A configuration for an Amazon SNS channel.
         * </p>
         * 
         * @param snsConfiguration
         *        A configuration for an Amazon SNS channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsConfiguration(SNSConfiguration snsConfiguration);

        /**
         * <p>
         * A configuration for an Amazon SNS channel.
         * </p>
         * This is a convenience that creates an instance of the {@link SNSConfiguration.Builder} avoiding the need to
         * create one manually via {@link SNSConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SNSConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #snsConfiguration(SNSConfiguration)}.
         * 
         * @param snsConfiguration
         *        a consumer that will call methods on {@link SNSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsConfiguration(SNSConfiguration)
         */
        default Builder snsConfiguration(Consumer<SNSConfiguration.Builder> snsConfiguration) {
            return snsConfiguration(SNSConfiguration.builder().applyMutation(snsConfiguration).build());
        }

        /**
         * <p>
         * A configuration for an AWS Lambda channel.
         * </p>
         * 
         * @param lambdaConfiguration
         *        A configuration for an AWS Lambda channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConfiguration(LambdaConfiguration lambdaConfiguration);

        /**
         * <p>
         * A configuration for an AWS Lambda channel.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaConfiguration.Builder} avoiding the need
         * to create one manually via {@link LambdaConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaConfiguration(LambdaConfiguration)}.
         * 
         * @param lambdaConfiguration
         *        a consumer that will call methods on {@link LambdaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConfiguration(LambdaConfiguration)
         */
        default Builder lambdaConfiguration(Consumer<LambdaConfiguration.Builder> lambdaConfiguration) {
            return lambdaConfiguration(LambdaConfiguration.builder().applyMutation(lambdaConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SNSConfiguration snsConfiguration;

        private LambdaConfiguration lambdaConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            snsConfiguration(model.snsConfiguration);
            lambdaConfiguration(model.lambdaConfiguration);
        }

        public final SNSConfiguration.Builder getSnsConfiguration() {
            return snsConfiguration != null ? snsConfiguration.toBuilder() : null;
        }

        public final void setSnsConfiguration(SNSConfiguration.BuilderImpl snsConfiguration) {
            this.snsConfiguration = snsConfiguration != null ? snsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder snsConfiguration(SNSConfiguration snsConfiguration) {
            this.snsConfiguration = snsConfiguration;
            return this;
        }

        public final LambdaConfiguration.Builder getLambdaConfiguration() {
            return lambdaConfiguration != null ? lambdaConfiguration.toBuilder() : null;
        }

        public final void setLambdaConfiguration(LambdaConfiguration.BuilderImpl lambdaConfiguration) {
            this.lambdaConfiguration = lambdaConfiguration != null ? lambdaConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaConfiguration(LambdaConfiguration lambdaConfiguration) {
            this.lambdaConfiguration = lambdaConfiguration;
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
