/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration for Amazon SNS-integrated notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alert implements SdkPojo, Serializable, ToCopyableBuilder<Alert.Builder, Alert> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(Alert::action)).setter(setter(Builder::action)).constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> ALERT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertDescription").getter(getter(Alert::alertDescription)).setter(setter(Builder::alertDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertDescription").build()).build();

    private static final SdkField<String> ALERT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertArn").getter(getter(Alert::alertArn)).setter(setter(Builder::alertArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertArn").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(Alert::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> ALERT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertName").getter(getter(Alert::alertName)).setter(setter(Builder::alertName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertName").build()).build();

    private static final SdkField<Integer> ALERT_SENSITIVITY_THRESHOLD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("AlertSensitivityThreshold")
            .getter(getter(Alert::alertSensitivityThreshold)).setter(setter(Builder::alertSensitivityThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSensitivityThreshold").build())
            .build();

    private static final SdkField<String> ALERT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertType").getter(getter(Alert::alertTypeAsString)).setter(setter(Builder::alertType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertType").build()).build();

    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertStatus").getter(getter(Alert::alertStatusAsString)).setter(setter(Builder::alertStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(Alert::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Alert::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            ALERT_DESCRIPTION_FIELD, ALERT_ARN_FIELD, ANOMALY_DETECTOR_ARN_FIELD, ALERT_NAME_FIELD,
            ALERT_SENSITIVITY_THRESHOLD_FIELD, ALERT_TYPE_FIELD, ALERT_STATUS_FIELD, LAST_MODIFICATION_TIME_FIELD,
            CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Action action;

    private final String alertDescription;

    private final String alertArn;

    private final String anomalyDetectorArn;

    private final String alertName;

    private final Integer alertSensitivityThreshold;

    private final String alertType;

    private final String alertStatus;

    private final Instant lastModificationTime;

    private final Instant creationTime;

    private Alert(BuilderImpl builder) {
        this.action = builder.action;
        this.alertDescription = builder.alertDescription;
        this.alertArn = builder.alertArn;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.alertName = builder.alertName;
        this.alertSensitivityThreshold = builder.alertSensitivityThreshold;
        this.alertType = builder.alertType;
        this.alertStatus = builder.alertStatus;
        this.lastModificationTime = builder.lastModificationTime;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * Action that will be triggered when there is an alert.
     * </p>
     * 
     * @return Action that will be triggered when there is an alert.
     */
    public final Action action() {
        return action;
    }

    /**
     * <p>
     * A description of the alert.
     * </p>
     * 
     * @return A description of the alert.
     */
    public final String alertDescription() {
        return alertDescription;
    }

    /**
     * <p>
     * The ARN of the alert.
     * </p>
     * 
     * @return The ARN of the alert.
     */
    public final String alertArn() {
        return alertArn;
    }

    /**
     * <p>
     * The ARN of the detector to which the alert is attached.
     * </p>
     * 
     * @return The ARN of the detector to which the alert is attached.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The name of the alert.
     * </p>
     * 
     * @return The name of the alert.
     */
    public final String alertName() {
        return alertName;
    }

    /**
     * <p>
     * The minimum severity for an anomaly to trigger the alert.
     * </p>
     * 
     * @return The minimum severity for an anomaly to trigger the alert.
     */
    public final Integer alertSensitivityThreshold() {
        return alertSensitivityThreshold;
    }

    /**
     * <p>
     * The type of the alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertType} will
     * return {@link AlertType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alertTypeAsString}.
     * </p>
     * 
     * @return The type of the alert.
     * @see AlertType
     */
    public final AlertType alertType() {
        return AlertType.fromValue(alertType);
    }

    /**
     * <p>
     * The type of the alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertType} will
     * return {@link AlertType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alertTypeAsString}.
     * </p>
     * 
     * @return The type of the alert.
     * @see AlertType
     */
    public final String alertTypeAsString() {
        return alertType;
    }

    /**
     * <p>
     * The status of the alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link AlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The status of the alert.
     * @see AlertStatus
     */
    public final AlertStatus alertStatus() {
        return AlertStatus.fromValue(alertStatus);
    }

    /**
     * <p>
     * The status of the alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link AlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The status of the alert.
     * @see AlertStatus
     */
    public final String alertStatusAsString() {
        return alertStatus;
    }

    /**
     * <p>
     * The time at which the alert was last modified.
     * </p>
     * 
     * @return The time at which the alert was last modified.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The time at which the alert was created.
     * </p>
     * 
     * @return The time at which the alert was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(alertDescription());
        hashCode = 31 * hashCode + Objects.hashCode(alertArn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(alertName());
        hashCode = 31 * hashCode + Objects.hashCode(alertSensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(alertTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alertStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alert)) {
            return false;
        }
        Alert other = (Alert) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(alertDescription(), other.alertDescription())
                && Objects.equals(alertArn(), other.alertArn())
                && Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(alertName(), other.alertName())
                && Objects.equals(alertSensitivityThreshold(), other.alertSensitivityThreshold())
                && Objects.equals(alertTypeAsString(), other.alertTypeAsString())
                && Objects.equals(alertStatusAsString(), other.alertStatusAsString())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Alert").add("Action", action()).add("AlertDescription", alertDescription())
                .add("AlertArn", alertArn()).add("AnomalyDetectorArn", anomalyDetectorArn()).add("AlertName", alertName())
                .add("AlertSensitivityThreshold", alertSensitivityThreshold()).add("AlertType", alertTypeAsString())
                .add("AlertStatus", alertStatusAsString()).add("LastModificationTime", lastModificationTime())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "AlertDescription":
            return Optional.ofNullable(clazz.cast(alertDescription()));
        case "AlertArn":
            return Optional.ofNullable(clazz.cast(alertArn()));
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "AlertName":
            return Optional.ofNullable(clazz.cast(alertName()));
        case "AlertSensitivityThreshold":
            return Optional.ofNullable(clazz.cast(alertSensitivityThreshold()));
        case "AlertType":
            return Optional.ofNullable(clazz.cast(alertTypeAsString()));
        case "AlertStatus":
            return Optional.ofNullable(clazz.cast(alertStatusAsString()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alert, T> g) {
        return obj -> g.apply((Alert) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alert> {
        /**
         * <p>
         * Action that will be triggered when there is an alert.
         * </p>
         * 
         * @param action
         *        Action that will be triggered when there is an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * Action that will be triggered when there is an alert.
         * </p>
         * This is a convenience that creates an instance of the {@link Action.Builder} avoiding the need to create one
         * manually via {@link Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * A description of the alert.
         * </p>
         * 
         * @param alertDescription
         *        A description of the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertDescription(String alertDescription);

        /**
         * <p>
         * The ARN of the alert.
         * </p>
         * 
         * @param alertArn
         *        The ARN of the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertArn(String alertArn);

        /**
         * <p>
         * The ARN of the detector to which the alert is attached.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the detector to which the alert is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The name of the alert.
         * </p>
         * 
         * @param alertName
         *        The name of the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertName(String alertName);

        /**
         * <p>
         * The minimum severity for an anomaly to trigger the alert.
         * </p>
         * 
         * @param alertSensitivityThreshold
         *        The minimum severity for an anomaly to trigger the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertSensitivityThreshold(Integer alertSensitivityThreshold);

        /**
         * <p>
         * The type of the alert.
         * </p>
         * 
         * @param alertType
         *        The type of the alert.
         * @see AlertType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlertType
         */
        Builder alertType(String alertType);

        /**
         * <p>
         * The type of the alert.
         * </p>
         * 
         * @param alertType
         *        The type of the alert.
         * @see AlertType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlertType
         */
        Builder alertType(AlertType alertType);

        /**
         * <p>
         * The status of the alert.
         * </p>
         * 
         * @param alertStatus
         *        The status of the alert.
         * @see AlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlertStatus
         */
        Builder alertStatus(String alertStatus);

        /**
         * <p>
         * The status of the alert.
         * </p>
         * 
         * @param alertStatus
         *        The status of the alert.
         * @see AlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlertStatus
         */
        Builder alertStatus(AlertStatus alertStatus);

        /**
         * <p>
         * The time at which the alert was last modified.
         * </p>
         * 
         * @param lastModificationTime
         *        The time at which the alert was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The time at which the alert was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the alert was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private Action action;

        private String alertDescription;

        private String alertArn;

        private String anomalyDetectorArn;

        private String alertName;

        private Integer alertSensitivityThreshold;

        private String alertType;

        private String alertStatus;

        private Instant lastModificationTime;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Alert model) {
            action(model.action);
            alertDescription(model.alertDescription);
            alertArn(model.alertArn);
            anomalyDetectorArn(model.anomalyDetectorArn);
            alertName(model.alertName);
            alertSensitivityThreshold(model.alertSensitivityThreshold);
            alertType(model.alertType);
            alertStatus(model.alertStatus);
            lastModificationTime(model.lastModificationTime);
            creationTime(model.creationTime);
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        @Transient
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final String getAlertDescription() {
            return alertDescription;
        }

        public final void setAlertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
        }

        @Override
        @Transient
        public final Builder alertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
            return this;
        }

        public final String getAlertArn() {
            return alertArn;
        }

        public final void setAlertArn(String alertArn) {
            this.alertArn = alertArn;
        }

        @Override
        @Transient
        public final Builder alertArn(String alertArn) {
            this.alertArn = alertArn;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getAlertName() {
            return alertName;
        }

        public final void setAlertName(String alertName) {
            this.alertName = alertName;
        }

        @Override
        @Transient
        public final Builder alertName(String alertName) {
            this.alertName = alertName;
            return this;
        }

        public final Integer getAlertSensitivityThreshold() {
            return alertSensitivityThreshold;
        }

        public final void setAlertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
        }

        @Override
        @Transient
        public final Builder alertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
            return this;
        }

        public final String getAlertType() {
            return alertType;
        }

        public final void setAlertType(String alertType) {
            this.alertType = alertType;
        }

        @Override
        @Transient
        public final Builder alertType(String alertType) {
            this.alertType = alertType;
            return this;
        }

        @Override
        @Transient
        public final Builder alertType(AlertType alertType) {
            this.alertType(alertType == null ? null : alertType.toString());
            return this;
        }

        public final String getAlertStatus() {
            return alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        @Transient
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder alertStatus(AlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        @Transient
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Alert build() {
            return new Alert(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
