/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a group of anomalous metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyGroupSummary.Builder, AnomalyGroupSummary> {
    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(AnomalyGroupSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTime").getter(getter(AnomalyGroupSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyGroupId").getter(getter(AnomalyGroupSummary::anomalyGroupId))
            .setter(setter(Builder::anomalyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()).build();

    private static final SdkField<Double> ANOMALY_GROUP_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AnomalyGroupScore").getter(getter(AnomalyGroupSummary::anomalyGroupScore))
            .setter(setter(Builder::anomalyGroupScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupScore").build()).build();

    private static final SdkField<String> PRIMARY_METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryMetricName").getter(getter(AnomalyGroupSummary::primaryMetricName))
            .setter(setter(Builder::primaryMetricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMetricName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, ANOMALY_GROUP_ID_FIELD, ANOMALY_GROUP_SCORE_FIELD, PRIMARY_METRIC_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startTime;

    private final String endTime;

    private final String anomalyGroupId;

    private final Double anomalyGroupScore;

    private final String primaryMetricName;

    private AnomalyGroupSummary(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.anomalyGroupId = builder.anomalyGroupId;
        this.anomalyGroupScore = builder.anomalyGroupScore;
        this.primaryMetricName = builder.primaryMetricName;
    }

    /**
     * <p>
     * The start time for the group.
     * </p>
     * 
     * @return The start time for the group.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the group.
     * </p>
     * 
     * @return The end time for the group.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * The ID of the anomaly group.
     * </p>
     * 
     * @return The ID of the anomaly group.
     */
    public final String anomalyGroupId() {
        return anomalyGroupId;
    }

    /**
     * <p>
     * The severity score of the group.
     * </p>
     * 
     * @return The severity score of the group.
     */
    public final Double anomalyGroupScore() {
        return anomalyGroupScore;
    }

    /**
     * <p>
     * The name of the primary affected measure for the group.
     * </p>
     * 
     * @return The name of the primary affected measure for the group.
     */
    public final String primaryMetricName() {
        return primaryMetricName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupScore());
        hashCode = 31 * hashCode + Objects.hashCode(primaryMetricName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyGroupSummary)) {
            return false;
        }
        AnomalyGroupSummary other = (AnomalyGroupSummary) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(anomalyGroupId(), other.anomalyGroupId())
                && Objects.equals(anomalyGroupScore(), other.anomalyGroupScore())
                && Objects.equals(primaryMetricName(), other.primaryMetricName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyGroupSummary").add("StartTime", startTime()).add("EndTime", endTime())
                .add("AnomalyGroupId", anomalyGroupId()).add("AnomalyGroupScore", anomalyGroupScore())
                .add("PrimaryMetricName", primaryMetricName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "AnomalyGroupId":
            return Optional.ofNullable(clazz.cast(anomalyGroupId()));
        case "AnomalyGroupScore":
            return Optional.ofNullable(clazz.cast(anomalyGroupScore()));
        case "PrimaryMetricName":
            return Optional.ofNullable(clazz.cast(primaryMetricName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyGroupSummary, T> g) {
        return obj -> g.apply((AnomalyGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyGroupSummary> {
        /**
         * <p>
         * The start time for the group.
         * </p>
         * 
         * @param startTime
         *        The start time for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The end time for the group.
         * </p>
         * 
         * @param endTime
         *        The end time for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * The ID of the anomaly group.
         * </p>
         * 
         * @param anomalyGroupId
         *        The ID of the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupId(String anomalyGroupId);

        /**
         * <p>
         * The severity score of the group.
         * </p>
         * 
         * @param anomalyGroupScore
         *        The severity score of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupScore(Double anomalyGroupScore);

        /**
         * <p>
         * The name of the primary affected measure for the group.
         * </p>
         * 
         * @param primaryMetricName
         *        The name of the primary affected measure for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryMetricName(String primaryMetricName);
    }

    static final class BuilderImpl implements Builder {
        private String startTime;

        private String endTime;

        private String anomalyGroupId;

        private Double anomalyGroupScore;

        private String primaryMetricName;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyGroupSummary model) {
            startTime(model.startTime);
            endTime(model.endTime);
            anomalyGroupId(model.anomalyGroupId);
            anomalyGroupScore(model.anomalyGroupScore);
            primaryMetricName(model.primaryMetricName);
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getAnomalyGroupId() {
            return anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        @Transient
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final Double getAnomalyGroupScore() {
            return anomalyGroupScore;
        }

        public final void setAnomalyGroupScore(Double anomalyGroupScore) {
            this.anomalyGroupScore = anomalyGroupScore;
        }

        @Override
        @Transient
        public final Builder anomalyGroupScore(Double anomalyGroupScore) {
            this.anomalyGroupScore = anomalyGroupScore;
            return this;
        }

        public final String getPrimaryMetricName() {
            return primaryMetricName;
        }

        public final void setPrimaryMetricName(String primaryMetricName) {
            this.primaryMetricName = primaryMetricName;
        }

        @Override
        @Transient
        public final Builder primaryMetricName(String primaryMetricName) {
            this.primaryMetricName = primaryMetricName;
            return this;
        }

        @Override
        public AnomalyGroupSummary build() {
            return new AnomalyGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
