/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An anomalous metric in an anomaly group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyGroupTimeSeries implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyGroupTimeSeries.Builder, AnomalyGroupTimeSeries> {
    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyGroupId").getter(getter(AnomalyGroupTimeSeries::anomalyGroupId))
            .setter(setter(Builder::anomalyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()).build();

    private static final SdkField<String> TIME_SERIES_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeSeriesId").getter(getter(AnomalyGroupTimeSeries::timeSeriesId))
            .setter(setter(Builder::timeSeriesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_GROUP_ID_FIELD,
            TIME_SERIES_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String anomalyGroupId;

    private final String timeSeriesId;

    private AnomalyGroupTimeSeries(BuilderImpl builder) {
        this.anomalyGroupId = builder.anomalyGroupId;
        this.timeSeriesId = builder.timeSeriesId;
    }

    /**
     * <p>
     * The ID of the anomaly group.
     * </p>
     * 
     * @return The ID of the anomaly group.
     */
    public final String anomalyGroupId() {
        return anomalyGroupId;
    }

    /**
     * <p>
     * The ID of the metric.
     * </p>
     * 
     * @return The ID of the metric.
     */
    public final String timeSeriesId() {
        return timeSeriesId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyGroupTimeSeries)) {
            return false;
        }
        AnomalyGroupTimeSeries other = (AnomalyGroupTimeSeries) obj;
        return Objects.equals(anomalyGroupId(), other.anomalyGroupId()) && Objects.equals(timeSeriesId(), other.timeSeriesId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyGroupTimeSeries").add("AnomalyGroupId", anomalyGroupId())
                .add("TimeSeriesId", timeSeriesId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyGroupId":
            return Optional.ofNullable(clazz.cast(anomalyGroupId()));
        case "TimeSeriesId":
            return Optional.ofNullable(clazz.cast(timeSeriesId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyGroupTimeSeries, T> g) {
        return obj -> g.apply((AnomalyGroupTimeSeries) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyGroupTimeSeries> {
        /**
         * <p>
         * The ID of the anomaly group.
         * </p>
         * 
         * @param anomalyGroupId
         *        The ID of the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupId(String anomalyGroupId);

        /**
         * <p>
         * The ID of the metric.
         * </p>
         * 
         * @param timeSeriesId
         *        The ID of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesId(String timeSeriesId);
    }

    static final class BuilderImpl implements Builder {
        private String anomalyGroupId;

        private String timeSeriesId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyGroupTimeSeries model) {
            anomalyGroupId(model.anomalyGroupId);
            timeSeriesId(model.timeSeriesId);
        }

        public final String getAnomalyGroupId() {
            return anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        @Transient
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final String getTimeSeriesId() {
            return timeSeriesId;
        }

        public final void setTimeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
        }

        @Override
        @Transient
        public final Builder timeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
            return this;
        }

        @Override
        public AnomalyGroupTimeSeries build() {
            return new AnomalyGroupTimeSeries(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
