/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon AppFlow flow datasource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppFlowConfig implements SdkPojo, Serializable, ToCopyableBuilder<AppFlowConfig.Builder, AppFlowConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AppFlowConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowName").getter(getter(AppFlowConfig::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            FLOW_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String flowName;

    private AppFlowConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.flowName = builder.flowName;
    }

    /**
     * <p>
     * An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
     * </p>
     * 
     * @return An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * name of the flow.
     * </p>
     * 
     * @return name of the flow.
     */
    public final String flowName() {
        return flowName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppFlowConfig)) {
            return false;
        }
        AppFlowConfig other = (AppFlowConfig) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(flowName(), other.flowName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppFlowConfig").add("RoleArn", roleArn()).add("FlowName", flowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "FlowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppFlowConfig, T> g) {
        return obj -> g.apply((AppFlowConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppFlowConfig> {
        /**
         * <p>
         * An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
         * </p>
         * 
         * @param roleArn
         *        An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * name of the flow.
         * </p>
         * 
         * @param flowName
         *        name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String flowName;

        private BuilderImpl() {
        }

        private BuilderImpl(AppFlowConfig model) {
            roleArn(model.roleArn);
            flowName(model.flowName);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        @Transient
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        @Override
        public AppFlowConfig build() {
            return new AppFlowConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
