/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomalyDetectorsResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<ListAnomalyDetectorsResponse.Builder, ListAnomalyDetectorsResponse> {
    private static final SdkField<List<AnomalyDetectorSummary>> ANOMALY_DETECTOR_SUMMARY_LIST_FIELD = SdkField
            .<List<AnomalyDetectorSummary>> builder(MarshallingType.LIST)
            .memberName("AnomalyDetectorSummaryList")
            .getter(getter(ListAnomalyDetectorsResponse::anomalyDetectorSummaryList))
            .setter(setter(Builder::anomalyDetectorSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnomalyDetectorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnomalyDetectorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnomalyDetectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANOMALY_DETECTOR_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<AnomalyDetectorSummary> anomalyDetectorSummaryList;

    private final String nextToken;

    private ListAnomalyDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorSummaryList = builder.anomalyDetectorSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnomalyDetectorSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAnomalyDetectorSummaryList() {
        return anomalyDetectorSummaryList != null && !(anomalyDetectorSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of anomaly detectors in the account in the current region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnomalyDetectorSummaryList} method.
     * </p>
     * 
     * @return A list of anomaly detectors in the account in the current region.
     */
    public final List<AnomalyDetectorSummary> anomalyDetectorSummaryList() {
        return anomalyDetectorSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, the service returns this token. To retrieve the next set of results, use the token
     * in the next request.
     * </p>
     * 
     * @return If the response is truncated, the service returns this token. To retrieve the next set of results, use
     *         the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnomalyDetectorSummaryList() ? anomalyDetectorSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyDetectorsResponse)) {
            return false;
        }
        ListAnomalyDetectorsResponse other = (ListAnomalyDetectorsResponse) obj;
        return hasAnomalyDetectorSummaryList() == other.hasAnomalyDetectorSummaryList()
                && Objects.equals(anomalyDetectorSummaryList(), other.anomalyDetectorSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomalyDetectorsResponse")
                .add("AnomalyDetectorSummaryList", hasAnomalyDetectorSummaryList() ? anomalyDetectorSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorSummaryList":
            return Optional.ofNullable(clazz.cast(anomalyDetectorSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyDetectorsResponse, T> g) {
        return obj -> g.apply((ListAnomalyDetectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnomalyDetectorsResponse> {
        /**
         * <p>
         * A list of anomaly detectors in the account in the current region.
         * </p>
         * 
         * @param anomalyDetectorSummaryList
         *        A list of anomaly detectors in the account in the current region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorSummaryList(Collection<AnomalyDetectorSummary> anomalyDetectorSummaryList);

        /**
         * <p>
         * A list of anomaly detectors in the account in the current region.
         * </p>
         * 
         * @param anomalyDetectorSummaryList
         *        A list of anomaly detectors in the account in the current region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorSummaryList(AnomalyDetectorSummary... anomalyDetectorSummaryList);

        /**
         * <p>
         * A list of anomaly detectors in the account in the current region.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AnomalyDetectorSummary>.Builder} avoiding
         * the need to create one manually via {@link List<AnomalyDetectorSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnomalyDetectorSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #anomalyDetectorSummaryList(List<AnomalyDetectorSummary>)}.
         * 
         * @param anomalyDetectorSummaryList
         *        a consumer that will call methods on {@link List<AnomalyDetectorSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyDetectorSummaryList(List<AnomalyDetectorSummary>)
         */
        Builder anomalyDetectorSummaryList(Consumer<AnomalyDetectorSummary.Builder>... anomalyDetectorSummaryList);

        /**
         * <p>
         * If the response is truncated, the service returns this token. To retrieve the next set of results, use the
         * token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the service returns this token. To retrieve the next set of results, use
         *        the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private List<AnomalyDetectorSummary> anomalyDetectorSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyDetectorsResponse model) {
            super(model);
            anomalyDetectorSummaryList(model.anomalyDetectorSummaryList);
            nextToken(model.nextToken);
        }

        public final List<AnomalyDetectorSummary.Builder> getAnomalyDetectorSummaryList() {
            List<AnomalyDetectorSummary.Builder> result = AnomalyDetectorSummaryListCopier
                    .copyToBuilder(this.anomalyDetectorSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalyDetectorSummaryList(Collection<AnomalyDetectorSummary.BuilderImpl> anomalyDetectorSummaryList) {
            this.anomalyDetectorSummaryList = AnomalyDetectorSummaryListCopier.copyFromBuilder(anomalyDetectorSummaryList);
        }

        @Override
        @Transient
        public final Builder anomalyDetectorSummaryList(Collection<AnomalyDetectorSummary> anomalyDetectorSummaryList) {
            this.anomalyDetectorSummaryList = AnomalyDetectorSummaryListCopier.copy(anomalyDetectorSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder anomalyDetectorSummaryList(AnomalyDetectorSummary... anomalyDetectorSummaryList) {
            anomalyDetectorSummaryList(Arrays.asList(anomalyDetectorSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder anomalyDetectorSummaryList(Consumer<AnomalyDetectorSummary.Builder>... anomalyDetectorSummaryList) {
            anomalyDetectorSummaryList(Stream.of(anomalyDetectorSummaryList)
                    .map(c -> AnomalyDetectorSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnomalyDetectorsResponse build() {
            return new ListAnomalyDetectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
