/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomalyGroupSummariesResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<ListAnomalyGroupSummariesResponse.Builder, ListAnomalyGroupSummariesResponse> {
    private static final SdkField<List<AnomalyGroupSummary>> ANOMALY_GROUP_SUMMARY_LIST_FIELD = SdkField
            .<List<AnomalyGroupSummary>> builder(MarshallingType.LIST)
            .memberName("AnomalyGroupSummaryList")
            .getter(getter(ListAnomalyGroupSummariesResponse::anomalyGroupSummaryList))
            .setter(setter(Builder::anomalyGroupSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnomalyGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnomalyGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AnomalyGroupStatistics> ANOMALY_GROUP_STATISTICS_FIELD = SdkField
            .<AnomalyGroupStatistics> builder(MarshallingType.SDK_POJO).memberName("AnomalyGroupStatistics")
            .getter(getter(ListAnomalyGroupSummariesResponse::anomalyGroupStatistics))
            .setter(setter(Builder::anomalyGroupStatistics)).constructor(AnomalyGroupStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupStatistics").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnomalyGroupSummariesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANOMALY_GROUP_SUMMARY_LIST_FIELD, ANOMALY_GROUP_STATISTICS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AnomalyGroupSummary> anomalyGroupSummaryList;

    private final AnomalyGroupStatistics anomalyGroupStatistics;

    private final String nextToken;

    private ListAnomalyGroupSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyGroupSummaryList = builder.anomalyGroupSummaryList;
        this.anomalyGroupStatistics = builder.anomalyGroupStatistics;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnomalyGroupSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAnomalyGroupSummaryList() {
        return anomalyGroupSummaryList != null && !(anomalyGroupSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of anomaly group summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnomalyGroupSummaryList} method.
     * </p>
     * 
     * @return A list of anomaly group summaries.
     */
    public final List<AnomalyGroupSummary> anomalyGroupSummaryList() {
        return anomalyGroupSummaryList;
    }

    /**
     * <p>
     * Aggregated details about the anomaly groups.
     * </p>
     * 
     * @return Aggregated details about the anomaly groups.
     */
    public final AnomalyGroupStatistics anomalyGroupStatistics() {
        return anomalyGroupStatistics;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnomalyGroupSummaryList() ? anomalyGroupSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyGroupSummariesResponse)) {
            return false;
        }
        ListAnomalyGroupSummariesResponse other = (ListAnomalyGroupSummariesResponse) obj;
        return hasAnomalyGroupSummaryList() == other.hasAnomalyGroupSummaryList()
                && Objects.equals(anomalyGroupSummaryList(), other.anomalyGroupSummaryList())
                && Objects.equals(anomalyGroupStatistics(), other.anomalyGroupStatistics())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomalyGroupSummariesResponse")
                .add("AnomalyGroupSummaryList", hasAnomalyGroupSummaryList() ? anomalyGroupSummaryList() : null)
                .add("AnomalyGroupStatistics", anomalyGroupStatistics()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyGroupSummaryList":
            return Optional.ofNullable(clazz.cast(anomalyGroupSummaryList()));
        case "AnomalyGroupStatistics":
            return Optional.ofNullable(clazz.cast(anomalyGroupStatistics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyGroupSummariesResponse, T> g) {
        return obj -> g.apply((ListAnomalyGroupSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnomalyGroupSummariesResponse> {
        /**
         * <p>
         * A list of anomaly group summaries.
         * </p>
         * 
         * @param anomalyGroupSummaryList
         *        A list of anomaly group summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupSummaryList(Collection<AnomalyGroupSummary> anomalyGroupSummaryList);

        /**
         * <p>
         * A list of anomaly group summaries.
         * </p>
         * 
         * @param anomalyGroupSummaryList
         *        A list of anomaly group summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupSummaryList(AnomalyGroupSummary... anomalyGroupSummaryList);

        /**
         * <p>
         * A list of anomaly group summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AnomalyGroupSummary>.Builder} avoiding the
         * need to create one manually via {@link List<AnomalyGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnomalyGroupSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #anomalyGroupSummaryList(List<AnomalyGroupSummary>)}.
         * 
         * @param anomalyGroupSummaryList
         *        a consumer that will call methods on {@link List<AnomalyGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyGroupSummaryList(List<AnomalyGroupSummary>)
         */
        Builder anomalyGroupSummaryList(Consumer<AnomalyGroupSummary.Builder>... anomalyGroupSummaryList);

        /**
         * <p>
         * Aggregated details about the anomaly groups.
         * </p>
         * 
         * @param anomalyGroupStatistics
         *        Aggregated details about the anomaly groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupStatistics(AnomalyGroupStatistics anomalyGroupStatistics);

        /**
         * <p>
         * Aggregated details about the anomaly groups.
         * </p>
         * This is a convenience that creates an instance of the {@link AnomalyGroupStatistics.Builder} avoiding the
         * need to create one manually via {@link AnomalyGroupStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalyGroupStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #anomalyGroupStatistics(AnomalyGroupStatistics)}.
         * 
         * @param anomalyGroupStatistics
         *        a consumer that will call methods on {@link AnomalyGroupStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyGroupStatistics(AnomalyGroupStatistics)
         */
        default Builder anomalyGroupStatistics(Consumer<AnomalyGroupStatistics.Builder> anomalyGroupStatistics) {
            return anomalyGroupStatistics(AnomalyGroupStatistics.builder().applyMutation(anomalyGroupStatistics).build());
        }

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private List<AnomalyGroupSummary> anomalyGroupSummaryList = DefaultSdkAutoConstructList.getInstance();

        private AnomalyGroupStatistics anomalyGroupStatistics;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyGroupSummariesResponse model) {
            super(model);
            anomalyGroupSummaryList(model.anomalyGroupSummaryList);
            anomalyGroupStatistics(model.anomalyGroupStatistics);
            nextToken(model.nextToken);
        }

        public final List<AnomalyGroupSummary.Builder> getAnomalyGroupSummaryList() {
            List<AnomalyGroupSummary.Builder> result = AnomalyGroupSummaryListCopier.copyToBuilder(this.anomalyGroupSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalyGroupSummaryList(Collection<AnomalyGroupSummary.BuilderImpl> anomalyGroupSummaryList) {
            this.anomalyGroupSummaryList = AnomalyGroupSummaryListCopier.copyFromBuilder(anomalyGroupSummaryList);
        }

        @Override
        @Transient
        public final Builder anomalyGroupSummaryList(Collection<AnomalyGroupSummary> anomalyGroupSummaryList) {
            this.anomalyGroupSummaryList = AnomalyGroupSummaryListCopier.copy(anomalyGroupSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder anomalyGroupSummaryList(AnomalyGroupSummary... anomalyGroupSummaryList) {
            anomalyGroupSummaryList(Arrays.asList(anomalyGroupSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder anomalyGroupSummaryList(Consumer<AnomalyGroupSummary.Builder>... anomalyGroupSummaryList) {
            anomalyGroupSummaryList(Stream.of(anomalyGroupSummaryList)
                    .map(c -> AnomalyGroupSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnomalyGroupStatistics.Builder getAnomalyGroupStatistics() {
            return anomalyGroupStatistics != null ? anomalyGroupStatistics.toBuilder() : null;
        }

        public final void setAnomalyGroupStatistics(AnomalyGroupStatistics.BuilderImpl anomalyGroupStatistics) {
            this.anomalyGroupStatistics = anomalyGroupStatistics != null ? anomalyGroupStatistics.build() : null;
        }

        @Override
        @Transient
        public final Builder anomalyGroupStatistics(AnomalyGroupStatistics anomalyGroupStatistics) {
            this.anomalyGroupStatistics = anomalyGroupStatistics;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnomalyGroupSummariesResponse build() {
            return new ListAnomalyGroupSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
