/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SnsFormat {
    LONG_TEXT("LONG_TEXT"),
    SHORT_TEXT("SHORT_TEXT"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SnsFormat> VALUE_MAP;
    private final String value;

    private SnsFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SnsFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SnsFormat> knownValues() {
        EnumSet<SnsFormat> knownValues = EnumSet.allOf(SnsFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SnsFormat.class, SnsFormat::toString);
    }
}

