/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lookoutmetrics.model.AccessDeniedException;
import software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ConflictException;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.InternalServerException;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsException;
import software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lookoutmetrics.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lookoutmetrics.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.TooManyRequestsException;
import software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.ValidationException;
import software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesIterable;
import software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsIterable;

/**
 * Service client for accessing LookoutMetrics. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the <i>Amazon Lookout for Metrics API Reference</i>. For an introduction to the service with tutorials for
 * getting started, visit <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev">Amazon Lookout for Metrics
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LookoutMetricsClient extends AwsClient {
    String SERVICE_NAME = "lookoutmetrics";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "lookoutmetrics";

    /**
     * <p>
     * Activates an anomaly detector.
     * </p>
     *
     * @param activateAnomalyDetectorRequest
     * @return Result of the ActivateAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ActivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ActivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateAnomalyDetectorResponse activateAnomalyDetector(ActivateAnomalyDetectorRequest activateAnomalyDetectorRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link ActivateAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param activateAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ActivateAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return Result of the ActivateAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ActivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ActivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateAnomalyDetectorResponse activateAnomalyDetector(
            Consumer<ActivateAnomalyDetectorRequest.Builder> activateAnomalyDetectorRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException,
            ConflictException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return activateAnomalyDetector(ActivateAnomalyDetectorRequest.builder().applyMutation(activateAnomalyDetectorRequest)
                .build());
    }

    /**
     * <p>
     * Runs a backtest for anomaly detection for the specified resource.
     * </p>
     *
     * @param backTestAnomalyDetectorRequest
     * @return Result of the BackTestAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.BackTestAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/BackTestAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default BackTestAnomalyDetectorResponse backTestAnomalyDetector(BackTestAnomalyDetectorRequest backTestAnomalyDetectorRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a backtest for anomaly detection for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BackTestAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link BackTestAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param backTestAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.BackTestAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return Result of the BackTestAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.BackTestAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/BackTestAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default BackTestAnomalyDetectorResponse backTestAnomalyDetector(
            Consumer<BackTestAnomalyDetectorRequest.Builder> backTestAnomalyDetectorRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        return backTestAnomalyDetector(BackTestAnomalyDetectorRequest.builder().applyMutation(backTestAnomalyDetectorRequest)
                .build());
    }

    /**
     * <p>
     * Creates an alert for an anomaly detector.
     * </p>
     *
     * @param createAlertRequest
     * @return Result of the CreateAlert operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAlertResponse createAlert(CreateAlertRequest createAlertRequest) throws ConflictException, ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, TooManyRequestsException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alert for an anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAlertRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAlertRequest#builder()}
     * </p>
     *
     * @param createAlertRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.CreateAlertRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAlert operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAlertResponse createAlert(Consumer<CreateAlertRequest.Builder> createAlertRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, TooManyRequestsException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return createAlert(CreateAlertRequest.builder().applyMutation(createAlertRequest).build());
    }

    /**
     * <p>
     * Creates an anomaly detector.
     * </p>
     *
     * @param createAnomalyDetectorRequest
     * @return Result of the CreateAnomalyDetector operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAnomalyDetectorResponse createAnomalyDetector(CreateAnomalyDetectorRequest createAnomalyDetectorRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnomalyDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param createAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.CreateAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAnomalyDetector operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAnomalyDetectorResponse createAnomalyDetector(
            Consumer<CreateAnomalyDetectorRequest.Builder> createAnomalyDetectorRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return createAnomalyDetector(CreateAnomalyDetectorRequest.builder().applyMutation(createAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     *
     * @param createMetricSetRequest
     * @return Result of the CreateMetricSet operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMetricSetResponse createMetricSet(CreateMetricSetRequest createMetricSetRequest) throws ConflictException,
            ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, AccessDeniedException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMetricSetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMetricSetRequest#builder()}
     * </p>
     *
     * @param createMetricSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.CreateMetricSetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMetricSet operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.CreateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/CreateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMetricSetResponse createMetricSet(Consumer<CreateMetricSetRequest.Builder> createMetricSetRequest)
            throws ConflictException, ValidationException, ResourceNotFoundException, ServiceQuotaExceededException,
            AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            LookoutMetricsException {
        return createMetricSet(CreateMetricSetRequest.builder().applyMutation(createMetricSetRequest).build());
    }

    /**
     * <p>
     * Deactivates an anomaly detector.
     * </p>
     *
     * @param deactivateAnomalyDetectorRequest
     * @return Result of the DeactivateAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeactivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeactivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeactivateAnomalyDetectorResponse deactivateAnomalyDetector(
            DeactivateAnomalyDetectorRequest deactivateAnomalyDetectorRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates an anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link DeactivateAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param deactivateAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DeactivateAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return Result of the DeactivateAnomalyDetector operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeactivateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeactivateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeactivateAnomalyDetectorResponse deactivateAnomalyDetector(
            Consumer<DeactivateAnomalyDetectorRequest.Builder> deactivateAnomalyDetectorRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return deactivateAnomalyDetector(DeactivateAnomalyDetectorRequest.builder()
                .applyMutation(deactivateAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Deletes an alert.
     * </p>
     *
     * @param deleteAlertRequest
     * @return Result of the DeleteAlert operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeleteAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAlertResponse deleteAlert(DeleteAlertRequest deleteAlertRequest) throws ResourceNotFoundException,
            ValidationException, TooManyRequestsException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlertRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAlertRequest#builder()}
     * </p>
     *
     * @param deleteAlertRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DeleteAlertRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAlert operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeleteAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAlertResponse deleteAlert(Consumer<DeleteAlertRequest.Builder> deleteAlertRequest)
            throws ResourceNotFoundException, ValidationException, TooManyRequestsException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return deleteAlert(DeleteAlertRequest.builder().applyMutation(deleteAlertRequest).build());
    }

    /**
     * <p>
     * Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any
     * configured datasets and alerts.
     * </p>
     *
     * @param deleteAnomalyDetectorRequest
     * @return Result of the DeleteAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeleteAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAnomalyDetectorResponse deleteAnomalyDetector(DeleteAnomalyDetectorRequest deleteAnomalyDetectorRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, TooManyRequestsException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any
     * configured datasets and alerts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnomalyDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param deleteAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DeleteAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DeleteAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DeleteAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAnomalyDetectorResponse deleteAnomalyDetector(
            Consumer<DeleteAnomalyDetectorRequest.Builder> deleteAnomalyDetectorRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, TooManyRequestsException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        return deleteAnomalyDetector(DeleteAnomalyDetectorRequest.builder().applyMutation(deleteAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Describes an alert.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeAlertRequest
     * @return Result of the DescribeAlert operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlertResponse describeAlert(DescribeAlertRequest describeAlertRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an alert.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlertRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAlertRequest#builder()}
     * </p>
     *
     * @param describeAlertRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DescribeAlertRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAlert operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlertResponse describeAlert(Consumer<DescribeAlertRequest.Builder> describeAlertRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return describeAlert(DescribeAlertRequest.builder().applyMutation(describeAlertRequest).build());
    }

    /**
     * <p>
     * Returns information about the status of the specified anomaly detection jobs.
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     * @return Result of the DescribeAnomalyDetectionExecutions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnomalyDetectionExecutionsResponse describeAnomalyDetectionExecutions(
            DescribeAnomalyDetectionExecutionsRequest describeAnomalyDetectionExecutionsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the status of the specified anomaly detection jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnomalyDetectionExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAnomalyDetectionExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeAnomalyDetectionExecutions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnomalyDetectionExecutionsResponse describeAnomalyDetectionExecutions(
            Consumer<DescribeAnomalyDetectionExecutionsRequest.Builder> describeAnomalyDetectionExecutionsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return describeAnomalyDetectionExecutions(DescribeAnomalyDetectionExecutionsRequest.builder()
                .applyMutation(describeAnomalyDetectionExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAnomalyDetectionExecutions(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsIterable responses = client.describeAnomalyDetectionExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsIterable responses = client
     *             .describeAnomalyDetectionExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsIterable responses = client.describeAnomalyDetectionExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAnomalyDetectionExecutions(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnomalyDetectionExecutionsIterable describeAnomalyDetectionExecutionsPaginator(
            DescribeAnomalyDetectionExecutionsRequest describeAnomalyDetectionExecutionsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new DescribeAnomalyDetectionExecutionsIterable(this, describeAnomalyDetectionExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAnomalyDetectionExecutions(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsIterable responses = client.describeAnomalyDetectionExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsIterable responses = client
     *             .describeAnomalyDetectionExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.DescribeAnomalyDetectionExecutionsIterable responses = client.describeAnomalyDetectionExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAnomalyDetectionExecutions(software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnomalyDetectionExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAnomalyDetectionExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAnomalyDetectionExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAnomalyDetectionExecutions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetectionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnomalyDetectionExecutionsIterable describeAnomalyDetectionExecutionsPaginator(
            Consumer<DescribeAnomalyDetectionExecutionsRequest.Builder> describeAnomalyDetectionExecutionsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return describeAnomalyDetectionExecutionsPaginator(DescribeAnomalyDetectionExecutionsRequest.builder()
                .applyMutation(describeAnomalyDetectionExecutionsRequest).build());
    }

    /**
     * <p>
     * Describes a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeAnomalyDetectorRequest
     * @return Result of the DescribeAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnomalyDetectorResponse describeAnomalyDetector(DescribeAnomalyDetectorRequest describeAnomalyDetectorRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param describeAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DescribeAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnomalyDetectorResponse describeAnomalyDetector(
            Consumer<DescribeAnomalyDetectorRequest.Builder> describeAnomalyDetectorRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return describeAnomalyDetector(DescribeAnomalyDetectorRequest.builder().applyMutation(describeAnomalyDetectorRequest)
                .build());
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param describeMetricSetRequest
     * @return Result of the DescribeMetricSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetricSetResponse describeMetricSet(DescribeMetricSetRequest describeMetricSetRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetricSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMetricSetRequest#builder()}
     * </p>
     *
     * @param describeMetricSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DescribeMetricSetRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeMetricSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DescribeMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DescribeMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetricSetResponse describeMetricSet(Consumer<DescribeMetricSetRequest.Builder> describeMetricSetRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return describeMetricSet(DescribeMetricSetRequest.builder().applyMutation(describeMetricSetRequest).build());
    }

    /**
     * <p>
     * Detects an Amazon S3 dataset's file format, interval, and offset.
     * </p>
     *
     * @param detectMetricSetConfigRequest
     * @return Result of the DetectMetricSetConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DetectMetricSetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DetectMetricSetConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectMetricSetConfigResponse detectMetricSetConfig(DetectMetricSetConfigRequest detectMetricSetConfigRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects an Amazon S3 dataset's file format, interval, and offset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectMetricSetConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DetectMetricSetConfigRequest#builder()}
     * </p>
     *
     * @param detectMetricSetConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DetectMetricSetConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DetectMetricSetConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.DetectMetricSetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/DetectMetricSetConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectMetricSetConfigResponse detectMetricSetConfig(
            Consumer<DetectMetricSetConfigRequest.Builder> detectMetricSetConfigRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return detectMetricSetConfig(DetectMetricSetConfigRequest.builder().applyMutation(detectMetricSetConfigRequest).build());
    }

    /**
     * <p>
     * Returns details about a group of anomalous metrics.
     * </p>
     *
     * @param getAnomalyGroupRequest
     * @return Result of the GetAnomalyGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetAnomalyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetAnomalyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAnomalyGroupResponse getAnomalyGroup(GetAnomalyGroupRequest getAnomalyGroupRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a group of anomalous metrics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnomalyGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetAnomalyGroupRequest#builder()}
     * </p>
     *
     * @param getAnomalyGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.GetAnomalyGroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetAnomalyGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetAnomalyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetAnomalyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAnomalyGroupResponse getAnomalyGroup(Consumer<GetAnomalyGroupRequest.Builder> getAnomalyGroupRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return getAnomalyGroup(GetAnomalyGroupRequest.builder().applyMutation(getAnomalyGroupRequest).build());
    }

    /**
     * <p>
     * Returns details about the requested data quality metrics.
     * </p>
     *
     * @param getDataQualityMetricsRequest
     * @return Result of the GetDataQualityMetrics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetDataQualityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetDataQualityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataQualityMetricsResponse getDataQualityMetrics(GetDataQualityMetricsRequest getDataQualityMetricsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the requested data quality metrics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataQualityMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataQualityMetricsRequest#builder()}
     * </p>
     *
     * @param getDataQualityMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.GetDataQualityMetricsRequest.Builder} to
     *        create a request.
     * @return Result of the GetDataQualityMetrics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetDataQualityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetDataQualityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataQualityMetricsResponse getDataQualityMetrics(
            Consumer<GetDataQualityMetricsRequest.Builder> getDataQualityMetricsRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return getDataQualityMetrics(GetDataQualityMetricsRequest.builder().applyMutation(getDataQualityMetricsRequest).build());
    }

    /**
     * <p>
     * Get feedback for an anomaly group.
     * </p>
     *
     * @param getFeedbackRequest
     * @return Result of the GetFeedback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFeedbackResponse getFeedback(GetFeedbackRequest getFeedbackRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get feedback for an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link GetFeedbackRequest#builder()}
     * </p>
     *
     * @param getFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest.Builder} to create a
     *        request.
     * @return Result of the GetFeedback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFeedbackResponse getFeedback(Consumer<GetFeedbackRequest.Builder> getFeedbackRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return getFeedback(GetFeedbackRequest.builder().applyMutation(getFeedbackRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getFeedback(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackIterable responses = client.getFeedbackPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackIterable responses = client
     *             .getFeedbackPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackIterable responses = client.getFeedbackPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFeedback(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest)} operation.</b>
     * </p>
     *
     * @param getFeedbackRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFeedbackIterable getFeedbackPaginator(GetFeedbackRequest getFeedbackRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return new GetFeedbackIterable(this, getFeedbackRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getFeedback(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackIterable responses = client.getFeedbackPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackIterable responses = client
     *             .getFeedbackPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.GetFeedbackIterable responses = client.getFeedbackPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFeedback(software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link GetFeedbackRequest#builder()}
     * </p>
     *
     * @param getFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFeedbackIterable getFeedbackPaginator(Consumer<GetFeedbackRequest.Builder> getFeedbackRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return getFeedbackPaginator(GetFeedbackRequest.builder().applyMutation(getFeedbackRequest).build());
    }

    /**
     * <p>
     * Returns a selection of sample records from an Amazon S3 datasource.
     * </p>
     *
     * @param getSampleDataRequest
     * @return Result of the GetSampleData operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetSampleData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetSampleData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSampleDataResponse getSampleData(GetSampleDataRequest getSampleDataRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a selection of sample records from an Amazon S3 datasource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSampleDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetSampleDataRequest#builder()}
     * </p>
     *
     * @param getSampleDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.GetSampleDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetSampleData operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.GetSampleData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/GetSampleData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSampleDataResponse getSampleData(Consumer<GetSampleDataRequest.Builder> getSampleDataRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return getSampleData(GetSampleDataRequest.builder().applyMutation(getSampleDataRequest).build());
    }

    /**
     * <p>
     * Lists the alerts attached to a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listAlertsRequest
     * @return Result of the ListAlerts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsResponse listAlerts(ListAlertsRequest listAlertsRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, TooManyRequestsException, ValidationException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the alerts attached to a detector.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlertsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlertsRequest#builder()}
     * </p>
     *
     * @param listAlertsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAlerts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsResponse listAlerts(Consumer<ListAlertsRequest.Builder> listAlertsRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, TooManyRequestsException,
            ValidationException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listAlerts(ListAlertsRequest.builder().applyMutation(listAlertsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAlerts(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlerts(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest)} operation.</b>
     * </p>
     *
     * @param listAlertsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsIterable listAlertsPaginator(ListAlertsRequest listAlertsRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, TooManyRequestsException, ValidationException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return new ListAlertsIterable(this, listAlertsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAlerts(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlerts(software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlertsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlertsRequest#builder()}
     * </p>
     *
     * @param listAlertsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsIterable listAlertsPaginator(Consumer<ListAlertsRequest.Builder> listAlertsRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, TooManyRequestsException,
            ValidationException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listAlertsPaginator(ListAlertsRequest.builder().applyMutation(listAlertsRequest).build());
    }

    /**
     * <p>
     * Lists the detectors in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     * @return Result of the ListAnomalyDetectors operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyDetectorsResponse listAnomalyDetectors(ListAnomalyDetectorsRequest listAnomalyDetectorsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the detectors in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyDetectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnomalyDetectorsRequest#builder()}
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest.Builder} to create
     *        a request.
     * @return Result of the ListAnomalyDetectors operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyDetectorsResponse listAnomalyDetectors(
            Consumer<ListAnomalyDetectorsRequest.Builder> listAnomalyDetectorsRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return listAnomalyDetectors(ListAnomalyDetectorsRequest.builder().applyMutation(listAnomalyDetectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalyDetectors(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsIterable responses = client.listAnomalyDetectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsIterable responses = client
     *             .listAnomalyDetectorsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsIterable responses = client.listAnomalyDetectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyDetectors(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyDetectorsIterable listAnomalyDetectorsPaginator(ListAnomalyDetectorsRequest listAnomalyDetectorsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new ListAnomalyDetectorsIterable(this, listAnomalyDetectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalyDetectors(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsIterable responses = client.listAnomalyDetectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsIterable responses = client
     *             .listAnomalyDetectorsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyDetectorsIterable responses = client.listAnomalyDetectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyDetectors(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyDetectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnomalyDetectorsRequest#builder()}
     * </p>
     *
     * @param listAnomalyDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyDetectorsIterable listAnomalyDetectorsPaginator(
            Consumer<ListAnomalyDetectorsRequest.Builder> listAnomalyDetectorsRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return listAnomalyDetectorsPaginator(ListAnomalyDetectorsRequest.builder().applyMutation(listAnomalyDetectorsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of measures that are potential causes or effects of an anomaly group.
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     * @return Result of the ListAnomalyGroupRelatedMetrics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupRelatedMetricsResponse listAnomalyGroupRelatedMetrics(
            ListAnomalyGroupRelatedMetricsRequest listAnomalyGroupRelatedMetricsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of measures that are potential causes or effects of an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupRelatedMetricsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAnomalyGroupRelatedMetricsRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest.Builder}
     *        to create a request.
     * @return Result of the ListAnomalyGroupRelatedMetrics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupRelatedMetricsResponse listAnomalyGroupRelatedMetrics(
            Consumer<ListAnomalyGroupRelatedMetricsRequest.Builder> listAnomalyGroupRelatedMetricsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listAnomalyGroupRelatedMetrics(ListAnomalyGroupRelatedMetricsRequest.builder()
                .applyMutation(listAnomalyGroupRelatedMetricsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupRelatedMetrics(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsIterable responses = client.listAnomalyGroupRelatedMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsIterable responses = client
     *             .listAnomalyGroupRelatedMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsIterable responses = client.listAnomalyGroupRelatedMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupRelatedMetrics(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupRelatedMetricsIterable listAnomalyGroupRelatedMetricsPaginator(
            ListAnomalyGroupRelatedMetricsRequest listAnomalyGroupRelatedMetricsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return new ListAnomalyGroupRelatedMetricsIterable(this, listAnomalyGroupRelatedMetricsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupRelatedMetrics(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsIterable responses = client.listAnomalyGroupRelatedMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsIterable responses = client
     *             .listAnomalyGroupRelatedMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupRelatedMetricsIterable responses = client.listAnomalyGroupRelatedMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupRelatedMetrics(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupRelatedMetricsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAnomalyGroupRelatedMetricsRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupRelatedMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupRelatedMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupRelatedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupRelatedMetricsIterable listAnomalyGroupRelatedMetricsPaginator(
            Consumer<ListAnomalyGroupRelatedMetricsRequest.Builder> listAnomalyGroupRelatedMetricsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listAnomalyGroupRelatedMetricsPaginator(ListAnomalyGroupRelatedMetricsRequest.builder()
                .applyMutation(listAnomalyGroupRelatedMetricsRequest).build());
    }

    /**
     * <p>
     * Returns a list of anomaly groups.
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     * @return Result of the ListAnomalyGroupSummaries operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupSummariesResponse listAnomalyGroupSummaries(
            ListAnomalyGroupSummariesRequest listAnomalyGroupSummariesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of anomaly groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomalyGroupSummariesRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest.Builder} to
     *        create a request.
     * @return Result of the ListAnomalyGroupSummaries operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupSummariesResponse listAnomalyGroupSummaries(
            Consumer<ListAnomalyGroupSummariesRequest.Builder> listAnomalyGroupSummariesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listAnomalyGroupSummaries(ListAnomalyGroupSummariesRequest.builder()
                .applyMutation(listAnomalyGroupSummariesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupSummaries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesIterable responses = client.listAnomalyGroupSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesIterable responses = client
     *             .listAnomalyGroupSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesIterable responses = client.listAnomalyGroupSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupSummaries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupSummariesIterable listAnomalyGroupSummariesPaginator(
            ListAnomalyGroupSummariesRequest listAnomalyGroupSummariesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return new ListAnomalyGroupSummariesIterable(this, listAnomalyGroupSummariesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupSummaries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesIterable responses = client.listAnomalyGroupSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesIterable responses = client
     *             .listAnomalyGroupSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupSummariesIterable responses = client.listAnomalyGroupSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupSummaries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomalyGroupSummariesRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupSummariesIterable listAnomalyGroupSummariesPaginator(
            Consumer<ListAnomalyGroupSummariesRequest.Builder> listAnomalyGroupSummariesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listAnomalyGroupSummariesPaginator(ListAnomalyGroupSummariesRequest.builder()
                .applyMutation(listAnomalyGroupSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of anomalous metrics for a measure in an anomaly group.
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     * @return Result of the ListAnomalyGroupTimeSeries operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupTimeSeriesResponse listAnomalyGroupTimeSeries(
            ListAnomalyGroupTimeSeriesRequest listAnomalyGroupTimeSeriesRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of anomalous metrics for a measure in an anomaly group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupTimeSeriesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomalyGroupTimeSeriesRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest.Builder} to
     *        create a request.
     * @return Result of the ListAnomalyGroupTimeSeries operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupTimeSeriesResponse listAnomalyGroupTimeSeries(
            Consumer<ListAnomalyGroupTimeSeriesRequest.Builder> listAnomalyGroupTimeSeriesRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listAnomalyGroupTimeSeries(ListAnomalyGroupTimeSeriesRequest.builder()
                .applyMutation(listAnomalyGroupTimeSeriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupTimeSeries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesIterable responses = client.listAnomalyGroupTimeSeriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesIterable responses = client
     *             .listAnomalyGroupTimeSeriesPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesIterable responses = client.listAnomalyGroupTimeSeriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupTimeSeries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupTimeSeriesIterable listAnomalyGroupTimeSeriesPaginator(
            ListAnomalyGroupTimeSeriesRequest listAnomalyGroupTimeSeriesRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return new ListAnomalyGroupTimeSeriesIterable(this, listAnomalyGroupTimeSeriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalyGroupTimeSeries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesIterable responses = client.listAnomalyGroupTimeSeriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesIterable responses = client
     *             .listAnomalyGroupTimeSeriesPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListAnomalyGroupTimeSeriesIterable responses = client.listAnomalyGroupTimeSeriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalyGroupTimeSeries(software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalyGroupTimeSeriesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomalyGroupTimeSeriesRequest#builder()}
     * </p>
     *
     * @param listAnomalyGroupTimeSeriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListAnomalyGroupTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListAnomalyGroupTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalyGroupTimeSeriesIterable listAnomalyGroupTimeSeriesPaginator(
            Consumer<ListAnomalyGroupTimeSeriesRequest.Builder> listAnomalyGroupTimeSeriesRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listAnomalyGroupTimeSeriesPaginator(ListAnomalyGroupTimeSeriesRequest.builder()
                .applyMutation(listAnomalyGroupTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Lists the datasets in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     *
     * @param listMetricSetsRequest
     * @return Result of the ListMetricSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMetricSetsResponse listMetricSets(ListMetricSetsRequest listMetricSetsRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the datasets in the current AWS Region.
     * </p>
     * <p>
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
     * immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetricSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMetricSetsRequest#builder()}
     * </p>
     *
     * @param listMetricSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMetricSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMetricSetsResponse listMetricSets(Consumer<ListMetricSetsRequest.Builder> listMetricSetsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listMetricSets(ListMetricSetsRequest.builder().applyMutation(listMetricSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetricSets(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsIterable responses = client.listMetricSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsIterable responses = client
     *             .listMetricSetsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsIterable responses = client.listMetricSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetricSets(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMetricSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMetricSetsIterable listMetricSetsPaginator(ListMetricSetsRequest listMetricSetsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return new ListMetricSetsIterable(this, listMetricSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetricSets(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsIterable responses = client.listMetricSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsIterable responses = client
     *             .listMetricSetsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutmetrics.paginators.ListMetricSetsIterable responses = client.listMetricSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetricSets(software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetricSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMetricSetsRequest#builder()}
     * </p>
     *
     * @param listMetricSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListMetricSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListMetricSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMetricSetsIterable listMetricSetsPaginator(Consumer<ListMetricSetsRequest.Builder> listMetricSetsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listMetricSetsPaginator(ListMetricSetsRequest.builder().applyMutation(listMetricSetsRequest).build());
    }

    /**
     * <p>
     * Gets a list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> for a
     * detector, dataset, or alert.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> for a
     * detector, dataset, or alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Add feedback for an anomalous metric.
     * </p>
     *
     * @param putFeedbackRequest
     * @return Result of the PutFeedback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/PutFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add feedback for an anomalous metric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link PutFeedbackRequest#builder()}
     * </p>
     *
     * @param putFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.PutFeedbackRequest.Builder} to create a
     *        request.
     * @return Result of the PutFeedback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/PutFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default PutFeedbackResponse putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServerException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        return putFeedback(PutFeedbackRequest.builder().applyMutation(putFeedbackRequest).build());
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to a detector,
     * dataset, or alert.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to a detector,
     * dataset, or alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> from a
     * detector, dataset, or alert.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> from a
     * detector, dataset, or alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Make changes to an existing alert.
     * </p>
     *
     * @param updateAlertRequest
     * @return Result of the UpdateAlert operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAlertResponse updateAlert(UpdateAlertRequest updateAlertRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Make changes to an existing alert.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAlertRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAlertRequest#builder()}
     * </p>
     *
     * @param updateAlertRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.UpdateAlertRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAlert operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateAlert
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAlert" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAlertResponse updateAlert(Consumer<UpdateAlertRequest.Builder> updateAlertRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LookoutMetricsException {
        return updateAlert(UpdateAlertRequest.builder().applyMutation(updateAlertRequest).build());
    }

    /**
     * <p>
     * Updates a detector. After activation, you can only change a detector's ingestion delay and description.
     * </p>
     *
     * @param updateAnomalyDetectorRequest
     * @return Result of the UpdateAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAnomalyDetectorResponse updateAnomalyDetector(UpdateAnomalyDetectorRequest updateAnomalyDetectorRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a detector. After activation, you can only change a detector's ingestion delay and description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnomalyDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param updateAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.UpdateAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAnomalyDetector operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateAnomalyDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAnomalyDetectorResponse updateAnomalyDetector(
            Consumer<UpdateAnomalyDetectorRequest.Builder> updateAnomalyDetectorRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AccessDeniedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LookoutMetricsException {
        return updateAnomalyDetector(UpdateAnomalyDetectorRequest.builder().applyMutation(updateAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     *
     * @param updateMetricSetRequest
     * @return Result of the UpdateMetricSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMetricSetResponse updateMetricSet(UpdateMetricSetRequest updateMetricSetRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            LookoutMetricsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMetricSetRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMetricSetRequest#builder()}
     * </p>
     *
     * @param updateMetricSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lookoutmetrics.model.UpdateMetricSetRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMetricSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the ARN of the resource and try again.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service. Check your input values and try
     *         again.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws TooManyRequestsException
     *         The request was denied due to too many requests being submitted at the same time.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service's quotas. Check the service quotas and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutMetricsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutMetricsClient.UpdateMetricSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/UpdateMetricSet"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMetricSetResponse updateMetricSet(Consumer<UpdateMetricSetRequest.Builder> updateMetricSetRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AccessDeniedException,
            TooManyRequestsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            LookoutMetricsException {
        return updateMetricSet(UpdateMetricSetRequest.builder().applyMutation(updateMetricSetRequest).build());
    }

    /**
     * Create a {@link LookoutMetricsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LookoutMetricsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LookoutMetricsClient}.
     */
    static LookoutMetricsClientBuilder builder() {
        return new DefaultLookoutMetricsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default LookoutMetricsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
