/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataQualityMetricsRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<GetDataQualityMetricsRequest.Builder, GetDataQualityMetricsRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(GetDataQualityMetricsRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetArn").getter(getter(GetDataQualityMetricsRequest::metricSetArn))
            .setter(setter(Builder::metricSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            METRIC_SET_ARN_FIELD));

    private final String anomalyDetectorArn;

    private final String metricSetArn;

    private GetDataQualityMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.metricSetArn = builder.metricSetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the anomaly detector that you want to investigate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the anomaly detector that you want to investigate.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a specific data quality metric set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a specific data quality metric set.
     */
    public final String metricSetArn() {
        return metricSetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityMetricsRequest)) {
            return false;
        }
        GetDataQualityMetricsRequest other = (GetDataQualityMetricsRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(metricSetArn(), other.metricSetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataQualityMetricsRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("MetricSetArn", metricSetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "MetricSetArn":
            return Optional.ofNullable(clazz.cast(metricSetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityMetricsRequest, T> g) {
        return obj -> g.apply((GetDataQualityMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataQualityMetricsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the anomaly detector that you want to investigate.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The Amazon Resource Name (ARN) of the anomaly detector that you want to investigate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a specific data quality metric set.
         * </p>
         * 
         * @param metricSetArn
         *        The Amazon Resource Name (ARN) of a specific data quality metric set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetArn(String metricSetArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private String metricSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityMetricsRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            metricSetArn(model.metricSetArn);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getMetricSetArn() {
            return metricSetArn;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        @Override
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataQualityMetricsRequest build() {
            return new GetDataQualityMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
