/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of <code>DataQualityMetric</code> objects that describes one or more data quality metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricSetDataQualityMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricSetDataQualityMetric.Builder, MetricSetDataQualityMetric> {
    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetArn").getter(getter(MetricSetDataQualityMetric::metricSetArn))
            .setter(setter(Builder::metricSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()).build();

    private static final SdkField<List<DataQualityMetric>> DATA_QUALITY_METRIC_LIST_FIELD = SdkField
            .<List<DataQualityMetric>> builder(MarshallingType.LIST)
            .memberName("DataQualityMetricList")
            .getter(getter(MetricSetDataQualityMetric::dataQualityMetricList))
            .setter(setter(Builder::dataQualityMetricList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityMetricList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataQualityMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataQualityMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_ARN_FIELD,
            DATA_QUALITY_METRIC_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricSetArn;

    private final List<DataQualityMetric> dataQualityMetricList;

    private MetricSetDataQualityMetric(BuilderImpl builder) {
        this.metricSetArn = builder.metricSetArn;
        this.dataQualityMetricList = builder.dataQualityMetricList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data quality metric array.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data quality metric array.
     */
    public final String metricSetArn() {
        return metricSetArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataQualityMetricList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataQualityMetricList() {
        return dataQualityMetricList != null && !(dataQualityMetricList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of data quality metrics contained in the data quality metric set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataQualityMetricList} method.
     * </p>
     * 
     * @return The array of data quality metrics contained in the data quality metric set.
     */
    public final List<DataQualityMetric> dataQualityMetricList() {
        return dataQualityMetricList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataQualityMetricList() ? dataQualityMetricList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSetDataQualityMetric)) {
            return false;
        }
        MetricSetDataQualityMetric other = (MetricSetDataQualityMetric) obj;
        return Objects.equals(metricSetArn(), other.metricSetArn())
                && hasDataQualityMetricList() == other.hasDataQualityMetricList()
                && Objects.equals(dataQualityMetricList(), other.dataQualityMetricList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricSetDataQualityMetric").add("MetricSetArn", metricSetArn())
                .add("DataQualityMetricList", hasDataQualityMetricList() ? dataQualityMetricList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricSetArn":
            return Optional.ofNullable(clazz.cast(metricSetArn()));
        case "DataQualityMetricList":
            return Optional.ofNullable(clazz.cast(dataQualityMetricList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricSetDataQualityMetric, T> g) {
        return obj -> g.apply((MetricSetDataQualityMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricSetDataQualityMetric> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data quality metric array.
         * </p>
         * 
         * @param metricSetArn
         *        The Amazon Resource Name (ARN) of the data quality metric array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetArn(String metricSetArn);

        /**
         * <p>
         * The array of data quality metrics contained in the data quality metric set.
         * </p>
         * 
         * @param dataQualityMetricList
         *        The array of data quality metrics contained in the data quality metric set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualityMetricList(Collection<DataQualityMetric> dataQualityMetricList);

        /**
         * <p>
         * The array of data quality metrics contained in the data quality metric set.
         * </p>
         * 
         * @param dataQualityMetricList
         *        The array of data quality metrics contained in the data quality metric set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualityMetricList(DataQualityMetric... dataQualityMetricList);

        /**
         * <p>
         * The array of data quality metrics contained in the data quality metric set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.DataQualityMetric.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.DataQualityMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.DataQualityMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #dataQualityMetricList(List<DataQualityMetric>)}.
         * 
         * @param dataQualityMetricList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DataQualityMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQualityMetricList(java.util.Collection<DataQualityMetric>)
         */
        Builder dataQualityMetricList(Consumer<DataQualityMetric.Builder>... dataQualityMetricList);
    }

    static final class BuilderImpl implements Builder {
        private String metricSetArn;

        private List<DataQualityMetric> dataQualityMetricList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSetDataQualityMetric model) {
            metricSetArn(model.metricSetArn);
            dataQualityMetricList(model.dataQualityMetricList);
        }

        public final String getMetricSetArn() {
            return metricSetArn;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        @Override
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        public final List<DataQualityMetric.Builder> getDataQualityMetricList() {
            List<DataQualityMetric.Builder> result = DataQualityMetricListCopier.copyToBuilder(this.dataQualityMetricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataQualityMetricList(Collection<DataQualityMetric.BuilderImpl> dataQualityMetricList) {
            this.dataQualityMetricList = DataQualityMetricListCopier.copyFromBuilder(dataQualityMetricList);
        }

        @Override
        public final Builder dataQualityMetricList(Collection<DataQualityMetric> dataQualityMetricList) {
            this.dataQualityMetricList = DataQualityMetricListCopier.copy(dataQualityMetricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataQualityMetricList(DataQualityMetric... dataQualityMetricList) {
            dataQualityMetricList(Arrays.asList(dataQualityMetricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataQualityMetricList(Consumer<DataQualityMetric.Builder>... dataQualityMetricList) {
            dataQualityMetricList(Stream.of(dataQualityMetricList).map(c -> DataQualityMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MetricSetDataQualityMetric build() {
            return new MetricSetDataQualityMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
