/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.LambdaConfiguration;
import software.amazon.awssdk.services.lookoutmetrics.model.SNSConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<SNSConfiguration> SNS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SNSConfiguration").getter(Action.getter(Action::snsConfiguration)).setter(Action.setter(Builder::snsConfiguration)).constructor(SNSConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSConfiguration").build()}).build();
    private static final SdkField<LambdaConfiguration> LAMBDA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaConfiguration").getter(Action.getter(Action::lambdaConfiguration)).setter(Action.setter(Builder::lambdaConfiguration)).constructor(LambdaConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_CONFIGURATION_FIELD, LAMBDA_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SNSConfiguration", SNS_CONFIGURATION_FIELD);
            this.put("LambdaConfiguration", LAMBDA_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SNSConfiguration snsConfiguration;
    private final LambdaConfiguration lambdaConfiguration;

    private Action(BuilderImpl builder) {
        this.snsConfiguration = builder.snsConfiguration;
        this.lambdaConfiguration = builder.lambdaConfiguration;
    }

    public final SNSConfiguration snsConfiguration() {
        return this.snsConfiguration;
    }

    public final LambdaConfiguration lambdaConfiguration() {
        return this.lambdaConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.snsConfiguration(), other.snsConfiguration()) && Objects.equals(this.lambdaConfiguration(), other.lambdaConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Action").add("SNSConfiguration", (Object)this.snsConfiguration()).add("LambdaConfiguration", (Object)this.lambdaConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SNSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snsConfiguration()));
            }
            case "LambdaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lambdaConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SNSConfiguration snsConfiguration;
        private LambdaConfiguration lambdaConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.snsConfiguration(model.snsConfiguration);
            this.lambdaConfiguration(model.lambdaConfiguration);
        }

        public final SNSConfiguration.Builder getSnsConfiguration() {
            return this.snsConfiguration != null ? this.snsConfiguration.toBuilder() : null;
        }

        public final void setSnsConfiguration(SNSConfiguration.BuilderImpl snsConfiguration) {
            this.snsConfiguration = snsConfiguration != null ? snsConfiguration.build() : null;
        }

        @Override
        public final Builder snsConfiguration(SNSConfiguration snsConfiguration) {
            this.snsConfiguration = snsConfiguration;
            return this;
        }

        public final LambdaConfiguration.Builder getLambdaConfiguration() {
            return this.lambdaConfiguration != null ? this.lambdaConfiguration.toBuilder() : null;
        }

        public final void setLambdaConfiguration(LambdaConfiguration.BuilderImpl lambdaConfiguration) {
            this.lambdaConfiguration = lambdaConfiguration != null ? lambdaConfiguration.build() : null;
        }

        @Override
        public final Builder lambdaConfiguration(LambdaConfiguration lambdaConfiguration) {
            this.lambdaConfiguration = lambdaConfiguration;
            return this;
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder snsConfiguration(SNSConfiguration var1);

        default public Builder snsConfiguration(Consumer<SNSConfiguration.Builder> snsConfiguration) {
            return this.snsConfiguration((SNSConfiguration)((SNSConfiguration.Builder)SNSConfiguration.builder().applyMutation(snsConfiguration)).build());
        }

        public Builder lambdaConfiguration(LambdaConfiguration var1);

        default public Builder lambdaConfiguration(Consumer<LambdaConfiguration.Builder> lambdaConfiguration) {
            return this.lambdaConfiguration((LambdaConfiguration)((LambdaConfiguration.Builder)LambdaConfiguration.builder().applyMutation(lambdaConfiguration)).build());
        }
    }
}

