/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.ItemizedMetricStats;
import software.amazon.awssdk.services.lookoutmetrics.model.ItemizedMetricStatsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyGroupStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyGroupStatistics> {
    private static final SdkField<String> EVALUATION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationStartDate").getter(AnomalyGroupStatistics.getter(AnomalyGroupStatistics::evaluationStartDate)).setter(AnomalyGroupStatistics.setter(Builder::evaluationStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationStartDate").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(AnomalyGroupStatistics.getter(AnomalyGroupStatistics::totalCount)).setter(AnomalyGroupStatistics.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final SdkField<List<ItemizedMetricStats>> ITEMIZED_METRIC_STATS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ItemizedMetricStatsList").getter(AnomalyGroupStatistics.getter(AnomalyGroupStatistics::itemizedMetricStatsList)).setter(AnomalyGroupStatistics.setter(Builder::itemizedMetricStatsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemizedMetricStatsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemizedMetricStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_START_DATE_FIELD, TOTAL_COUNT_FIELD, ITEMIZED_METRIC_STATS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnomalyGroupStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String evaluationStartDate;
    private final Integer totalCount;
    private final List<ItemizedMetricStats> itemizedMetricStatsList;

    private AnomalyGroupStatistics(BuilderImpl builder) {
        this.evaluationStartDate = builder.evaluationStartDate;
        this.totalCount = builder.totalCount;
        this.itemizedMetricStatsList = builder.itemizedMetricStatsList;
    }

    public final String evaluationStartDate() {
        return this.evaluationStartDate;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public final boolean hasItemizedMetricStatsList() {
        return this.itemizedMetricStatsList != null && !(this.itemizedMetricStatsList instanceof SdkAutoConstructList);
    }

    public final List<ItemizedMetricStats> itemizedMetricStatsList() {
        return this.itemizedMetricStatsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemizedMetricStatsList() ? this.itemizedMetricStatsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyGroupStatistics)) {
            return false;
        }
        AnomalyGroupStatistics other = (AnomalyGroupStatistics)obj;
        return Objects.equals(this.evaluationStartDate(), other.evaluationStartDate()) && Objects.equals(this.totalCount(), other.totalCount()) && this.hasItemizedMetricStatsList() == other.hasItemizedMetricStatsList() && Objects.equals(this.itemizedMetricStatsList(), other.itemizedMetricStatsList());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyGroupStatistics").add("EvaluationStartDate", (Object)this.evaluationStartDate()).add("TotalCount", (Object)this.totalCount()).add("ItemizedMetricStatsList", this.hasItemizedMetricStatsList() ? this.itemizedMetricStatsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationStartDate": {
                return Optional.ofNullable(clazz.cast(this.evaluationStartDate()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
            case "ItemizedMetricStatsList": {
                return Optional.ofNullable(clazz.cast(this.itemizedMetricStatsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationStartDate", EVALUATION_START_DATE_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        map.put("ItemizedMetricStatsList", ITEMIZED_METRIC_STATS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalyGroupStatistics, T> g) {
        return obj -> g.apply((AnomalyGroupStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationStartDate;
        private Integer totalCount;
        private List<ItemizedMetricStats> itemizedMetricStatsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyGroupStatistics model) {
            this.evaluationStartDate(model.evaluationStartDate);
            this.totalCount(model.totalCount);
            this.itemizedMetricStatsList(model.itemizedMetricStatsList);
        }

        public final String getEvaluationStartDate() {
            return this.evaluationStartDate;
        }

        public final void setEvaluationStartDate(String evaluationStartDate) {
            this.evaluationStartDate = evaluationStartDate;
        }

        @Override
        public final Builder evaluationStartDate(String evaluationStartDate) {
            this.evaluationStartDate = evaluationStartDate;
            return this;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final List<ItemizedMetricStats.Builder> getItemizedMetricStatsList() {
            List<ItemizedMetricStats.Builder> result = ItemizedMetricStatsListCopier.copyToBuilder(this.itemizedMetricStatsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItemizedMetricStatsList(Collection<ItemizedMetricStats.BuilderImpl> itemizedMetricStatsList) {
            this.itemizedMetricStatsList = ItemizedMetricStatsListCopier.copyFromBuilder(itemizedMetricStatsList);
        }

        @Override
        public final Builder itemizedMetricStatsList(Collection<ItemizedMetricStats> itemizedMetricStatsList) {
            this.itemizedMetricStatsList = ItemizedMetricStatsListCopier.copy(itemizedMetricStatsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemizedMetricStatsList(ItemizedMetricStats ... itemizedMetricStatsList) {
            this.itemizedMetricStatsList(Arrays.asList(itemizedMetricStatsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemizedMetricStatsList(Consumer<ItemizedMetricStats.Builder> ... itemizedMetricStatsList) {
            this.itemizedMetricStatsList(Stream.of(itemizedMetricStatsList).map(c -> (ItemizedMetricStats)((ItemizedMetricStats.Builder)ItemizedMetricStats.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnomalyGroupStatistics build() {
            return new AnomalyGroupStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyGroupStatistics> {
        public Builder evaluationStartDate(String var1);

        public Builder totalCount(Integer var1);

        public Builder itemizedMetricStatsList(Collection<ItemizedMetricStats> var1);

        public Builder itemizedMetricStatsList(ItemizedMetricStats ... var1);

        public Builder itemizedMetricStatsList(Consumer<ItemizedMetricStats.Builder> ... var1);
    }
}

