/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a detector's configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyDetectorConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyDetectorConfig.Builder, AnomalyDetectorConfig> {
    private static final SdkField<String> ANOMALY_DETECTOR_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorFrequency").getter(getter(AnomalyDetectorConfig::anomalyDetectorFrequencyAsString))
            .setter(setter(Builder::anomalyDetectorFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorFrequency").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ANOMALY_DETECTOR_FREQUENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String anomalyDetectorFrequency;

    private AnomalyDetectorConfig(BuilderImpl builder) {
        this.anomalyDetectorFrequency = builder.anomalyDetectorFrequency;
    }

    /**
     * <p>
     * The frequency at which the detector analyzes its source data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #anomalyDetectorFrequency} will return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #anomalyDetectorFrequencyAsString}.
     * </p>
     * 
     * @return The frequency at which the detector analyzes its source data.
     * @see Frequency
     */
    public final Frequency anomalyDetectorFrequency() {
        return Frequency.fromValue(anomalyDetectorFrequency);
    }

    /**
     * <p>
     * The frequency at which the detector analyzes its source data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #anomalyDetectorFrequency} will return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #anomalyDetectorFrequencyAsString}.
     * </p>
     * 
     * @return The frequency at which the detector analyzes its source data.
     * @see Frequency
     */
    public final String anomalyDetectorFrequencyAsString() {
        return anomalyDetectorFrequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorFrequencyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetectorConfig)) {
            return false;
        }
        AnomalyDetectorConfig other = (AnomalyDetectorConfig) obj;
        return Objects.equals(anomalyDetectorFrequencyAsString(), other.anomalyDetectorFrequencyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyDetectorConfig").add("AnomalyDetectorFrequency", anomalyDetectorFrequencyAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorFrequency":
            return Optional.ofNullable(clazz.cast(anomalyDetectorFrequencyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnomalyDetectorFrequency", ANOMALY_DETECTOR_FREQUENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetectorConfig, T> g) {
        return obj -> g.apply((AnomalyDetectorConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyDetectorConfig> {
        /**
         * <p>
         * The frequency at which the detector analyzes its source data.
         * </p>
         * 
         * @param anomalyDetectorFrequency
         *        The frequency at which the detector analyzes its source data.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder anomalyDetectorFrequency(String anomalyDetectorFrequency);

        /**
         * <p>
         * The frequency at which the detector analyzes its source data.
         * </p>
         * 
         * @param anomalyDetectorFrequency
         *        The frequency at which the detector analyzes its source data.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder anomalyDetectorFrequency(Frequency anomalyDetectorFrequency);
    }

    static final class BuilderImpl implements Builder {
        private String anomalyDetectorFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetectorConfig model) {
            anomalyDetectorFrequency(model.anomalyDetectorFrequency);
        }

        public final String getAnomalyDetectorFrequency() {
            return anomalyDetectorFrequency;
        }

        public final void setAnomalyDetectorFrequency(String anomalyDetectorFrequency) {
            this.anomalyDetectorFrequency = anomalyDetectorFrequency;
        }

        @Override
        public final Builder anomalyDetectorFrequency(String anomalyDetectorFrequency) {
            this.anomalyDetectorFrequency = anomalyDetectorFrequency;
            return this;
        }

        @Override
        public final Builder anomalyDetectorFrequency(Frequency anomalyDetectorFrequency) {
            this.anomalyDetectorFrequency(anomalyDetectorFrequency == null ? null : anomalyDetectorFrequency.toString());
            return this;
        }

        @Override
        public AnomalyDetectorConfig build() {
            return new AnomalyDetectorConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
