/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon CloudWatch datasource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchConfig.Builder, CloudWatchConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CloudWatchConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<BackTestConfiguration> BACK_TEST_CONFIGURATION_FIELD = SdkField
            .<BackTestConfiguration> builder(MarshallingType.SDK_POJO).memberName("BackTestConfiguration")
            .getter(getter(CloudWatchConfig::backTestConfiguration)).setter(setter(Builder::backTestConfiguration))
            .constructor(BackTestConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackTestConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            BACK_TEST_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final BackTestConfiguration backTestConfiguration;

    private CloudWatchConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.backTestConfiguration = builder.backTestConfiguration;
    }

    /**
     * <p>
     * An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
     * </p>
     * 
     * @return An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Settings for backtest mode.
     * </p>
     * 
     * @return Settings for backtest mode.
     */
    public final BackTestConfiguration backTestConfiguration() {
        return backTestConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(backTestConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchConfig)) {
            return false;
        }
        CloudWatchConfig other = (CloudWatchConfig) obj;
        return Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(backTestConfiguration(), other.backTestConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchConfig").add("RoleArn", roleArn())
                .add("BackTestConfiguration", backTestConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "BackTestConfiguration":
            return Optional.ofNullable(clazz.cast(backTestConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("BackTestConfiguration", BACK_TEST_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchConfig, T> g) {
        return obj -> g.apply((CloudWatchConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchConfig> {
        /**
         * <p>
         * An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
         * </p>
         * 
         * @param roleArn
         *        An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Settings for backtest mode.
         * </p>
         * 
         * @param backTestConfiguration
         *        Settings for backtest mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backTestConfiguration(BackTestConfiguration backTestConfiguration);

        /**
         * <p>
         * Settings for backtest mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackTestConfiguration.Builder} avoiding
         * the need to create one manually via {@link BackTestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackTestConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #backTestConfiguration(BackTestConfiguration)}.
         * 
         * @param backTestConfiguration
         *        a consumer that will call methods on {@link BackTestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backTestConfiguration(BackTestConfiguration)
         */
        default Builder backTestConfiguration(Consumer<BackTestConfiguration.Builder> backTestConfiguration) {
            return backTestConfiguration(BackTestConfiguration.builder().applyMutation(backTestConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private BackTestConfiguration backTestConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchConfig model) {
            roleArn(model.roleArn);
            backTestConfiguration(model.backTestConfiguration);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final BackTestConfiguration.Builder getBackTestConfiguration() {
            return backTestConfiguration != null ? backTestConfiguration.toBuilder() : null;
        }

        public final void setBackTestConfiguration(BackTestConfiguration.BuilderImpl backTestConfiguration) {
            this.backTestConfiguration = backTestConfiguration != null ? backTestConfiguration.build() : null;
        }

        @Override
        public final Builder backTestConfiguration(BackTestConfiguration backTestConfiguration) {
            this.backTestConfiguration = backTestConfiguration;
            return this;
        }

        @Override
        public CloudWatchConfig build() {
            return new CloudWatchConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
