/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a source file's formatting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileFormatDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<FileFormatDescriptor.Builder, FileFormatDescriptor> {
    private static final SdkField<CsvFormatDescriptor> CSV_FORMAT_DESCRIPTOR_FIELD = SdkField
            .<CsvFormatDescriptor> builder(MarshallingType.SDK_POJO).memberName("CsvFormatDescriptor")
            .getter(getter(FileFormatDescriptor::csvFormatDescriptor)).setter(setter(Builder::csvFormatDescriptor))
            .constructor(CsvFormatDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvFormatDescriptor").build())
            .build();

    private static final SdkField<JsonFormatDescriptor> JSON_FORMAT_DESCRIPTOR_FIELD = SdkField
            .<JsonFormatDescriptor> builder(MarshallingType.SDK_POJO).memberName("JsonFormatDescriptor")
            .getter(getter(FileFormatDescriptor::jsonFormatDescriptor)).setter(setter(Builder::jsonFormatDescriptor))
            .constructor(JsonFormatDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonFormatDescriptor").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FORMAT_DESCRIPTOR_FIELD,
            JSON_FORMAT_DESCRIPTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CsvFormatDescriptor csvFormatDescriptor;

    private final JsonFormatDescriptor jsonFormatDescriptor;

    private FileFormatDescriptor(BuilderImpl builder) {
        this.csvFormatDescriptor = builder.csvFormatDescriptor;
        this.jsonFormatDescriptor = builder.jsonFormatDescriptor;
    }

    /**
     * <p>
     * Contains information about how a source CSV data file should be analyzed.
     * </p>
     * 
     * @return Contains information about how a source CSV data file should be analyzed.
     */
    public final CsvFormatDescriptor csvFormatDescriptor() {
        return csvFormatDescriptor;
    }

    /**
     * <p>
     * Contains information about how a source JSON data file should be analyzed.
     * </p>
     * 
     * @return Contains information about how a source JSON data file should be analyzed.
     */
    public final JsonFormatDescriptor jsonFormatDescriptor() {
        return jsonFormatDescriptor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(csvFormatDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(jsonFormatDescriptor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileFormatDescriptor)) {
            return false;
        }
        FileFormatDescriptor other = (FileFormatDescriptor) obj;
        return Objects.equals(csvFormatDescriptor(), other.csvFormatDescriptor())
                && Objects.equals(jsonFormatDescriptor(), other.jsonFormatDescriptor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileFormatDescriptor").add("CsvFormatDescriptor", csvFormatDescriptor())
                .add("JsonFormatDescriptor", jsonFormatDescriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CsvFormatDescriptor":
            return Optional.ofNullable(clazz.cast(csvFormatDescriptor()));
        case "JsonFormatDescriptor":
            return Optional.ofNullable(clazz.cast(jsonFormatDescriptor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CsvFormatDescriptor", CSV_FORMAT_DESCRIPTOR_FIELD);
        map.put("JsonFormatDescriptor", JSON_FORMAT_DESCRIPTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileFormatDescriptor, T> g) {
        return obj -> g.apply((FileFormatDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileFormatDescriptor> {
        /**
         * <p>
         * Contains information about how a source CSV data file should be analyzed.
         * </p>
         * 
         * @param csvFormatDescriptor
         *        Contains information about how a source CSV data file should be analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvFormatDescriptor(CsvFormatDescriptor csvFormatDescriptor);

        /**
         * <p>
         * Contains information about how a source CSV data file should be analyzed.
         * </p>
         * This is a convenience method that creates an instance of the {@link CsvFormatDescriptor.Builder} avoiding the
         * need to create one manually via {@link CsvFormatDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CsvFormatDescriptor.Builder#build()} is called immediately and
         * its result is passed to {@link #csvFormatDescriptor(CsvFormatDescriptor)}.
         * 
         * @param csvFormatDescriptor
         *        a consumer that will call methods on {@link CsvFormatDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvFormatDescriptor(CsvFormatDescriptor)
         */
        default Builder csvFormatDescriptor(Consumer<CsvFormatDescriptor.Builder> csvFormatDescriptor) {
            return csvFormatDescriptor(CsvFormatDescriptor.builder().applyMutation(csvFormatDescriptor).build());
        }

        /**
         * <p>
         * Contains information about how a source JSON data file should be analyzed.
         * </p>
         * 
         * @param jsonFormatDescriptor
         *        Contains information about how a source JSON data file should be analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonFormatDescriptor(JsonFormatDescriptor jsonFormatDescriptor);

        /**
         * <p>
         * Contains information about how a source JSON data file should be analyzed.
         * </p>
         * This is a convenience method that creates an instance of the {@link JsonFormatDescriptor.Builder} avoiding
         * the need to create one manually via {@link JsonFormatDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JsonFormatDescriptor.Builder#build()} is called immediately and
         * its result is passed to {@link #jsonFormatDescriptor(JsonFormatDescriptor)}.
         * 
         * @param jsonFormatDescriptor
         *        a consumer that will call methods on {@link JsonFormatDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonFormatDescriptor(JsonFormatDescriptor)
         */
        default Builder jsonFormatDescriptor(Consumer<JsonFormatDescriptor.Builder> jsonFormatDescriptor) {
            return jsonFormatDescriptor(JsonFormatDescriptor.builder().applyMutation(jsonFormatDescriptor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CsvFormatDescriptor csvFormatDescriptor;

        private JsonFormatDescriptor jsonFormatDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(FileFormatDescriptor model) {
            csvFormatDescriptor(model.csvFormatDescriptor);
            jsonFormatDescriptor(model.jsonFormatDescriptor);
        }

        public final CsvFormatDescriptor.Builder getCsvFormatDescriptor() {
            return csvFormatDescriptor != null ? csvFormatDescriptor.toBuilder() : null;
        }

        public final void setCsvFormatDescriptor(CsvFormatDescriptor.BuilderImpl csvFormatDescriptor) {
            this.csvFormatDescriptor = csvFormatDescriptor != null ? csvFormatDescriptor.build() : null;
        }

        @Override
        public final Builder csvFormatDescriptor(CsvFormatDescriptor csvFormatDescriptor) {
            this.csvFormatDescriptor = csvFormatDescriptor;
            return this;
        }

        public final JsonFormatDescriptor.Builder getJsonFormatDescriptor() {
            return jsonFormatDescriptor != null ? jsonFormatDescriptor.toBuilder() : null;
        }

        public final void setJsonFormatDescriptor(JsonFormatDescriptor.BuilderImpl jsonFormatDescriptor) {
            this.jsonFormatDescriptor = jsonFormatDescriptor != null ? jsonFormatDescriptor.build() : null;
        }

        @Override
        public final Builder jsonFormatDescriptor(JsonFormatDescriptor jsonFormatDescriptor) {
            this.jsonFormatDescriptor = jsonFormatDescriptor;
            return this;
        }

        @Override
        public FileFormatDescriptor build() {
            return new FileFormatDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
