/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomalyGroupSummariesRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<ListAnomalyGroupSummariesRequest.Builder, ListAnomalyGroupSummariesRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(ListAnomalyGroupSummariesRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<Integer> SENSITIVITY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SensitivityThreshold").getter(getter(ListAnomalyGroupSummariesRequest::sensitivityThreshold))
            .setter(setter(Builder::sensitivityThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SensitivityThreshold").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAnomalyGroupSummariesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnomalyGroupSummariesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            SENSITIVITY_THRESHOLD_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String anomalyDetectorArn;

    private final Integer sensitivityThreshold;

    private final Integer maxResults;

    private final String nextToken;

    private ListAnomalyGroupSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.sensitivityThreshold = builder.sensitivityThreshold;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the anomaly detector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the anomaly detector.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The minimum severity score for inclusion in the output.
     * </p>
     * 
     * @return The minimum severity score for inclusion in the output.
     */
    public final Integer sensitivityThreshold() {
        return sensitivityThreshold;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(sensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyGroupSummariesRequest)) {
            return false;
        }
        ListAnomalyGroupSummariesRequest other = (ListAnomalyGroupSummariesRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(sensitivityThreshold(), other.sensitivityThreshold())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomalyGroupSummariesRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("SensitivityThreshold", sensitivityThreshold()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "SensitivityThreshold":
            return Optional.ofNullable(clazz.cast(sensitivityThreshold()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("SensitivityThreshold", SENSITIVITY_THRESHOLD_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyGroupSummariesRequest, T> g) {
        return obj -> g.apply((ListAnomalyGroupSummariesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnomalyGroupSummariesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the anomaly detector.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The Amazon Resource Name (ARN) of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The minimum severity score for inclusion in the output.
         * </p>
         * 
         * @param sensitivityThreshold
         *        The minimum severity score for inclusion in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityThreshold(Integer sensitivityThreshold);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token that's returned by a previous request to retrieve the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private Integer sensitivityThreshold;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyGroupSummariesRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            sensitivityThreshold(model.sensitivityThreshold);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final Integer getSensitivityThreshold() {
            return sensitivityThreshold;
        }

        public final void setSensitivityThreshold(Integer sensitivityThreshold) {
            this.sensitivityThreshold = sensitivityThreshold;
        }

        @Override
        public final Builder sensitivityThreshold(Integer sensitivityThreshold) {
            this.sensitivityThreshold = sensitivityThreshold;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAnomalyGroupSummariesRequest build() {
            return new ListAnomalyGroupSummariesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
