/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomalyGroupTimeSeriesResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<ListAnomalyGroupTimeSeriesResponse.Builder, ListAnomalyGroupTimeSeriesResponse> {
    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyGroupId").getter(getter(ListAnomalyGroupTimeSeriesResponse::anomalyGroupId))
            .setter(setter(Builder::anomalyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(ListAnomalyGroupTimeSeriesResponse::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<List<String>> TIMESTAMP_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TimestampList")
            .getter(getter(ListAnomalyGroupTimeSeriesResponse::timestampList))
            .setter(setter(Builder::timestampList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnomalyGroupTimeSeriesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<TimeSeries>> TIME_SERIES_LIST_FIELD = SdkField
            .<List<TimeSeries>> builder(MarshallingType.LIST)
            .memberName("TimeSeriesList")
            .getter(getter(ListAnomalyGroupTimeSeriesResponse::timeSeriesList))
            .setter(setter(Builder::timeSeriesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeries> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeries::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_GROUP_ID_FIELD,
            METRIC_NAME_FIELD, TIMESTAMP_LIST_FIELD, NEXT_TOKEN_FIELD, TIME_SERIES_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String anomalyGroupId;

    private final String metricName;

    private final List<String> timestampList;

    private final String nextToken;

    private final List<TimeSeries> timeSeriesList;

    private ListAnomalyGroupTimeSeriesResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyGroupId = builder.anomalyGroupId;
        this.metricName = builder.metricName;
        this.timestampList = builder.timestampList;
        this.nextToken = builder.nextToken;
        this.timeSeriesList = builder.timeSeriesList;
    }

    /**
     * <p>
     * The ID of the anomaly group.
     * </p>
     * 
     * @return The ID of the anomaly group.
     */
    public final String anomalyGroupId() {
        return anomalyGroupId;
    }

    /**
     * <p>
     * The name of the measure field.
     * </p>
     * 
     * @return The name of the measure field.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimestampList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTimestampList() {
        return timestampList != null && !(timestampList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Timestamps for the anomalous metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimestampList} method.
     * </p>
     * 
     * @return Timestamps for the anomalous metrics.
     */
    public final List<String> timestampList() {
        return timestampList;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimeSeriesList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTimeSeriesList() {
        return timeSeriesList != null && !(timeSeriesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of anomalous metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimeSeriesList} method.
     * </p>
     * 
     * @return A list of anomalous metrics.
     */
    public final List<TimeSeries> timeSeriesList() {
        return timeSeriesList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimestampList() ? timestampList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimeSeriesList() ? timeSeriesList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyGroupTimeSeriesResponse)) {
            return false;
        }
        ListAnomalyGroupTimeSeriesResponse other = (ListAnomalyGroupTimeSeriesResponse) obj;
        return Objects.equals(anomalyGroupId(), other.anomalyGroupId()) && Objects.equals(metricName(), other.metricName())
                && hasTimestampList() == other.hasTimestampList() && Objects.equals(timestampList(), other.timestampList())
                && Objects.equals(nextToken(), other.nextToken()) && hasTimeSeriesList() == other.hasTimeSeriesList()
                && Objects.equals(timeSeriesList(), other.timeSeriesList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomalyGroupTimeSeriesResponse").add("AnomalyGroupId", anomalyGroupId())
                .add("MetricName", metricName()).add("TimestampList", hasTimestampList() ? timestampList() : null)
                .add("NextToken", nextToken()).add("TimeSeriesList", hasTimeSeriesList() ? timeSeriesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyGroupId":
            return Optional.ofNullable(clazz.cast(anomalyGroupId()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "TimestampList":
            return Optional.ofNullable(clazz.cast(timestampList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TimeSeriesList":
            return Optional.ofNullable(clazz.cast(timeSeriesList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnomalyGroupId", ANOMALY_GROUP_ID_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("TimestampList", TIMESTAMP_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("TimeSeriesList", TIME_SERIES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyGroupTimeSeriesResponse, T> g) {
        return obj -> g.apply((ListAnomalyGroupTimeSeriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnomalyGroupTimeSeriesResponse> {
        /**
         * <p>
         * The ID of the anomaly group.
         * </p>
         * 
         * @param anomalyGroupId
         *        The ID of the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupId(String anomalyGroupId);

        /**
         * <p>
         * The name of the measure field.
         * </p>
         * 
         * @param metricName
         *        The name of the measure field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * Timestamps for the anomalous metrics.
         * </p>
         * 
         * @param timestampList
         *        Timestamps for the anomalous metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampList(Collection<String> timestampList);

        /**
         * <p>
         * Timestamps for the anomalous metrics.
         * </p>
         * 
         * @param timestampList
         *        Timestamps for the anomalous metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampList(String... timestampList);

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of anomalous metrics.
         * </p>
         * 
         * @param timeSeriesList
         *        A list of anomalous metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesList(Collection<TimeSeries> timeSeriesList);

        /**
         * <p>
         * A list of anomalous metrics.
         * </p>
         * 
         * @param timeSeriesList
         *        A list of anomalous metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesList(TimeSeries... timeSeriesList);

        /**
         * <p>
         * A list of anomalous metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.TimeSeries.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lookoutmetrics.model.TimeSeries#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.TimeSeries.Builder#build()} is called immediately
         * and its result is passed to {@link #timeSeriesList(List<TimeSeries>)}.
         * 
         * @param timeSeriesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.TimeSeries.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesList(java.util.Collection<TimeSeries>)
         */
        Builder timeSeriesList(Consumer<TimeSeries.Builder>... timeSeriesList);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private String anomalyGroupId;

        private String metricName;

        private List<String> timestampList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<TimeSeries> timeSeriesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyGroupTimeSeriesResponse model) {
            super(model);
            anomalyGroupId(model.anomalyGroupId);
            metricName(model.metricName);
            timestampList(model.timestampList);
            nextToken(model.nextToken);
            timeSeriesList(model.timeSeriesList);
        }

        public final String getAnomalyGroupId() {
            return anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Collection<String> getTimestampList() {
            if (timestampList instanceof SdkAutoConstructList) {
                return null;
            }
            return timestampList;
        }

        public final void setTimestampList(Collection<String> timestampList) {
            this.timestampList = TimestampListCopier.copy(timestampList);
        }

        @Override
        public final Builder timestampList(Collection<String> timestampList) {
            this.timestampList = TimestampListCopier.copy(timestampList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampList(String... timestampList) {
            timestampList(Arrays.asList(timestampList));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TimeSeries.Builder> getTimeSeriesList() {
            List<TimeSeries.Builder> result = TimeSeriesListCopier.copyToBuilder(this.timeSeriesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesList(Collection<TimeSeries.BuilderImpl> timeSeriesList) {
            this.timeSeriesList = TimeSeriesListCopier.copyFromBuilder(timeSeriesList);
        }

        @Override
        public final Builder timeSeriesList(Collection<TimeSeries> timeSeriesList) {
            this.timeSeriesList = TimeSeriesListCopier.copy(timeSeriesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesList(TimeSeries... timeSeriesList) {
            timeSeriesList(Arrays.asList(timeSeriesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesList(Consumer<TimeSeries.Builder>... timeSeriesList) {
            timeSeriesList(Stream.of(timeSeriesList).map(c -> TimeSeries.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAnomalyGroupTimeSeriesResponse build() {
            return new ListAnomalyGroupTimeSeriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
