/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a list of filters for choosing a subset of dimension values. Each filter consists of the dimension and one
 * of its values that you want to include. When multiple dimensions or values are specified, the dimensions are joined
 * with an AND operation and the values are joined with an OR operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricSetDimensionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricSetDimensionFilter.Builder, MetricSetDimensionFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MetricSetDimensionFilter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<Filter>> FILTER_LIST_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("FilterList")
            .getter(getter(MetricSetDimensionFilter::filterList))
            .setter(setter(Builder::filterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, FILTER_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<Filter> filterList;

    private MetricSetDimensionFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.filterList = builder.filterList;
    }

    /**
     * <p>
     * The dimension that you want to filter on.
     * </p>
     * 
     * @return The dimension that you want to filter on.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilterList() {
        return filterList != null && !(filterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filters that you are applying.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterList} method.
     * </p>
     * 
     * @return The list of filters that you are applying.
     */
    public final List<Filter> filterList() {
        return filterList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterList() ? filterList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSetDimensionFilter)) {
            return false;
        }
        MetricSetDimensionFilter other = (MetricSetDimensionFilter) obj;
        return Objects.equals(name(), other.name()) && hasFilterList() == other.hasFilterList()
                && Objects.equals(filterList(), other.filterList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricSetDimensionFilter").add("Name", name())
                .add("FilterList", hasFilterList() ? filterList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FilterList":
            return Optional.ofNullable(clazz.cast(filterList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("FilterList", FILTER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricSetDimensionFilter, T> g) {
        return obj -> g.apply((MetricSetDimensionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricSetDimensionFilter> {
        /**
         * <p>
         * The dimension that you want to filter on.
         * </p>
         * 
         * @param name
         *        The dimension that you want to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of filters that you are applying.
         * </p>
         * 
         * @param filterList
         *        The list of filters that you are applying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterList(Collection<Filter> filterList);

        /**
         * <p>
         * The list of filters that you are applying.
         * </p>
         * 
         * @param filterList
         *        The list of filters that you are applying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterList(Filter... filterList);

        /**
         * <p>
         * The list of filters that you are applying.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lookoutmetrics.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.Filter.Builder#build()} is called immediately and
         * its result is passed to {@link #filterList(List<Filter>)}.
         * 
         * @param filterList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterList(java.util.Collection<Filter>)
         */
        Builder filterList(Consumer<Filter.Builder>... filterList);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<Filter> filterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSetDimensionFilter model) {
            name(model.name);
            filterList(model.filterList);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Filter.Builder> getFilterList() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterList(Collection<Filter.BuilderImpl> filterList) {
            this.filterList = FilterListCopier.copyFromBuilder(filterList);
        }

        @Override
        public final Builder filterList(Collection<Filter> filterList) {
            this.filterList = FilterListCopier.copy(filterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterList(Filter... filterList) {
            filterList(Arrays.asList(filterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterList(Consumer<Filter.Builder>... filterList) {
            filterList(Stream.of(filterList).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MetricSetDimensionFilter build() {
            return new MetricSetDimensionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
