/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricSetSummary.Builder, MetricSetSummary> {
    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetArn").getter(getter(MetricSetSummary::metricSetArn)).setter(setter(Builder::metricSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(MetricSetSummary::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> METRIC_SET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetDescription").getter(getter(MetricSetSummary::metricSetDescription))
            .setter(setter(Builder::metricSetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDescription").build())
            .build();

    private static final SdkField<String> METRIC_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetName").getter(getter(MetricSetSummary::metricSetName)).setter(setter(Builder::metricSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MetricSetSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(MetricSetSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(MetricSetSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_ARN_FIELD,
            ANOMALY_DETECTOR_ARN_FIELD, METRIC_SET_DESCRIPTION_FIELD, METRIC_SET_NAME_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metricSetArn;

    private final String anomalyDetectorArn;

    private final String metricSetDescription;

    private final String metricSetName;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final Map<String, String> tags;

    private MetricSetSummary(BuilderImpl builder) {
        this.metricSetArn = builder.metricSetArn;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.metricSetDescription = builder.metricSetDescription;
        this.metricSetName = builder.metricSetName;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the dataset.
     * </p>
     * 
     * @return The ARN of the dataset.
     */
    public final String metricSetArn() {
        return metricSetArn;
    }

    /**
     * <p>
     * The ARN of the detector to which the dataset belongs.
     * </p>
     * 
     * @return The ARN of the detector to which the dataset belongs.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The description of the dataset.
     * </p>
     * 
     * @return The description of the dataset.
     */
    public final String metricSetDescription() {
        return metricSetDescription;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String metricSetName() {
        return metricSetName;
    }

    /**
     * <p>
     * The time at which the dataset was created.
     * </p>
     * 
     * @return The time at which the dataset was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time at which the dataset was last modified.
     * </p>
     * 
     * @return The time at which the dataset was last modified.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The dataset's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The dataset's <a
     *         href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSetSummary)) {
            return false;
        }
        MetricSetSummary other = (MetricSetSummary) obj;
        return Objects.equals(metricSetArn(), other.metricSetArn())
                && Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(metricSetDescription(), other.metricSetDescription())
                && Objects.equals(metricSetName(), other.metricSetName()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricSetSummary").add("MetricSetArn", metricSetArn())
                .add("AnomalyDetectorArn", anomalyDetectorArn()).add("MetricSetDescription", metricSetDescription())
                .add("MetricSetName", metricSetName()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricSetArn":
            return Optional.ofNullable(clazz.cast(metricSetArn()));
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "MetricSetDescription":
            return Optional.ofNullable(clazz.cast(metricSetDescription()));
        case "MetricSetName":
            return Optional.ofNullable(clazz.cast(metricSetName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricSetArn", METRIC_SET_ARN_FIELD);
        map.put("AnomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("MetricSetDescription", METRIC_SET_DESCRIPTION_FIELD);
        map.put("MetricSetName", METRIC_SET_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricSetSummary, T> g) {
        return obj -> g.apply((MetricSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricSetSummary> {
        /**
         * <p>
         * The ARN of the dataset.
         * </p>
         * 
         * @param metricSetArn
         *        The ARN of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetArn(String metricSetArn);

        /**
         * <p>
         * The ARN of the detector to which the dataset belongs.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the detector to which the dataset belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The description of the dataset.
         * </p>
         * 
         * @param metricSetDescription
         *        The description of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetDescription(String metricSetDescription);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param metricSetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetName(String metricSetName);

        /**
         * <p>
         * The time at which the dataset was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time at which the dataset was last modified.
         * </p>
         * 
         * @param lastModificationTime
         *        The time at which the dataset was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The dataset's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.
         * </p>
         * 
         * @param tags
         *        The dataset's <a
         *        href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String metricSetArn;

        private String anomalyDetectorArn;

        private String metricSetDescription;

        private String metricSetName;

        private Instant creationTime;

        private Instant lastModificationTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSetSummary model) {
            metricSetArn(model.metricSetArn);
            anomalyDetectorArn(model.anomalyDetectorArn);
            metricSetDescription(model.metricSetDescription);
            metricSetName(model.metricSetName);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            tags(model.tags);
        }

        public final String getMetricSetArn() {
            return metricSetArn;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        @Override
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getMetricSetDescription() {
            return metricSetDescription;
        }

        public final void setMetricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
        }

        @Override
        public final Builder metricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
            return this;
        }

        public final String getMetricSetName() {
            return metricSetName;
        }

        public final void setMetricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
        }

        @Override
        public final Builder metricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public MetricSetSummary build() {
            return new MetricSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
