/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about source data used to generate metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricSource implements SdkPojo, Serializable, ToCopyableBuilder<MetricSource.Builder, MetricSource> {
    private static final SdkField<S3SourceConfig> S3_SOURCE_CONFIG_FIELD = SdkField
            .<S3SourceConfig> builder(MarshallingType.SDK_POJO).memberName("S3SourceConfig")
            .getter(getter(MetricSource::s3SourceConfig)).setter(setter(Builder::s3SourceConfig))
            .constructor(S3SourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SourceConfig").build()).build();

    private static final SdkField<AppFlowConfig> APP_FLOW_CONFIG_FIELD = SdkField
            .<AppFlowConfig> builder(MarshallingType.SDK_POJO).memberName("AppFlowConfig")
            .getter(getter(MetricSource::appFlowConfig)).setter(setter(Builder::appFlowConfig))
            .constructor(AppFlowConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppFlowConfig").build()).build();

    private static final SdkField<CloudWatchConfig> CLOUD_WATCH_CONFIG_FIELD = SdkField
            .<CloudWatchConfig> builder(MarshallingType.SDK_POJO).memberName("CloudWatchConfig")
            .getter(getter(MetricSource::cloudWatchConfig)).setter(setter(Builder::cloudWatchConfig))
            .constructor(CloudWatchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchConfig").build()).build();

    private static final SdkField<RDSSourceConfig> RDS_SOURCE_CONFIG_FIELD = SdkField
            .<RDSSourceConfig> builder(MarshallingType.SDK_POJO).memberName("RDSSourceConfig")
            .getter(getter(MetricSource::rdsSourceConfig)).setter(setter(Builder::rdsSourceConfig))
            .constructor(RDSSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RDSSourceConfig").build()).build();

    private static final SdkField<RedshiftSourceConfig> REDSHIFT_SOURCE_CONFIG_FIELD = SdkField
            .<RedshiftSourceConfig> builder(MarshallingType.SDK_POJO).memberName("RedshiftSourceConfig")
            .getter(getter(MetricSource::redshiftSourceConfig)).setter(setter(Builder::redshiftSourceConfig))
            .constructor(RedshiftSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftSourceConfig").build())
            .build();

    private static final SdkField<AthenaSourceConfig> ATHENA_SOURCE_CONFIG_FIELD = SdkField
            .<AthenaSourceConfig> builder(MarshallingType.SDK_POJO).memberName("AthenaSourceConfig")
            .getter(getter(MetricSource::athenaSourceConfig)).setter(setter(Builder::athenaSourceConfig))
            .constructor(AthenaSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaSourceConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_SOURCE_CONFIG_FIELD,
            APP_FLOW_CONFIG_FIELD, CLOUD_WATCH_CONFIG_FIELD, RDS_SOURCE_CONFIG_FIELD, REDSHIFT_SOURCE_CONFIG_FIELD,
            ATHENA_SOURCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3SourceConfig s3SourceConfig;

    private final AppFlowConfig appFlowConfig;

    private final CloudWatchConfig cloudWatchConfig;

    private final RDSSourceConfig rdsSourceConfig;

    private final RedshiftSourceConfig redshiftSourceConfig;

    private final AthenaSourceConfig athenaSourceConfig;

    private MetricSource(BuilderImpl builder) {
        this.s3SourceConfig = builder.s3SourceConfig;
        this.appFlowConfig = builder.appFlowConfig;
        this.cloudWatchConfig = builder.cloudWatchConfig;
        this.rdsSourceConfig = builder.rdsSourceConfig;
        this.redshiftSourceConfig = builder.redshiftSourceConfig;
        this.athenaSourceConfig = builder.athenaSourceConfig;
    }

    /**
     * Returns the value of the S3SourceConfig property for this object.
     * 
     * @return The value of the S3SourceConfig property for this object.
     */
    public final S3SourceConfig s3SourceConfig() {
        return s3SourceConfig;
    }

    /**
     * <p>
     * Details about an AppFlow datasource.
     * </p>
     * 
     * @return Details about an AppFlow datasource.
     */
    public final AppFlowConfig appFlowConfig() {
        return appFlowConfig;
    }

    /**
     * <p>
     * Details about an Amazon CloudWatch monitoring datasource.
     * </p>
     * 
     * @return Details about an Amazon CloudWatch monitoring datasource.
     */
    public final CloudWatchConfig cloudWatchConfig() {
        return cloudWatchConfig;
    }

    /**
     * <p>
     * Details about an Amazon Relational Database Service (RDS) datasource.
     * </p>
     * 
     * @return Details about an Amazon Relational Database Service (RDS) datasource.
     */
    public final RDSSourceConfig rdsSourceConfig() {
        return rdsSourceConfig;
    }

    /**
     * <p>
     * Details about an Amazon Redshift database datasource.
     * </p>
     * 
     * @return Details about an Amazon Redshift database datasource.
     */
    public final RedshiftSourceConfig redshiftSourceConfig() {
        return redshiftSourceConfig;
    }

    /**
     * <p>
     * Details about an Amazon Athena datasource.
     * </p>
     * 
     * @return Details about an Amazon Athena datasource.
     */
    public final AthenaSourceConfig athenaSourceConfig() {
        return athenaSourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3SourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(appFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(rdsSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(athenaSourceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSource)) {
            return false;
        }
        MetricSource other = (MetricSource) obj;
        return Objects.equals(s3SourceConfig(), other.s3SourceConfig()) && Objects.equals(appFlowConfig(), other.appFlowConfig())
                && Objects.equals(cloudWatchConfig(), other.cloudWatchConfig())
                && Objects.equals(rdsSourceConfig(), other.rdsSourceConfig())
                && Objects.equals(redshiftSourceConfig(), other.redshiftSourceConfig())
                && Objects.equals(athenaSourceConfig(), other.athenaSourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricSource").add("S3SourceConfig", s3SourceConfig()).add("AppFlowConfig", appFlowConfig())
                .add("CloudWatchConfig", cloudWatchConfig()).add("RDSSourceConfig", rdsSourceConfig())
                .add("RedshiftSourceConfig", redshiftSourceConfig()).add("AthenaSourceConfig", athenaSourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3SourceConfig":
            return Optional.ofNullable(clazz.cast(s3SourceConfig()));
        case "AppFlowConfig":
            return Optional.ofNullable(clazz.cast(appFlowConfig()));
        case "CloudWatchConfig":
            return Optional.ofNullable(clazz.cast(cloudWatchConfig()));
        case "RDSSourceConfig":
            return Optional.ofNullable(clazz.cast(rdsSourceConfig()));
        case "RedshiftSourceConfig":
            return Optional.ofNullable(clazz.cast(redshiftSourceConfig()));
        case "AthenaSourceConfig":
            return Optional.ofNullable(clazz.cast(athenaSourceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3SourceConfig", S3_SOURCE_CONFIG_FIELD);
        map.put("AppFlowConfig", APP_FLOW_CONFIG_FIELD);
        map.put("CloudWatchConfig", CLOUD_WATCH_CONFIG_FIELD);
        map.put("RDSSourceConfig", RDS_SOURCE_CONFIG_FIELD);
        map.put("RedshiftSourceConfig", REDSHIFT_SOURCE_CONFIG_FIELD);
        map.put("AthenaSourceConfig", ATHENA_SOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricSource, T> g) {
        return obj -> g.apply((MetricSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricSource> {
        /**
         * Sets the value of the S3SourceConfig property for this object.
         *
         * @param s3SourceConfig
         *        The new value for the S3SourceConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3SourceConfig(S3SourceConfig s3SourceConfig);

        /**
         * Sets the value of the S3SourceConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3SourceConfig.Builder} avoiding the need
         * to create one manually via {@link S3SourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3SourceConfig(S3SourceConfig)}.
         * 
         * @param s3SourceConfig
         *        a consumer that will call methods on {@link S3SourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3SourceConfig(S3SourceConfig)
         */
        default Builder s3SourceConfig(Consumer<S3SourceConfig.Builder> s3SourceConfig) {
            return s3SourceConfig(S3SourceConfig.builder().applyMutation(s3SourceConfig).build());
        }

        /**
         * <p>
         * Details about an AppFlow datasource.
         * </p>
         * 
         * @param appFlowConfig
         *        Details about an AppFlow datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appFlowConfig(AppFlowConfig appFlowConfig);

        /**
         * <p>
         * Details about an AppFlow datasource.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppFlowConfig.Builder} avoiding the need
         * to create one manually via {@link AppFlowConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppFlowConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #appFlowConfig(AppFlowConfig)}.
         * 
         * @param appFlowConfig
         *        a consumer that will call methods on {@link AppFlowConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appFlowConfig(AppFlowConfig)
         */
        default Builder appFlowConfig(Consumer<AppFlowConfig.Builder> appFlowConfig) {
            return appFlowConfig(AppFlowConfig.builder().applyMutation(appFlowConfig).build());
        }

        /**
         * <p>
         * Details about an Amazon CloudWatch monitoring datasource.
         * </p>
         * 
         * @param cloudWatchConfig
         *        Details about an Amazon CloudWatch monitoring datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchConfig(CloudWatchConfig cloudWatchConfig);

        /**
         * <p>
         * Details about an Amazon CloudWatch monitoring datasource.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchConfig.Builder} avoiding the
         * need to create one manually via {@link CloudWatchConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudWatchConfig(CloudWatchConfig)}.
         * 
         * @param cloudWatchConfig
         *        a consumer that will call methods on {@link CloudWatchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchConfig(CloudWatchConfig)
         */
        default Builder cloudWatchConfig(Consumer<CloudWatchConfig.Builder> cloudWatchConfig) {
            return cloudWatchConfig(CloudWatchConfig.builder().applyMutation(cloudWatchConfig).build());
        }

        /**
         * <p>
         * Details about an Amazon Relational Database Service (RDS) datasource.
         * </p>
         * 
         * @param rdsSourceConfig
         *        Details about an Amazon Relational Database Service (RDS) datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsSourceConfig(RDSSourceConfig rdsSourceConfig);

        /**
         * <p>
         * Details about an Amazon Relational Database Service (RDS) datasource.
         * </p>
         * This is a convenience method that creates an instance of the {@link RDSSourceConfig.Builder} avoiding the
         * need to create one manually via {@link RDSSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RDSSourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #rdsSourceConfig(RDSSourceConfig)}.
         * 
         * @param rdsSourceConfig
         *        a consumer that will call methods on {@link RDSSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsSourceConfig(RDSSourceConfig)
         */
        default Builder rdsSourceConfig(Consumer<RDSSourceConfig.Builder> rdsSourceConfig) {
            return rdsSourceConfig(RDSSourceConfig.builder().applyMutation(rdsSourceConfig).build());
        }

        /**
         * <p>
         * Details about an Amazon Redshift database datasource.
         * </p>
         * 
         * @param redshiftSourceConfig
         *        Details about an Amazon Redshift database datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftSourceConfig(RedshiftSourceConfig redshiftSourceConfig);

        /**
         * <p>
         * Details about an Amazon Redshift database datasource.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftSourceConfig.Builder} avoiding
         * the need to create one manually via {@link RedshiftSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftSourceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #redshiftSourceConfig(RedshiftSourceConfig)}.
         * 
         * @param redshiftSourceConfig
         *        a consumer that will call methods on {@link RedshiftSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftSourceConfig(RedshiftSourceConfig)
         */
        default Builder redshiftSourceConfig(Consumer<RedshiftSourceConfig.Builder> redshiftSourceConfig) {
            return redshiftSourceConfig(RedshiftSourceConfig.builder().applyMutation(redshiftSourceConfig).build());
        }

        /**
         * <p>
         * Details about an Amazon Athena datasource.
         * </p>
         * 
         * @param athenaSourceConfig
         *        Details about an Amazon Athena datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaSourceConfig(AthenaSourceConfig athenaSourceConfig);

        /**
         * <p>
         * Details about an Amazon Athena datasource.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaSourceConfig.Builder} avoiding the
         * need to create one manually via {@link AthenaSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaSourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #athenaSourceConfig(AthenaSourceConfig)}.
         * 
         * @param athenaSourceConfig
         *        a consumer that will call methods on {@link AthenaSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaSourceConfig(AthenaSourceConfig)
         */
        default Builder athenaSourceConfig(Consumer<AthenaSourceConfig.Builder> athenaSourceConfig) {
            return athenaSourceConfig(AthenaSourceConfig.builder().applyMutation(athenaSourceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3SourceConfig s3SourceConfig;

        private AppFlowConfig appFlowConfig;

        private CloudWatchConfig cloudWatchConfig;

        private RDSSourceConfig rdsSourceConfig;

        private RedshiftSourceConfig redshiftSourceConfig;

        private AthenaSourceConfig athenaSourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSource model) {
            s3SourceConfig(model.s3SourceConfig);
            appFlowConfig(model.appFlowConfig);
            cloudWatchConfig(model.cloudWatchConfig);
            rdsSourceConfig(model.rdsSourceConfig);
            redshiftSourceConfig(model.redshiftSourceConfig);
            athenaSourceConfig(model.athenaSourceConfig);
        }

        public final S3SourceConfig.Builder getS3SourceConfig() {
            return s3SourceConfig != null ? s3SourceConfig.toBuilder() : null;
        }

        public final void setS3SourceConfig(S3SourceConfig.BuilderImpl s3SourceConfig) {
            this.s3SourceConfig = s3SourceConfig != null ? s3SourceConfig.build() : null;
        }

        @Override
        public final Builder s3SourceConfig(S3SourceConfig s3SourceConfig) {
            this.s3SourceConfig = s3SourceConfig;
            return this;
        }

        public final AppFlowConfig.Builder getAppFlowConfig() {
            return appFlowConfig != null ? appFlowConfig.toBuilder() : null;
        }

        public final void setAppFlowConfig(AppFlowConfig.BuilderImpl appFlowConfig) {
            this.appFlowConfig = appFlowConfig != null ? appFlowConfig.build() : null;
        }

        @Override
        public final Builder appFlowConfig(AppFlowConfig appFlowConfig) {
            this.appFlowConfig = appFlowConfig;
            return this;
        }

        public final CloudWatchConfig.Builder getCloudWatchConfig() {
            return cloudWatchConfig != null ? cloudWatchConfig.toBuilder() : null;
        }

        public final void setCloudWatchConfig(CloudWatchConfig.BuilderImpl cloudWatchConfig) {
            this.cloudWatchConfig = cloudWatchConfig != null ? cloudWatchConfig.build() : null;
        }

        @Override
        public final Builder cloudWatchConfig(CloudWatchConfig cloudWatchConfig) {
            this.cloudWatchConfig = cloudWatchConfig;
            return this;
        }

        public final RDSSourceConfig.Builder getRdsSourceConfig() {
            return rdsSourceConfig != null ? rdsSourceConfig.toBuilder() : null;
        }

        public final void setRdsSourceConfig(RDSSourceConfig.BuilderImpl rdsSourceConfig) {
            this.rdsSourceConfig = rdsSourceConfig != null ? rdsSourceConfig.build() : null;
        }

        @Override
        public final Builder rdsSourceConfig(RDSSourceConfig rdsSourceConfig) {
            this.rdsSourceConfig = rdsSourceConfig;
            return this;
        }

        public final RedshiftSourceConfig.Builder getRedshiftSourceConfig() {
            return redshiftSourceConfig != null ? redshiftSourceConfig.toBuilder() : null;
        }

        public final void setRedshiftSourceConfig(RedshiftSourceConfig.BuilderImpl redshiftSourceConfig) {
            this.redshiftSourceConfig = redshiftSourceConfig != null ? redshiftSourceConfig.build() : null;
        }

        @Override
        public final Builder redshiftSourceConfig(RedshiftSourceConfig redshiftSourceConfig) {
            this.redshiftSourceConfig = redshiftSourceConfig;
            return this;
        }

        public final AthenaSourceConfig.Builder getAthenaSourceConfig() {
            return athenaSourceConfig != null ? athenaSourceConfig.toBuilder() : null;
        }

        public final void setAthenaSourceConfig(AthenaSourceConfig.BuilderImpl athenaSourceConfig) {
            this.athenaSourceConfig = athenaSourceConfig != null ? athenaSourceConfig.build() : null;
        }

        @Override
        public final Builder athenaSourceConfig(AthenaSourceConfig athenaSourceConfig) {
            this.athenaSourceConfig = athenaSourceConfig;
            return this;
        }

        @Override
        public MetricSource build() {
            return new MetricSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
