/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFeedbackRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<PutFeedbackRequest.Builder, PutFeedbackRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(PutFeedbackRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<AnomalyGroupTimeSeriesFeedback> ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD = SdkField
            .<AnomalyGroupTimeSeriesFeedback> builder(MarshallingType.SDK_POJO)
            .memberName("AnomalyGroupTimeSeriesFeedback")
            .getter(getter(PutFeedbackRequest::anomalyGroupTimeSeriesFeedback))
            .setter(setter(Builder::anomalyGroupTimeSeriesFeedback))
            .constructor(AnomalyGroupTimeSeriesFeedback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupTimeSeriesFeedback")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String anomalyDetectorArn;

    private final AnomalyGroupTimeSeriesFeedback anomalyGroupTimeSeriesFeedback;

    private PutFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.anomalyGroupTimeSeriesFeedback = builder.anomalyGroupTimeSeriesFeedback;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the anomaly detector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the anomaly detector.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * Feedback for an anomalous metric.
     * </p>
     * 
     * @return Feedback for an anomalous metric.
     */
    public final AnomalyGroupTimeSeriesFeedback anomalyGroupTimeSeriesFeedback() {
        return anomalyGroupTimeSeriesFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupTimeSeriesFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFeedbackRequest)) {
            return false;
        }
        PutFeedbackRequest other = (PutFeedbackRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(anomalyGroupTimeSeriesFeedback(), other.anomalyGroupTimeSeriesFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFeedbackRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("AnomalyGroupTimeSeriesFeedback", anomalyGroupTimeSeriesFeedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "AnomalyGroupTimeSeriesFeedback":
            return Optional.ofNullable(clazz.cast(anomalyGroupTimeSeriesFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("AnomalyGroupTimeSeriesFeedback", ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFeedbackRequest, T> g) {
        return obj -> g.apply((PutFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutFeedbackRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the anomaly detector.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The Amazon Resource Name (ARN) of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * Feedback for an anomalous metric.
         * </p>
         * 
         * @param anomalyGroupTimeSeriesFeedback
         *        Feedback for an anomalous metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupTimeSeriesFeedback(AnomalyGroupTimeSeriesFeedback anomalyGroupTimeSeriesFeedback);

        /**
         * <p>
         * Feedback for an anomalous metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyGroupTimeSeriesFeedback.Builder}
         * avoiding the need to create one manually via {@link AnomalyGroupTimeSeriesFeedback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyGroupTimeSeriesFeedback.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #anomalyGroupTimeSeriesFeedback(AnomalyGroupTimeSeriesFeedback)}.
         * 
         * @param anomalyGroupTimeSeriesFeedback
         *        a consumer that will call methods on {@link AnomalyGroupTimeSeriesFeedback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyGroupTimeSeriesFeedback(AnomalyGroupTimeSeriesFeedback)
         */
        default Builder anomalyGroupTimeSeriesFeedback(
                Consumer<AnomalyGroupTimeSeriesFeedback.Builder> anomalyGroupTimeSeriesFeedback) {
            return anomalyGroupTimeSeriesFeedback(AnomalyGroupTimeSeriesFeedback.builder()
                    .applyMutation(anomalyGroupTimeSeriesFeedback).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private AnomalyGroupTimeSeriesFeedback anomalyGroupTimeSeriesFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFeedbackRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            anomalyGroupTimeSeriesFeedback(model.anomalyGroupTimeSeriesFeedback);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final AnomalyGroupTimeSeriesFeedback.Builder getAnomalyGroupTimeSeriesFeedback() {
            return anomalyGroupTimeSeriesFeedback != null ? anomalyGroupTimeSeriesFeedback.toBuilder() : null;
        }

        public final void setAnomalyGroupTimeSeriesFeedback(
                AnomalyGroupTimeSeriesFeedback.BuilderImpl anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback = anomalyGroupTimeSeriesFeedback != null ? anomalyGroupTimeSeriesFeedback.build()
                    : null;
        }

        @Override
        public final Builder anomalyGroupTimeSeriesFeedback(AnomalyGroupTimeSeriesFeedback anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback = anomalyGroupTimeSeriesFeedback;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFeedbackRequest build() {
            return new PutFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
