/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.AttributeValue;
import software.amazon.awssdk.services.lookoutmetrics.model.Confidence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectedField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectedField> {
    private static final SdkField<AttributeValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(DetectedField.getter(DetectedField::value)).setter(DetectedField.setter(Builder::value)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Confidence").getter(DetectedField.getter(DetectedField::confidenceAsString)).setter(DetectedField.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DetectedField.getter(DetectedField::message)).setter(DetectedField.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, CONFIDENCE_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectedField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AttributeValue value;
    private final String confidence;
    private final String message;

    private DetectedField(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
        this.message = builder.message;
    }

    public final AttributeValue value() {
        return this.value;
    }

    public final Confidence confidence() {
        return Confidence.fromValue(this.confidence);
    }

    public final String confidenceAsString() {
        return this.confidence;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedField)) {
            return false;
        }
        DetectedField other = (DetectedField)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.confidenceAsString(), other.confidenceAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"DetectedField").add("Value", (Object)this.value()).add("Confidence", (Object)this.confidenceAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidenceAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectedField, T> g) {
        return obj -> g.apply((DetectedField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeValue value;
        private String confidence;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedField model) {
            this.value(model.value);
            this.confidence(model.confidence);
            this.message(model.message);
        }

        public final AttributeValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(AttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(AttributeValue value) {
            this.value = value;
            return this;
        }

        public final String getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(String confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(String confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public final Builder confidence(Confidence confidence) {
            this.confidence(confidence == null ? null : confidence.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public DetectedField build() {
            return new DetectedField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectedField> {
        public Builder value(AttributeValue var1);

        default public Builder value(Consumer<AttributeValue.Builder> value) {
            return this.value((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(value)).build());
        }

        public Builder confidence(String var1);

        public Builder confidence(Confidence var1);

        public Builder message(String var1);
    }
}

