/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lookoutmetrics.model.AlertStatus;
import software.amazon.awssdk.services.lookoutmetrics.model.AlertType;
import software.amazon.awssdk.services.lookoutmetrics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlertSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlertSummary> {
    private static final SdkField<String> ALERT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertArn").getter(AlertSummary.getter(AlertSummary::alertArn)).setter(AlertSummary.setter(Builder::alertArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertArn").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(AlertSummary.getter(AlertSummary::anomalyDetectorArn)).setter(AlertSummary.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> ALERT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertName").getter(AlertSummary.getter(AlertSummary::alertName)).setter(AlertSummary.setter(Builder::alertName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertName").build()}).build();
    private static final SdkField<Integer> ALERT_SENSITIVITY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AlertSensitivityThreshold").getter(AlertSummary.getter(AlertSummary::alertSensitivityThreshold)).setter(AlertSummary.setter(Builder::alertSensitivityThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSensitivityThreshold").build()}).build();
    private static final SdkField<String> ALERT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertType").getter(AlertSummary.getter(AlertSummary::alertTypeAsString)).setter(AlertSummary.setter(Builder::alertType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertType").build()}).build();
    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertStatus").getter(AlertSummary.getter(AlertSummary::alertStatusAsString)).setter(AlertSummary.setter(Builder::alertStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(AlertSummary.getter(AlertSummary::lastModificationTime)).setter(AlertSummary.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AlertSummary.getter(AlertSummary::creationTime)).setter(AlertSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(AlertSummary.getter(AlertSummary::tags)).setter(AlertSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_ARN_FIELD, ANOMALY_DETECTOR_ARN_FIELD, ALERT_NAME_FIELD, ALERT_SENSITIVITY_THRESHOLD_FIELD, ALERT_TYPE_FIELD, ALERT_STATUS_FIELD, LAST_MODIFICATION_TIME_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlertSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alertArn;
    private final String anomalyDetectorArn;
    private final String alertName;
    private final Integer alertSensitivityThreshold;
    private final String alertType;
    private final String alertStatus;
    private final Instant lastModificationTime;
    private final Instant creationTime;
    private final Map<String, String> tags;

    private AlertSummary(BuilderImpl builder) {
        this.alertArn = builder.alertArn;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.alertName = builder.alertName;
        this.alertSensitivityThreshold = builder.alertSensitivityThreshold;
        this.alertType = builder.alertType;
        this.alertStatus = builder.alertStatus;
        this.lastModificationTime = builder.lastModificationTime;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    public final String alertArn() {
        return this.alertArn;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String alertName() {
        return this.alertName;
    }

    public final Integer alertSensitivityThreshold() {
        return this.alertSensitivityThreshold;
    }

    public final AlertType alertType() {
        return AlertType.fromValue(this.alertType);
    }

    public final String alertTypeAsString() {
        return this.alertType;
    }

    public final AlertStatus alertStatus() {
        return AlertStatus.fromValue(this.alertStatus);
    }

    public final String alertStatusAsString() {
        return this.alertStatus;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alertArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertSensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlertSummary)) {
            return false;
        }
        AlertSummary other = (AlertSummary)obj;
        return Objects.equals(this.alertArn(), other.alertArn()) && Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.alertName(), other.alertName()) && Objects.equals(this.alertSensitivityThreshold(), other.alertSensitivityThreshold()) && Objects.equals(this.alertTypeAsString(), other.alertTypeAsString()) && Objects.equals(this.alertStatusAsString(), other.alertStatusAsString()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AlertSummary").add("AlertArn", (Object)this.alertArn()).add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("AlertName", (Object)this.alertName()).add("AlertSensitivityThreshold", (Object)this.alertSensitivityThreshold()).add("AlertType", (Object)this.alertTypeAsString()).add("AlertStatus", (Object)this.alertStatusAsString()).add("LastModificationTime", (Object)this.lastModificationTime()).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlertArn": {
                return Optional.ofNullable(clazz.cast(this.alertArn()));
            }
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "AlertName": {
                return Optional.ofNullable(clazz.cast(this.alertName()));
            }
            case "AlertSensitivityThreshold": {
                return Optional.ofNullable(clazz.cast(this.alertSensitivityThreshold()));
            }
            case "AlertType": {
                return Optional.ofNullable(clazz.cast(this.alertTypeAsString()));
            }
            case "AlertStatus": {
                return Optional.ofNullable(clazz.cast(this.alertStatusAsString()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlertArn", ALERT_ARN_FIELD);
        map.put("AnomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("AlertName", ALERT_NAME_FIELD);
        map.put("AlertSensitivityThreshold", ALERT_SENSITIVITY_THRESHOLD_FIELD);
        map.put("AlertType", ALERT_TYPE_FIELD);
        map.put("AlertStatus", ALERT_STATUS_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlertSummary, T> g) {
        return obj -> g.apply((AlertSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alertArn;
        private String anomalyDetectorArn;
        private String alertName;
        private Integer alertSensitivityThreshold;
        private String alertType;
        private String alertStatus;
        private Instant lastModificationTime;
        private Instant creationTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlertSummary model) {
            this.alertArn(model.alertArn);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.alertName(model.alertName);
            this.alertSensitivityThreshold(model.alertSensitivityThreshold);
            this.alertType(model.alertType);
            this.alertStatus(model.alertStatus);
            this.lastModificationTime(model.lastModificationTime);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
        }

        public final String getAlertArn() {
            return this.alertArn;
        }

        public final void setAlertArn(String alertArn) {
            this.alertArn = alertArn;
        }

        @Override
        public final Builder alertArn(String alertArn) {
            this.alertArn = alertArn;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getAlertName() {
            return this.alertName;
        }

        public final void setAlertName(String alertName) {
            this.alertName = alertName;
        }

        @Override
        public final Builder alertName(String alertName) {
            this.alertName = alertName;
            return this;
        }

        public final Integer getAlertSensitivityThreshold() {
            return this.alertSensitivityThreshold;
        }

        public final void setAlertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
        }

        @Override
        public final Builder alertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
            return this;
        }

        public final String getAlertType() {
            return this.alertType;
        }

        public final void setAlertType(String alertType) {
            this.alertType = alertType;
        }

        @Override
        public final Builder alertType(String alertType) {
            this.alertType = alertType;
            return this;
        }

        @Override
        public final Builder alertType(AlertType alertType) {
            this.alertType(alertType == null ? null : alertType.toString());
            return this;
        }

        public final String getAlertStatus() {
            return this.alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(AlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public AlertSummary build() {
            return new AlertSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlertSummary> {
        public Builder alertArn(String var1);

        public Builder anomalyDetectorArn(String var1);

        public Builder alertName(String var1);

        public Builder alertSensitivityThreshold(Integer var1);

        public Builder alertType(String var1);

        public Builder alertType(AlertType var1);

        public Builder alertStatus(String var1);

        public Builder alertStatus(AlertStatus var1);

        public Builder lastModificationTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

