/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyGroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyGroupSummary> {
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(AnomalyGroupSummary.getter(AnomalyGroupSummary::startTime)).setter(AnomalyGroupSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTime").getter(AnomalyGroupSummary.getter(AnomalyGroupSummary::endTime)).setter(AnomalyGroupSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyGroupId").getter(AnomalyGroupSummary.getter(AnomalyGroupSummary::anomalyGroupId)).setter(AnomalyGroupSummary.setter(Builder::anomalyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()}).build();
    private static final SdkField<Double> ANOMALY_GROUP_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AnomalyGroupScore").getter(AnomalyGroupSummary.getter(AnomalyGroupSummary::anomalyGroupScore)).setter(AnomalyGroupSummary.setter(Builder::anomalyGroupScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupScore").build()}).build();
    private static final SdkField<String> PRIMARY_METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryMetricName").getter(AnomalyGroupSummary.getter(AnomalyGroupSummary::primaryMetricName)).setter(AnomalyGroupSummary.setter(Builder::primaryMetricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMetricName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, ANOMALY_GROUP_ID_FIELD, ANOMALY_GROUP_SCORE_FIELD, PRIMARY_METRIC_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnomalyGroupSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String startTime;
    private final String endTime;
    private final String anomalyGroupId;
    private final Double anomalyGroupScore;
    private final String primaryMetricName;

    private AnomalyGroupSummary(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.anomalyGroupId = builder.anomalyGroupId;
        this.anomalyGroupScore = builder.anomalyGroupScore;
        this.primaryMetricName = builder.primaryMetricName;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final String anomalyGroupId() {
        return this.anomalyGroupId;
    }

    public final Double anomalyGroupScore() {
        return this.anomalyGroupScore;
    }

    public final String primaryMetricName() {
        return this.primaryMetricName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryMetricName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyGroupSummary)) {
            return false;
        }
        AnomalyGroupSummary other = (AnomalyGroupSummary)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.anomalyGroupId(), other.anomalyGroupId()) && Objects.equals(this.anomalyGroupScore(), other.anomalyGroupScore()) && Objects.equals(this.primaryMetricName(), other.primaryMetricName());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyGroupSummary").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("AnomalyGroupId", (Object)this.anomalyGroupId()).add("AnomalyGroupScore", (Object)this.anomalyGroupScore()).add("PrimaryMetricName", (Object)this.primaryMetricName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "AnomalyGroupId": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupId()));
            }
            case "AnomalyGroupScore": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupScore()));
            }
            case "PrimaryMetricName": {
                return Optional.ofNullable(clazz.cast(this.primaryMetricName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("AnomalyGroupId", ANOMALY_GROUP_ID_FIELD);
        map.put("AnomalyGroupScore", ANOMALY_GROUP_SCORE_FIELD);
        map.put("PrimaryMetricName", PRIMARY_METRIC_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalyGroupSummary, T> g) {
        return obj -> g.apply((AnomalyGroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String startTime;
        private String endTime;
        private String anomalyGroupId;
        private Double anomalyGroupScore;
        private String primaryMetricName;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyGroupSummary model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.anomalyGroupId(model.anomalyGroupId);
            this.anomalyGroupScore(model.anomalyGroupScore);
            this.primaryMetricName(model.primaryMetricName);
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getAnomalyGroupId() {
            return this.anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final Double getAnomalyGroupScore() {
            return this.anomalyGroupScore;
        }

        public final void setAnomalyGroupScore(Double anomalyGroupScore) {
            this.anomalyGroupScore = anomalyGroupScore;
        }

        @Override
        public final Builder anomalyGroupScore(Double anomalyGroupScore) {
            this.anomalyGroupScore = anomalyGroupScore;
            return this;
        }

        public final String getPrimaryMetricName() {
            return this.primaryMetricName;
        }

        public final void setPrimaryMetricName(String primaryMetricName) {
            this.primaryMetricName = primaryMetricName;
        }

        @Override
        public final Builder primaryMetricName(String primaryMetricName) {
            this.primaryMetricName = primaryMetricName;
            return this;
        }

        public AnomalyGroupSummary build() {
            return new AnomalyGroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyGroupSummary> {
        public Builder startTime(String var1);

        public Builder endTime(String var1);

        public Builder anomalyGroupId(String var1);

        public Builder anomalyGroupScore(Double var1);

        public Builder primaryMetricName(String var1);
    }
}

