/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.HistoricalDataPathListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.TemplatedPathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoDetectionS3SourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoDetectionS3SourceConfig> {
    private static final SdkField<List<String>> TEMPLATED_PATH_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TemplatedPathList").getter(AutoDetectionS3SourceConfig.getter(AutoDetectionS3SourceConfig::templatedPathList)).setter(AutoDetectionS3SourceConfig.setter(Builder::templatedPathList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatedPathList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HISTORICAL_DATA_PATH_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HistoricalDataPathList").getter(AutoDetectionS3SourceConfig.getter(AutoDetectionS3SourceConfig::historicalDataPathList)).setter(AutoDetectionS3SourceConfig.setter(Builder::historicalDataPathList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalDataPathList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATED_PATH_LIST_FIELD, HISTORICAL_DATA_PATH_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoDetectionS3SourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> templatedPathList;
    private final List<String> historicalDataPathList;

    private AutoDetectionS3SourceConfig(BuilderImpl builder) {
        this.templatedPathList = builder.templatedPathList;
        this.historicalDataPathList = builder.historicalDataPathList;
    }

    public final boolean hasTemplatedPathList() {
        return this.templatedPathList != null && !(this.templatedPathList instanceof SdkAutoConstructList);
    }

    public final List<String> templatedPathList() {
        return this.templatedPathList;
    }

    public final boolean hasHistoricalDataPathList() {
        return this.historicalDataPathList != null && !(this.historicalDataPathList instanceof SdkAutoConstructList);
    }

    public final List<String> historicalDataPathList() {
        return this.historicalDataPathList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplatedPathList() ? this.templatedPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHistoricalDataPathList() ? this.historicalDataPathList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoDetectionS3SourceConfig)) {
            return false;
        }
        AutoDetectionS3SourceConfig other = (AutoDetectionS3SourceConfig)obj;
        return this.hasTemplatedPathList() == other.hasTemplatedPathList() && Objects.equals(this.templatedPathList(), other.templatedPathList()) && this.hasHistoricalDataPathList() == other.hasHistoricalDataPathList() && Objects.equals(this.historicalDataPathList(), other.historicalDataPathList());
    }

    public final String toString() {
        return ToString.builder((String)"AutoDetectionS3SourceConfig").add("TemplatedPathList", this.hasTemplatedPathList() ? this.templatedPathList() : null).add("HistoricalDataPathList", this.hasHistoricalDataPathList() ? this.historicalDataPathList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplatedPathList": {
                return Optional.ofNullable(clazz.cast(this.templatedPathList()));
            }
            case "HistoricalDataPathList": {
                return Optional.ofNullable(clazz.cast(this.historicalDataPathList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("TemplatedPathList", TEMPLATED_PATH_LIST_FIELD);
        map.put("HistoricalDataPathList", HISTORICAL_DATA_PATH_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoDetectionS3SourceConfig, T> g) {
        return obj -> g.apply((AutoDetectionS3SourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> templatedPathList = DefaultSdkAutoConstructList.getInstance();
        private List<String> historicalDataPathList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoDetectionS3SourceConfig model) {
            this.templatedPathList(model.templatedPathList);
            this.historicalDataPathList(model.historicalDataPathList);
        }

        public final Collection<String> getTemplatedPathList() {
            if (this.templatedPathList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.templatedPathList;
        }

        public final void setTemplatedPathList(Collection<String> templatedPathList) {
            this.templatedPathList = TemplatedPathListCopier.copy(templatedPathList);
        }

        @Override
        public final Builder templatedPathList(Collection<String> templatedPathList) {
            this.templatedPathList = TemplatedPathListCopier.copy(templatedPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatedPathList(String ... templatedPathList) {
            this.templatedPathList(Arrays.asList(templatedPathList));
            return this;
        }

        public final Collection<String> getHistoricalDataPathList() {
            if (this.historicalDataPathList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.historicalDataPathList;
        }

        public final void setHistoricalDataPathList(Collection<String> historicalDataPathList) {
            this.historicalDataPathList = HistoricalDataPathListCopier.copy(historicalDataPathList);
        }

        @Override
        public final Builder historicalDataPathList(Collection<String> historicalDataPathList) {
            this.historicalDataPathList = HistoricalDataPathListCopier.copy(historicalDataPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalDataPathList(String ... historicalDataPathList) {
            this.historicalDataPathList(Arrays.asList(historicalDataPathList));
            return this;
        }

        public AutoDetectionS3SourceConfig build() {
            return new AutoDetectionS3SourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoDetectionS3SourceConfig> {
        public Builder templatedPathList(Collection<String> var1);

        public Builder templatedPathList(String ... var1);

        public Builder historicalDataPathList(Collection<String> var1);

        public Builder historicalDataPathList(String ... var1);
    }
}

