/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.DataQualityMetricType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityMetric> {
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricType").getter(DataQualityMetric.getter(DataQualityMetric::metricTypeAsString)).setter(DataQualityMetric.setter(Builder::metricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()}).build();
    private static final SdkField<String> METRIC_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricDescription").getter(DataQualityMetric.getter(DataQualityMetric::metricDescription)).setter(DataQualityMetric.setter(Builder::metricDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDescription").build()}).build();
    private static final SdkField<String> RELATED_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedColumnName").getter(DataQualityMetric.getter(DataQualityMetric::relatedColumnName)).setter(DataQualityMetric.setter(Builder::relatedColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedColumnName").build()}).build();
    private static final SdkField<Double> METRIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MetricValue").getter(DataQualityMetric.getter(DataQualityMetric::metricValue)).setter(DataQualityMetric.setter(Builder::metricValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_TYPE_FIELD, METRIC_DESCRIPTION_FIELD, RELATED_COLUMN_NAME_FIELD, METRIC_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQualityMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricType;
    private final String metricDescription;
    private final String relatedColumnName;
    private final Double metricValue;

    private DataQualityMetric(BuilderImpl builder) {
        this.metricType = builder.metricType;
        this.metricDescription = builder.metricDescription;
        this.relatedColumnName = builder.relatedColumnName;
        this.metricValue = builder.metricValue;
    }

    public final DataQualityMetricType metricType() {
        return DataQualityMetricType.fromValue(this.metricType);
    }

    public final String metricTypeAsString() {
        return this.metricType;
    }

    public final String metricDescription() {
        return this.metricDescription;
    }

    public final String relatedColumnName() {
        return this.relatedColumnName;
    }

    public final Double metricValue() {
        return this.metricValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityMetric)) {
            return false;
        }
        DataQualityMetric other = (DataQualityMetric)obj;
        return Objects.equals(this.metricTypeAsString(), other.metricTypeAsString()) && Objects.equals(this.metricDescription(), other.metricDescription()) && Objects.equals(this.relatedColumnName(), other.relatedColumnName()) && Objects.equals(this.metricValue(), other.metricValue());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityMetric").add("MetricType", (Object)this.metricTypeAsString()).add("MetricDescription", (Object)this.metricDescription()).add("RelatedColumnName", (Object)this.relatedColumnName()).add("MetricValue", (Object)this.metricValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricType": {
                return Optional.ofNullable(clazz.cast(this.metricTypeAsString()));
            }
            case "MetricDescription": {
                return Optional.ofNullable(clazz.cast(this.metricDescription()));
            }
            case "RelatedColumnName": {
                return Optional.ofNullable(clazz.cast(this.relatedColumnName()));
            }
            case "MetricValue": {
                return Optional.ofNullable(clazz.cast(this.metricValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricType", METRIC_TYPE_FIELD);
        map.put("MetricDescription", METRIC_DESCRIPTION_FIELD);
        map.put("RelatedColumnName", RELATED_COLUMN_NAME_FIELD);
        map.put("MetricValue", METRIC_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityMetric, T> g) {
        return obj -> g.apply((DataQualityMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricType;
        private String metricDescription;
        private String relatedColumnName;
        private Double metricValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityMetric model) {
            this.metricType(model.metricType);
            this.metricDescription(model.metricDescription);
            this.relatedColumnName(model.relatedColumnName);
            this.metricValue(model.metricValue);
        }

        public final String getMetricType() {
            return this.metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(DataQualityMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final String getMetricDescription() {
            return this.metricDescription;
        }

        public final void setMetricDescription(String metricDescription) {
            this.metricDescription = metricDescription;
        }

        @Override
        public final Builder metricDescription(String metricDescription) {
            this.metricDescription = metricDescription;
            return this;
        }

        public final String getRelatedColumnName() {
            return this.relatedColumnName;
        }

        public final void setRelatedColumnName(String relatedColumnName) {
            this.relatedColumnName = relatedColumnName;
        }

        @Override
        public final Builder relatedColumnName(String relatedColumnName) {
            this.relatedColumnName = relatedColumnName;
            return this;
        }

        public final Double getMetricValue() {
            return this.metricValue;
        }

        public final void setMetricValue(Double metricValue) {
            this.metricValue = metricValue;
        }

        @Override
        public final Builder metricValue(Double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public DataQualityMetric build() {
            return new DataQualityMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityMetric> {
        public Builder metricType(String var1);

        public Builder metricType(DataQualityMetricType var1);

        public Builder metricDescription(String var1);

        public Builder relatedColumnName(String var1);

        public Builder metricValue(Double var1);
    }
}

