/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.FileFormatDescriptor;
import software.amazon.awssdk.services.lookoutmetrics.model.HistoricalDataPathListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.TemplatedPathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3SourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3SourceConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(S3SourceConfig.getter(S3SourceConfig::roleArn)).setter(S3SourceConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<String>> TEMPLATED_PATH_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TemplatedPathList").getter(S3SourceConfig.getter(S3SourceConfig::templatedPathList)).setter(S3SourceConfig.setter(Builder::templatedPathList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatedPathList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HISTORICAL_DATA_PATH_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HistoricalDataPathList").getter(S3SourceConfig.getter(S3SourceConfig::historicalDataPathList)).setter(S3SourceConfig.setter(Builder::historicalDataPathList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalDataPathList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FileFormatDescriptor> FILE_FORMAT_DESCRIPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FileFormatDescriptor").getter(S3SourceConfig.getter(S3SourceConfig::fileFormatDescriptor)).setter(S3SourceConfig.setter(Builder::fileFormatDescriptor)).constructor(FileFormatDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormatDescriptor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, TEMPLATED_PATH_LIST_FIELD, HISTORICAL_DATA_PATH_LIST_FIELD, FILE_FORMAT_DESCRIPTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3SourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final List<String> templatedPathList;
    private final List<String> historicalDataPathList;
    private final FileFormatDescriptor fileFormatDescriptor;

    private S3SourceConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.templatedPathList = builder.templatedPathList;
        this.historicalDataPathList = builder.historicalDataPathList;
        this.fileFormatDescriptor = builder.fileFormatDescriptor;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTemplatedPathList() {
        return this.templatedPathList != null && !(this.templatedPathList instanceof SdkAutoConstructList);
    }

    public final List<String> templatedPathList() {
        return this.templatedPathList;
    }

    public final boolean hasHistoricalDataPathList() {
        return this.historicalDataPathList != null && !(this.historicalDataPathList instanceof SdkAutoConstructList);
    }

    public final List<String> historicalDataPathList() {
        return this.historicalDataPathList;
    }

    public final FileFormatDescriptor fileFormatDescriptor() {
        return this.fileFormatDescriptor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplatedPathList() ? this.templatedPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHistoricalDataPathList() ? this.historicalDataPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatDescriptor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SourceConfig)) {
            return false;
        }
        S3SourceConfig other = (S3SourceConfig)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && this.hasTemplatedPathList() == other.hasTemplatedPathList() && Objects.equals(this.templatedPathList(), other.templatedPathList()) && this.hasHistoricalDataPathList() == other.hasHistoricalDataPathList() && Objects.equals(this.historicalDataPathList(), other.historicalDataPathList()) && Objects.equals(this.fileFormatDescriptor(), other.fileFormatDescriptor());
    }

    public final String toString() {
        return ToString.builder((String)"S3SourceConfig").add("RoleArn", (Object)this.roleArn()).add("TemplatedPathList", this.hasTemplatedPathList() ? this.templatedPathList() : null).add("HistoricalDataPathList", this.hasHistoricalDataPathList() ? this.historicalDataPathList() : null).add("FileFormatDescriptor", (Object)this.fileFormatDescriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "TemplatedPathList": {
                return Optional.ofNullable(clazz.cast(this.templatedPathList()));
            }
            case "HistoricalDataPathList": {
                return Optional.ofNullable(clazz.cast(this.historicalDataPathList()));
            }
            case "FileFormatDescriptor": {
                return Optional.ofNullable(clazz.cast(this.fileFormatDescriptor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("TemplatedPathList", TEMPLATED_PATH_LIST_FIELD);
        map.put("HistoricalDataPathList", HISTORICAL_DATA_PATH_LIST_FIELD);
        map.put("FileFormatDescriptor", FILE_FORMAT_DESCRIPTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3SourceConfig, T> g) {
        return obj -> g.apply((S3SourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private List<String> templatedPathList = DefaultSdkAutoConstructList.getInstance();
        private List<String> historicalDataPathList = DefaultSdkAutoConstructList.getInstance();
        private FileFormatDescriptor fileFormatDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SourceConfig model) {
            this.roleArn(model.roleArn);
            this.templatedPathList(model.templatedPathList);
            this.historicalDataPathList(model.historicalDataPathList);
            this.fileFormatDescriptor(model.fileFormatDescriptor);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getTemplatedPathList() {
            if (this.templatedPathList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.templatedPathList;
        }

        public final void setTemplatedPathList(Collection<String> templatedPathList) {
            this.templatedPathList = TemplatedPathListCopier.copy(templatedPathList);
        }

        @Override
        public final Builder templatedPathList(Collection<String> templatedPathList) {
            this.templatedPathList = TemplatedPathListCopier.copy(templatedPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatedPathList(String ... templatedPathList) {
            this.templatedPathList(Arrays.asList(templatedPathList));
            return this;
        }

        public final Collection<String> getHistoricalDataPathList() {
            if (this.historicalDataPathList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.historicalDataPathList;
        }

        public final void setHistoricalDataPathList(Collection<String> historicalDataPathList) {
            this.historicalDataPathList = HistoricalDataPathListCopier.copy(historicalDataPathList);
        }

        @Override
        public final Builder historicalDataPathList(Collection<String> historicalDataPathList) {
            this.historicalDataPathList = HistoricalDataPathListCopier.copy(historicalDataPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalDataPathList(String ... historicalDataPathList) {
            this.historicalDataPathList(Arrays.asList(historicalDataPathList));
            return this;
        }

        public final FileFormatDescriptor.Builder getFileFormatDescriptor() {
            return this.fileFormatDescriptor != null ? this.fileFormatDescriptor.toBuilder() : null;
        }

        public final void setFileFormatDescriptor(FileFormatDescriptor.BuilderImpl fileFormatDescriptor) {
            this.fileFormatDescriptor = fileFormatDescriptor != null ? fileFormatDescriptor.build() : null;
        }

        @Override
        public final Builder fileFormatDescriptor(FileFormatDescriptor fileFormatDescriptor) {
            this.fileFormatDescriptor = fileFormatDescriptor;
            return this;
        }

        public S3SourceConfig build() {
            return new S3SourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3SourceConfig> {
        public Builder roleArn(String var1);

        public Builder templatedPathList(Collection<String> var1);

        public Builder templatedPathList(String ... var1);

        public Builder historicalDataPathList(Collection<String> var1);

        public Builder historicalDataPathList(String ... var1);

        public Builder fileFormatDescriptor(FileFormatDescriptor var1);

        default public Builder fileFormatDescriptor(Consumer<FileFormatDescriptor.Builder> fileFormatDescriptor) {
            return this.fileFormatDescriptor((FileFormatDescriptor)((FileFormatDescriptor.Builder)FileFormatDescriptor.builder().applyMutation(fileFormatDescriptor)).build());
        }
    }
}

