/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelRequest extends LookoutVisionRequest implements
        ToCopyableBuilder<CreateModelRequest.Builder, CreateModelRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(CreateModelRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<ModelDescription> DESCRIPTION_FIELD = SdkField
            .<ModelDescription> builder(MarshallingType.SDK_POJO).memberName("Description")
            .getter(getter(CreateModelRequest::description)).setter(setter(Builder::description))
            .constructor(ModelDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(CreateModelRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateModelRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD));

    private final String projectName;

    private final ModelDescription description;

    private final String clientToken;

    private final OutputConfig outputConfig;

    private final String kmsKeyId;

    private CreateModelRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The name of the project in which you want to create a model version.
     * </p>
     * 
     * @return The name of the project in which you want to create a model version.
     */
    public String projectName() {
        return projectName;
    }

    /**
     * <p>
     * A description for the version of the model.
     * </p>
     * 
     * @return A description for the version of the model.
     */
    public ModelDescription description() {
        return description;
    }

    /**
     * <p>
     * ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You
     * choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a
     * response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using
     * the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same
     * as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to
     * <code>CreateModel</code>. An idempotency token is active for 8 hours.
     * </p>
     * 
     * @return ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once.
     *         You choose the value to pass. For example, An issue, such as an network outage, might prevent you from
     *         getting a response from <code>CreateModel</code>. In this case, safely retry your call to
     *         <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs if
     *         the other input parameters are not the same as in the first request. Using a different value for
     *         <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is
     *         active for 8 hours.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The location where Amazon Lookout for Vision saves the training results.
     * </p>
     * 
     * @return The location where Amazon Lookout for Vision saves the training results.
     */
    public OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for encypting the
     * model. If this parameter is not specified, the model is encrypted by a key that AWS owns and manages.
     * </p>
     * 
     * @return The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for encypting
     *         the model. If this parameter is not specified, the model is encrypted by a key that AWS owns and manages.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(description(), other.description())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateModelRequest").add("ProjectName", projectName()).add("Description", description())
                .add("ClientToken", clientToken()).add("OutputConfig", outputConfig()).add("KmsKeyId", kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelRequest, T> g) {
        return obj -> g.apply((CreateModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelRequest> {
        /**
         * <p>
         * The name of the project in which you want to create a model version.
         * </p>
         * 
         * @param projectName
         *        The name of the project in which you want to create a model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * A description for the version of the model.
         * </p>
         * 
         * @param description
         *        A description for the version of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(ModelDescription description);

        /**
         * <p>
         * A description for the version of the model.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelDescription.Builder} avoiding the need to
         * create one manually via {@link ModelDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #description(ModelDescription)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link ModelDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(ModelDescription)
         */
        default Builder description(Consumer<ModelDescription.Builder> description) {
            return description(ModelDescription.builder().applyMutation(description).build());
        }

        /**
         * <p>
         * ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You
         * choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a
         * response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by
         * using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are
         * not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a
         * new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only
         *        once. You choose the value to pass. For example, An issue, such as an network outage, might prevent
         *        you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to
         *        <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
         *        if the other input parameters are not the same as in the first request. Using a different value for
         *        <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is
         *        active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The location where Amazon Lookout for Vision saves the training results.
         * </p>
         * 
         * @param outputConfig
         *        The location where Amazon Lookout for Vision saves the training results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * The location where Amazon Lookout for Vision saves the training results.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputConfig.Builder} avoiding the need to
         * create one manually via {@link OutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for encypting the
         * model. If this parameter is not specified, the model is encrypted by a key that AWS owns and manages.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for
         *        encypting the model. If this parameter is not specified, the model is encrypted by a key that AWS owns
         *        and manages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutVisionRequest.BuilderImpl implements Builder {
        private String projectName;

        private ModelDescription description;

        private String clientToken;

        private OutputConfig outputConfig;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelRequest model) {
            super(model);
            projectName(model.projectName);
            description(model.description);
            clientToken(model.clientToken);
            outputConfig(model.outputConfig);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final ModelDescription.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        @Override
        public final Builder description(ModelDescription description) {
            this.description = description;
            return this;
        }

        public final void setDescription(ModelDescription.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelRequest build() {
            return new CreateModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
