/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatasetEntriesRequest extends LookoutVisionRequest implements
        ToCopyableBuilder<ListDatasetEntriesRequest.Builder, ListDatasetEntriesRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(ListDatasetEntriesRequest::projectName))
            .setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(ListDatasetEntriesRequest::datasetType))
            .setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetType").build()).build();

    private static final SdkField<Boolean> LABELED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Labeled").getter(getter(ListDatasetEntriesRequest::labeled)).setter(setter(Builder::labeled))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("labeled").build()).build();

    private static final SdkField<String> ANOMALY_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyClass").getter(getter(ListDatasetEntriesRequest::anomalyClass))
            .setter(setter(Builder::anomalyClass))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("anomalyClass").build()).build();

    private static final SdkField<Instant> BEFORE_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BeforeCreationDate").getter(getter(ListDatasetEntriesRequest::beforeCreationDate))
            .setter(setter(Builder::beforeCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()).build();

    private static final SdkField<Instant> AFTER_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AfterCreationDate").getter(getter(ListDatasetEntriesRequest::afterCreationDate))
            .setter(setter(Builder::afterCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDatasetEntriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDatasetEntriesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> SOURCE_REF_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRefContains").getter(getter(ListDatasetEntriesRequest::sourceRefContains))
            .setter(setter(Builder::sourceRefContains))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sourceRefContains").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            DATASET_TYPE_FIELD, LABELED_FIELD, ANOMALY_CLASS_FIELD, BEFORE_CREATION_DATE_FIELD, AFTER_CREATION_DATE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SOURCE_REF_CONTAINS_FIELD));

    private final String projectName;

    private final String datasetType;

    private final Boolean labeled;

    private final String anomalyClass;

    private final Instant beforeCreationDate;

    private final Instant afterCreationDate;

    private final String nextToken;

    private final Integer maxResults;

    private final String sourceRefContains;

    private ListDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.datasetType = builder.datasetType;
        this.labeled = builder.labeled;
        this.anomalyClass = builder.anomalyClass;
        this.beforeCreationDate = builder.beforeCreationDate;
        this.afterCreationDate = builder.afterCreationDate;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sourceRefContains = builder.sourceRefContains;
    }

    /**
     * <p>
     * The name of the project that contains the dataset that you want to list.
     * </p>
     * 
     * @return The name of the project that contains the dataset that you want to list.
     */
    public String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify
     * <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.
     * </p>
     * 
     * @return The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset.
     *         Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify
     *         <code>train</code>.
     */
    public String datasetType() {
        return datasetType;
    }

    /**
     * <p>
     * Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't specify
     * a value, Lookout for Vision returns all entries.
     * </p>
     * 
     * @return Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't
     *         specify a value, Lookout for Vision returns all entries.
     */
    public Boolean labeled() {
        return labeled;
    }

    /**
     * <p>
     * Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous
     * entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.
     * </p>
     * 
     * @return Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include
     *         anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous
     *         images.
     */
    public String anomalyClass() {
        return anomalyClass;
    }

    /**
     * <p>
     * Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.
     * </p>
     * 
     * @return Only includes entries before the specified date in the response. For example,
     *         <code>2020-06-23T00:00:00</code>.
     */
    public Instant beforeCreationDate() {
        return beforeCreationDate;
    }

    /**
     * <p>
     * Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.
     * </p>
     * 
     * @return Only includes entries after the specified date in the response. For example,
     *         <code>2020-06-23T00:00:00</code>.
     */
    public Instant afterCreationDate() {
        return afterCreationDate;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision
     * returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset
     * entries.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for
     *         Vision returns a pagination token in the response. You can use this pagination token to retrieve the next
     *         set of dataset entries.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
     * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * </p>
     * 
     * @return The maximum number of results to return per paginated call. The largest value you can specify is 100. If
     *         you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a
     * value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.
     * </p>
     * 
     * @return Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For
     *         example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches
     *         <i>*IMG_17*</i>.
     */
    public String sourceRefContains() {
        return sourceRefContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(labeled());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyClass());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(afterCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRefContains());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetEntriesRequest)) {
            return false;
        }
        ListDatasetEntriesRequest other = (ListDatasetEntriesRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(datasetType(), other.datasetType())
                && Objects.equals(labeled(), other.labeled()) && Objects.equals(anomalyClass(), other.anomalyClass())
                && Objects.equals(beforeCreationDate(), other.beforeCreationDate())
                && Objects.equals(afterCreationDate(), other.afterCreationDate())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sourceRefContains(), other.sourceRefContains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDatasetEntriesRequest").add("ProjectName", projectName()).add("DatasetType", datasetType())
                .add("Labeled", labeled()).add("AnomalyClass", anomalyClass()).add("BeforeCreationDate", beforeCreationDate())
                .add("AfterCreationDate", afterCreationDate()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("SourceRefContains", sourceRefContains()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetType()));
        case "Labeled":
            return Optional.ofNullable(clazz.cast(labeled()));
        case "AnomalyClass":
            return Optional.ofNullable(clazz.cast(anomalyClass()));
        case "BeforeCreationDate":
            return Optional.ofNullable(clazz.cast(beforeCreationDate()));
        case "AfterCreationDate":
            return Optional.ofNullable(clazz.cast(afterCreationDate()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SourceRefContains":
            return Optional.ofNullable(clazz.cast(sourceRefContains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetEntriesRequest, T> g) {
        return obj -> g.apply((ListDatasetEntriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDatasetEntriesRequest> {
        /**
         * <p>
         * The name of the project that contains the dataset that you want to list.
         * </p>
         * 
         * @param projectName
         *        The name of the project that contains the dataset that you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset.
         * Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify
         * <code>train</code>.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset that you want to list. Specify <code>train</code> to list the training
         *        dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project,
         *        specify <code>train</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't
         * specify a value, Lookout for Vision returns all entries.
         * </p>
         * 
         * @param labeled
         *        Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you
         *        don't specify a value, Lookout for Vision returns all entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labeled(Boolean labeled);

        /**
         * <p>
         * Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include
         * anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous
         * images.
         * </p>
         * 
         * @param anomalyClass
         *        Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only
         *        include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and
         *        anomalous images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyClass(String anomalyClass);

        /**
         * <p>
         * Only includes entries before the specified date in the response. For example,
         * <code>2020-06-23T00:00:00</code>.
         * </p>
         * 
         * @param beforeCreationDate
         *        Only includes entries before the specified date in the response. For example,
         *        <code>2020-06-23T00:00:00</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCreationDate(Instant beforeCreationDate);

        /**
         * <p>
         * Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>
         * .
         * </p>
         * 
         * @param afterCreationDate
         *        Only includes entries after the specified date in the response. For example,
         *        <code>2020-06-23T00:00:00</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCreationDate(Instant afterCreationDate);

        /**
         * <p>
         * If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision
         * returns a pagination token in the response. You can use this pagination token to retrieve the next set of
         * dataset entries.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for
         *        Vision returns a pagination token in the response. You can use this pagination token to retrieve the
         *        next set of dataset entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
         * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per paginated call. The largest value you can specify is 100.
         *        If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example
         * a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches
         * <i>*IMG_17*</i>.
         * </p>
         * 
         * @param sourceRefContains
         *        Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For
         *        example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches
         *        <i>*IMG_17*</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRefContains(String sourceRefContains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutVisionRequest.BuilderImpl implements Builder {
        private String projectName;

        private String datasetType;

        private Boolean labeled;

        private String anomalyClass;

        private Instant beforeCreationDate;

        private Instant afterCreationDate;

        private String nextToken;

        private Integer maxResults;

        private String sourceRefContains;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetEntriesRequest model) {
            super(model);
            projectName(model.projectName);
            datasetType(model.datasetType);
            labeled(model.labeled);
            anomalyClass(model.anomalyClass);
            beforeCreationDate(model.beforeCreationDate);
            afterCreationDate(model.afterCreationDate);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sourceRefContains(model.sourceRefContains);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        public final Boolean getLabeled() {
            return labeled;
        }

        @Override
        public final Builder labeled(Boolean labeled) {
            this.labeled = labeled;
            return this;
        }

        public final void setLabeled(Boolean labeled) {
            this.labeled = labeled;
        }

        public final String getAnomalyClass() {
            return anomalyClass;
        }

        @Override
        public final Builder anomalyClass(String anomalyClass) {
            this.anomalyClass = anomalyClass;
            return this;
        }

        public final void setAnomalyClass(String anomalyClass) {
            this.anomalyClass = anomalyClass;
        }

        public final Instant getBeforeCreationDate() {
            return beforeCreationDate;
        }

        @Override
        public final Builder beforeCreationDate(Instant beforeCreationDate) {
            this.beforeCreationDate = beforeCreationDate;
            return this;
        }

        public final void setBeforeCreationDate(Instant beforeCreationDate) {
            this.beforeCreationDate = beforeCreationDate;
        }

        public final Instant getAfterCreationDate() {
            return afterCreationDate;
        }

        @Override
        public final Builder afterCreationDate(Instant afterCreationDate) {
            this.afterCreationDate = afterCreationDate;
            return this;
        }

        public final void setAfterCreationDate(Instant afterCreationDate) {
            this.afterCreationDate = afterCreationDate;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getSourceRefContains() {
            return sourceRefContains;
        }

        @Override
        public final Builder sourceRefContains(String sourceRefContains) {
            this.sourceRefContains = sourceRefContains;
            return this;
        }

        public final void setSourceRefContains(String sourceRefContains) {
            this.sourceRefContains = sourceRefContains;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDatasetEntriesRequest build() {
            return new ListDatasetEntriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
