/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatasetEntriesResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<ListDatasetEntriesResponse.Builder, ListDatasetEntriesResponse> {
    private static final SdkField<List<String>> DATASET_ENTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DatasetEntries")
            .getter(getter(ListDatasetEntriesResponse::datasetEntries))
            .setter(setter(Builder::datasetEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDatasetEntriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ENTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> datasetEntries;

    private final String nextToken;

    private ListDatasetEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.datasetEntries = builder.datasetEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DatasetEntries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDatasetEntries() {
        return datasetEntries != null && !(datasetEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the entries (JSON Lines) within the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDatasetEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the entries (JSON Lines) within the dataset.
     */
    public List<String> datasetEntries() {
        return datasetEntries;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent
     * request to retrieve the next set ofdataset entries.
     * </p>
     * 
     * @return If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the
     *         subsequent request to retrieve the next set ofdataset entries.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetEntries() ? datasetEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetEntriesResponse)) {
            return false;
        }
        ListDatasetEntriesResponse other = (ListDatasetEntriesResponse) obj;
        return hasDatasetEntries() == other.hasDatasetEntries() && Objects.equals(datasetEntries(), other.datasetEntries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDatasetEntriesResponse")
                .add("DatasetEntries", hasDatasetEntries() ? datasetEntries() : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetEntries":
            return Optional.ofNullable(clazz.cast(datasetEntries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetEntriesResponse, T> g) {
        return obj -> g.apply((ListDatasetEntriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDatasetEntriesResponse> {
        /**
         * <p>
         * A list of the entries (JSON Lines) within the dataset.
         * </p>
         * 
         * @param datasetEntries
         *        A list of the entries (JSON Lines) within the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetEntries(Collection<String> datasetEntries);

        /**
         * <p>
         * A list of the entries (JSON Lines) within the dataset.
         * </p>
         * 
         * @param datasetEntries
         *        A list of the entries (JSON Lines) within the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetEntries(String... datasetEntries);

        /**
         * <p>
         * If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent
         * request to retrieve the next set ofdataset entries.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the
         *        subsequent request to retrieve the next set ofdataset entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private List<String> datasetEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetEntriesResponse model) {
            super(model);
            datasetEntries(model.datasetEntries);
            nextToken(model.nextToken);
        }

        public final Collection<String> getDatasetEntries() {
            if (datasetEntries instanceof SdkAutoConstructList) {
                return null;
            }
            return datasetEntries;
        }

        @Override
        public final Builder datasetEntries(Collection<String> datasetEntries) {
            this.datasetEntries = DatasetEntryListCopier.copy(datasetEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetEntries(String... datasetEntries) {
            datasetEntries(Arrays.asList(datasetEntries));
            return this;
        }

        public final void setDatasetEntries(Collection<String> datasetEntries) {
            this.datasetEntries = DatasetEntryListCopier.copy(datasetEntries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatasetEntriesResponse build() {
            return new ListDatasetEntriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
