/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.LookoutVisionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetEntriesRequest
extends LookoutVisionRequest
implements ToCopyableBuilder<Builder, ListDatasetEntriesRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::projectName)).setter(ListDatasetEntriesRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetType").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::datasetType)).setter(ListDatasetEntriesRequest.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetType").build()}).build();
    private static final SdkField<Boolean> LABELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Labeled").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::labeled)).setter(ListDatasetEntriesRequest.setter(Builder::labeled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("labeled").build()}).build();
    private static final SdkField<String> ANOMALY_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyClass").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::anomalyClass)).setter(ListDatasetEntriesRequest.setter(Builder::anomalyClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("anomalyClass").build()}).build();
    private static final SdkField<Instant> BEFORE_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BeforeCreationDate").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::beforeCreationDate)).setter(ListDatasetEntriesRequest.setter(Builder::beforeCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()}).build();
    private static final SdkField<Instant> AFTER_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AfterCreationDate").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::afterCreationDate)).setter(ListDatasetEntriesRequest.setter(Builder::afterCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::nextToken)).setter(ListDatasetEntriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::maxResults)).setter(ListDatasetEntriesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> SOURCE_REF_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRefContains").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::sourceRefContains)).setter(ListDatasetEntriesRequest.setter(Builder::sourceRefContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sourceRefContains").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, DATASET_TYPE_FIELD, LABELED_FIELD, ANOMALY_CLASS_FIELD, BEFORE_CREATION_DATE_FIELD, AFTER_CREATION_DATE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SOURCE_REF_CONTAINS_FIELD));
    private final String projectName;
    private final String datasetType;
    private final Boolean labeled;
    private final String anomalyClass;
    private final Instant beforeCreationDate;
    private final Instant afterCreationDate;
    private final String nextToken;
    private final Integer maxResults;
    private final String sourceRefContains;

    private ListDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.datasetType = builder.datasetType;
        this.labeled = builder.labeled;
        this.anomalyClass = builder.anomalyClass;
        this.beforeCreationDate = builder.beforeCreationDate;
        this.afterCreationDate = builder.afterCreationDate;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sourceRefContains = builder.sourceRefContains;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String datasetType() {
        return this.datasetType;
    }

    public final Boolean labeled() {
        return this.labeled;
    }

    public final String anomalyClass() {
        return this.anomalyClass;
    }

    public final Instant beforeCreationDate() {
        return this.beforeCreationDate;
    }

    public final Instant afterCreationDate() {
        return this.afterCreationDate;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String sourceRefContains() {
        return this.sourceRefContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.labeled());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRefContains());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetEntriesRequest)) {
            return false;
        }
        ListDatasetEntriesRequest other = (ListDatasetEntriesRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.datasetType(), other.datasetType()) && Objects.equals(this.labeled(), other.labeled()) && Objects.equals(this.anomalyClass(), other.anomalyClass()) && Objects.equals(this.beforeCreationDate(), other.beforeCreationDate()) && Objects.equals(this.afterCreationDate(), other.afterCreationDate()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sourceRefContains(), other.sourceRefContains());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetEntriesRequest").add("ProjectName", (Object)this.projectName()).add("DatasetType", (Object)this.datasetType()).add("Labeled", (Object)this.labeled()).add("AnomalyClass", (Object)this.anomalyClass()).add("BeforeCreationDate", (Object)this.beforeCreationDate()).add("AfterCreationDate", (Object)this.afterCreationDate()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SourceRefContains", (Object)this.sourceRefContains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetType()));
            }
            case "Labeled": {
                return Optional.ofNullable(clazz.cast(this.labeled()));
            }
            case "AnomalyClass": {
                return Optional.ofNullable(clazz.cast(this.anomalyClass()));
            }
            case "BeforeCreationDate": {
                return Optional.ofNullable(clazz.cast(this.beforeCreationDate()));
            }
            case "AfterCreationDate": {
                return Optional.ofNullable(clazz.cast(this.afterCreationDate()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "SourceRefContains": {
                return Optional.ofNullable(clazz.cast(this.sourceRefContains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetEntriesRequest, T> g) {
        return obj -> g.apply((ListDatasetEntriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutVisionRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private String datasetType;
        private Boolean labeled;
        private String anomalyClass;
        private Instant beforeCreationDate;
        private Instant afterCreationDate;
        private String nextToken;
        private Integer maxResults;
        private String sourceRefContains;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetEntriesRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.datasetType(model.datasetType);
            this.labeled(model.labeled);
            this.anomalyClass(model.anomalyClass);
            this.beforeCreationDate(model.beforeCreationDate);
            this.afterCreationDate(model.afterCreationDate);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sourceRefContains(model.sourceRefContains);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        public final Boolean getLabeled() {
            return this.labeled;
        }

        @Override
        public final Builder labeled(Boolean labeled) {
            this.labeled = labeled;
            return this;
        }

        public final void setLabeled(Boolean labeled) {
            this.labeled = labeled;
        }

        public final String getAnomalyClass() {
            return this.anomalyClass;
        }

        @Override
        public final Builder anomalyClass(String anomalyClass) {
            this.anomalyClass = anomalyClass;
            return this;
        }

        public final void setAnomalyClass(String anomalyClass) {
            this.anomalyClass = anomalyClass;
        }

        public final Instant getBeforeCreationDate() {
            return this.beforeCreationDate;
        }

        @Override
        public final Builder beforeCreationDate(Instant beforeCreationDate) {
            this.beforeCreationDate = beforeCreationDate;
            return this;
        }

        public final void setBeforeCreationDate(Instant beforeCreationDate) {
            this.beforeCreationDate = beforeCreationDate;
        }

        public final Instant getAfterCreationDate() {
            return this.afterCreationDate;
        }

        @Override
        public final Builder afterCreationDate(Instant afterCreationDate) {
            this.afterCreationDate = afterCreationDate;
            return this;
        }

        public final void setAfterCreationDate(Instant afterCreationDate) {
            this.afterCreationDate = afterCreationDate;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getSourceRefContains() {
            return this.sourceRefContains;
        }

        @Override
        public final Builder sourceRefContains(String sourceRefContains) {
            this.sourceRefContains = sourceRefContains;
            return this;
        }

        public final void setSourceRefContains(String sourceRefContains) {
            this.sourceRefContains = sourceRefContains;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDatasetEntriesRequest build() {
            return new ListDatasetEntriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutVisionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetEntriesRequest> {
        public Builder projectName(String var1);

        public Builder datasetType(String var1);

        public Builder labeled(Boolean var1);

        public Builder anomalyClass(String var1);

        public Builder beforeCreationDate(Instant var1);

        public Builder afterCreationDate(Instant var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sourceRefContains(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

