/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<CreateProjectResponse.Builder, CreateProjectResponse> {
    private static final SdkField<ProjectMetadata> PROJECT_METADATA_FIELD = SdkField
            .<ProjectMetadata> builder(MarshallingType.SDK_POJO).memberName("ProjectMetadata")
            .getter(getter(CreateProjectResponse::projectMetadata)).setter(setter(Builder::projectMetadata))
            .constructor(ProjectMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_METADATA_FIELD));

    private final ProjectMetadata projectMetadata;

    private CreateProjectResponse(BuilderImpl builder) {
        super(builder);
        this.projectMetadata = builder.projectMetadata;
    }

    /**
     * <p>
     * Information about the project.
     * </p>
     * 
     * @return Information about the project.
     */
    public final ProjectMetadata projectMetadata() {
        return projectMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectResponse)) {
            return false;
        }
        CreateProjectResponse other = (CreateProjectResponse) obj;
        return Objects.equals(projectMetadata(), other.projectMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProjectResponse").add("ProjectMetadata", projectMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectMetadata":
            return Optional.ofNullable(clazz.cast(projectMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectResponse, T> g) {
        return obj -> g.apply((CreateProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectResponse> {
        /**
         * <p>
         * Information about the project.
         * </p>
         * 
         * @param projectMetadata
         *        Information about the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectMetadata(ProjectMetadata projectMetadata);

        /**
         * <p>
         * Information about the project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectMetadata.Builder} avoiding the need to
         * create one manually via {@link ProjectMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #projectMetadata(ProjectMetadata)}.
         * 
         * @param projectMetadata
         *        a consumer that will call methods on {@link ProjectMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectMetadata(ProjectMetadata)
         */
        default Builder projectMetadata(Consumer<ProjectMetadata.Builder> projectMetadata) {
            return projectMetadata(ProjectMetadata.builder().applyMutation(projectMetadata).build());
        }
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private ProjectMetadata projectMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectResponse model) {
            super(model);
            projectMetadata(model.projectMetadata);
        }

        public final ProjectMetadata.Builder getProjectMetadata() {
            return projectMetadata != null ? projectMetadata.toBuilder() : null;
        }

        @Override
        public final Builder projectMetadata(ProjectMetadata projectMetadata) {
            this.projectMetadata = projectMetadata;
            return this;
        }

        public final void setProjectMetadata(ProjectMetadata.BuilderImpl projectMetadata) {
            this.projectMetadata = projectMetadata != null ? projectMetadata.build() : null;
        }

        @Override
        public CreateProjectResponse build() {
            return new CreateProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
