/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator;
import software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch;
import software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetPlatform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetPlatform> {
    private static final SdkField<String> OS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Os").getter(TargetPlatform.getter(TargetPlatform::osAsString)).setter(TargetPlatform.setter(Builder::os)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Os").build()}).build();
    private static final SdkField<String> ARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arch").getter(TargetPlatform.getter(TargetPlatform::archAsString)).setter(TargetPlatform.setter(Builder::arch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arch").build()}).build();
    private static final SdkField<String> ACCELERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Accelerator").getter(TargetPlatform.getter(TargetPlatform::acceleratorAsString)).setter(TargetPlatform.setter(Builder::accelerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OS_FIELD, ARCH_FIELD, ACCELERATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String os;
    private final String arch;
    private final String accelerator;

    private TargetPlatform(BuilderImpl builder) {
        this.os = builder.os;
        this.arch = builder.arch;
        this.accelerator = builder.accelerator;
    }

    public final TargetPlatformOs os() {
        return TargetPlatformOs.fromValue(this.os);
    }

    public final String osAsString() {
        return this.os;
    }

    public final TargetPlatformArch arch() {
        return TargetPlatformArch.fromValue(this.arch);
    }

    public final String archAsString() {
        return this.arch;
    }

    public final TargetPlatformAccelerator accelerator() {
        return TargetPlatformAccelerator.fromValue(this.accelerator);
    }

    public final String acceleratorAsString() {
        return this.accelerator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.osAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.archAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetPlatform)) {
            return false;
        }
        TargetPlatform other = (TargetPlatform)obj;
        return Objects.equals(this.osAsString(), other.osAsString()) && Objects.equals(this.archAsString(), other.archAsString()) && Objects.equals(this.acceleratorAsString(), other.acceleratorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TargetPlatform").add("Os", (Object)this.osAsString()).add("Arch", (Object)this.archAsString()).add("Accelerator", (Object)this.acceleratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Os": {
                return Optional.ofNullable(clazz.cast(this.osAsString()));
            }
            case "Arch": {
                return Optional.ofNullable(clazz.cast(this.archAsString()));
            }
            case "Accelerator": {
                return Optional.ofNullable(clazz.cast(this.acceleratorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetPlatform, T> g) {
        return obj -> g.apply((TargetPlatform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String os;
        private String arch;
        private String accelerator;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetPlatform model) {
            this.os(model.os);
            this.arch(model.arch);
            this.accelerator(model.accelerator);
        }

        public final String getOs() {
            return this.os;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        @Override
        @Transient
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        @Override
        @Transient
        public final Builder os(TargetPlatformOs os) {
            this.os(os == null ? null : os.toString());
            return this;
        }

        public final String getArch() {
            return this.arch;
        }

        public final void setArch(String arch) {
            this.arch = arch;
        }

        @Override
        @Transient
        public final Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        @Override
        @Transient
        public final Builder arch(TargetPlatformArch arch) {
            this.arch(arch == null ? null : arch.toString());
            return this;
        }

        public final String getAccelerator() {
            return this.accelerator;
        }

        public final void setAccelerator(String accelerator) {
            this.accelerator = accelerator;
        }

        @Override
        @Transient
        public final Builder accelerator(String accelerator) {
            this.accelerator = accelerator;
            return this;
        }

        @Override
        @Transient
        public final Builder accelerator(TargetPlatformAccelerator accelerator) {
            this.accelerator(accelerator == null ? null : accelerator.toString());
            return this;
        }

        public TargetPlatform build() {
            return new TargetPlatform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetPlatform> {
        public Builder os(String var1);

        public Builder os(TargetPlatformOs var1);

        public Builder arch(String var1);

        public Builder arch(TargetPlatformArch var1);

        public Builder accelerator(String var1);

        public Builder accelerator(TargetPlatformAccelerator var1);
    }
}

