/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<CreateDatasetResponse.Builder, CreateDatasetResponse> {
    private static final SdkField<DatasetMetadata> DATASET_METADATA_FIELD = SdkField
            .<DatasetMetadata> builder(MarshallingType.SDK_POJO).memberName("DatasetMetadata")
            .getter(getter(CreateDatasetResponse::datasetMetadata)).setter(setter(Builder::datasetMetadata))
            .constructor(DatasetMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_METADATA_FIELD));

    private final DatasetMetadata datasetMetadata;

    private CreateDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetMetadata = builder.datasetMetadata;
    }

    /**
     * <p>
     * Information about the dataset.
     * </p>
     * 
     * @return Information about the dataset.
     */
    public final DatasetMetadata datasetMetadata() {
        return datasetMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetResponse)) {
            return false;
        }
        CreateDatasetResponse other = (CreateDatasetResponse) obj;
        return Objects.equals(datasetMetadata(), other.datasetMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetResponse").add("DatasetMetadata", datasetMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetMetadata":
            return Optional.ofNullable(clazz.cast(datasetMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetResponse, T> g) {
        return obj -> g.apply((CreateDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetResponse> {
        /**
         * <p>
         * Information about the dataset.
         * </p>
         * 
         * @param datasetMetadata
         *        Information about the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetMetadata(DatasetMetadata datasetMetadata);

        /**
         * <p>
         * Information about the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetMetadata.Builder} avoiding the
         * need to create one manually via {@link DatasetMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetMetadata(DatasetMetadata)}.
         * 
         * @param datasetMetadata
         *        a consumer that will call methods on {@link DatasetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetMetadata(DatasetMetadata)
         */
        default Builder datasetMetadata(Consumer<DatasetMetadata.Builder> datasetMetadata) {
            return datasetMetadata(DatasetMetadata.builder().applyMutation(datasetMetadata).build());
        }
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private DatasetMetadata datasetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetResponse model) {
            super(model);
            datasetMetadata(model.datasetMetadata);
        }

        public final DatasetMetadata.Builder getDatasetMetadata() {
            return datasetMetadata != null ? datasetMetadata.toBuilder() : null;
        }

        public final void setDatasetMetadata(DatasetMetadata.BuilderImpl datasetMetadata) {
            this.datasetMetadata = datasetMetadata != null ? datasetMetadata.build() : null;
        }

        @Override
        public final Builder datasetMetadata(DatasetMetadata datasetMetadata) {
            this.datasetMetadata = datasetMetadata;
            return this;
        }

        @Override
        public CreateDatasetResponse build() {
            return new CreateDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
