/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<CreateModelResponse.Builder, CreateModelResponse> {
    private static final SdkField<ModelMetadata> MODEL_METADATA_FIELD = SdkField
            .<ModelMetadata> builder(MarshallingType.SDK_POJO).memberName("ModelMetadata")
            .getter(getter(CreateModelResponse::modelMetadata)).setter(setter(Builder::modelMetadata))
            .constructor(ModelMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_METADATA_FIELD));

    private final ModelMetadata modelMetadata;

    private CreateModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelMetadata = builder.modelMetadata;
    }

    /**
     * <p>
     * The response from a call to <code>CreateModel</code>.
     * </p>
     * 
     * @return The response from a call to <code>CreateModel</code>.
     */
    public final ModelMetadata modelMetadata() {
        return modelMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelResponse)) {
            return false;
        }
        CreateModelResponse other = (CreateModelResponse) obj;
        return Objects.equals(modelMetadata(), other.modelMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelResponse").add("ModelMetadata", modelMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelMetadata":
            return Optional.ofNullable(clazz.cast(modelMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelResponse, T> g) {
        return obj -> g.apply((CreateModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelResponse> {
        /**
         * <p>
         * The response from a call to <code>CreateModel</code>.
         * </p>
         * 
         * @param modelMetadata
         *        The response from a call to <code>CreateModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelMetadata(ModelMetadata modelMetadata);

        /**
         * <p>
         * The response from a call to <code>CreateModel</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelMetadata.Builder} avoiding the need
         * to create one manually via {@link ModelMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #modelMetadata(ModelMetadata)}.
         * 
         * @param modelMetadata
         *        a consumer that will call methods on {@link ModelMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelMetadata(ModelMetadata)
         */
        default Builder modelMetadata(Consumer<ModelMetadata.Builder> modelMetadata) {
            return modelMetadata(ModelMetadata.builder().applyMutation(modelMetadata).build());
        }
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private ModelMetadata modelMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelResponse model) {
            super(model);
            modelMetadata(model.modelMetadata);
        }

        public final ModelMetadata.Builder getModelMetadata() {
            return modelMetadata != null ? modelMetadata.toBuilder() : null;
        }

        public final void setModelMetadata(ModelMetadata.BuilderImpl modelMetadata) {
            this.modelMetadata = modelMetadata != null ? modelMetadata.build() : null;
        }

        @Override
        public final Builder modelMetadata(ModelMetadata modelMetadata) {
            this.modelMetadata = modelMetadata;
            return this;
        }

        @Override
        public CreateModelResponse build() {
            return new CreateModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
