/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectAnomaliesResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<DetectAnomaliesResponse.Builder, DetectAnomaliesResponse> {
    private static final SdkField<DetectAnomalyResult> DETECT_ANOMALY_RESULT_FIELD = SdkField
            .<DetectAnomalyResult> builder(MarshallingType.SDK_POJO).memberName("DetectAnomalyResult")
            .getter(getter(DetectAnomaliesResponse::detectAnomalyResult)).setter(setter(Builder::detectAnomalyResult))
            .constructor(DetectAnomalyResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectAnomalyResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECT_ANOMALY_RESULT_FIELD));

    private final DetectAnomalyResult detectAnomalyResult;

    private DetectAnomaliesResponse(BuilderImpl builder) {
        super(builder);
        this.detectAnomalyResult = builder.detectAnomalyResult;
    }

    /**
     * <p>
     * The results of the <code>DetectAnomalies</code> operation.
     * </p>
     * 
     * @return The results of the <code>DetectAnomalies</code> operation.
     */
    public final DetectAnomalyResult detectAnomalyResult() {
        return detectAnomalyResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectAnomalyResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectAnomaliesResponse)) {
            return false;
        }
        DetectAnomaliesResponse other = (DetectAnomaliesResponse) obj;
        return Objects.equals(detectAnomalyResult(), other.detectAnomalyResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectAnomaliesResponse").add("DetectAnomalyResult", detectAnomalyResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectAnomalyResult":
            return Optional.ofNullable(clazz.cast(detectAnomalyResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectAnomaliesResponse, T> g) {
        return obj -> g.apply((DetectAnomaliesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectAnomaliesResponse> {
        /**
         * <p>
         * The results of the <code>DetectAnomalies</code> operation.
         * </p>
         * 
         * @param detectAnomalyResult
         *        The results of the <code>DetectAnomalies</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectAnomalyResult(DetectAnomalyResult detectAnomalyResult);

        /**
         * <p>
         * The results of the <code>DetectAnomalies</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectAnomalyResult.Builder} avoiding the
         * need to create one manually via {@link DetectAnomalyResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectAnomalyResult.Builder#build()} is called immediately and
         * its result is passed to {@link #detectAnomalyResult(DetectAnomalyResult)}.
         * 
         * @param detectAnomalyResult
         *        a consumer that will call methods on {@link DetectAnomalyResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectAnomalyResult(DetectAnomalyResult)
         */
        default Builder detectAnomalyResult(Consumer<DetectAnomalyResult.Builder> detectAnomalyResult) {
            return detectAnomalyResult(DetectAnomalyResult.builder().applyMutation(detectAnomalyResult).build());
        }
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private DetectAnomalyResult detectAnomalyResult;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectAnomaliesResponse model) {
            super(model);
            detectAnomalyResult(model.detectAnomalyResult);
        }

        public final DetectAnomalyResult.Builder getDetectAnomalyResult() {
            return detectAnomalyResult != null ? detectAnomalyResult.toBuilder() : null;
        }

        public final void setDetectAnomalyResult(DetectAnomalyResult.BuilderImpl detectAnomalyResult) {
            this.detectAnomalyResult = detectAnomalyResult != null ? detectAnomalyResult.build() : null;
        }

        @Override
        public final Builder detectAnomalyResult(DetectAnomalyResult detectAnomalyResult) {
            this.detectAnomalyResult = detectAnomalyResult;
            return this;
        }

        @Override
        public DetectAnomaliesResponse build() {
            return new DetectAnomaliesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
