/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lookoutvision.model.AccessDeniedException;
import software.amazon.awssdk.services.lookoutvision.model.ConflictException;
import software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.CreateProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest;
import software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesResponse;
import software.amazon.awssdk.services.lookoutvision.model.InternalServerException;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.LookoutVisionException;
import software.amazon.awssdk.services.lookoutvision.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lookoutvision.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest;
import software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobResponse;
import software.amazon.awssdk.services.lookoutvision.model.StartModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.StartModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.StopModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.StopModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.ThrottlingException;
import software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest;
import software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesResponse;
import software.amazon.awssdk.services.lookoutvision.model.ValidationException;
import software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesIterable;
import software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsIterable;
import software.amazon.awssdk.services.lookoutvision.paginators.ListModelsIterable;
import software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsIterable;

/**
 * Service client for accessing Amazon Lookout for Vision. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This is the Amazon Lookout for Vision API Reference. It provides descriptions of actions, data types, common
 * parameters, and common errors.
 * </p>
 * <p>
 * Amazon Lookout for Vision enables you to find visual defects in industrial products, accurately and at scale. It uses
 * computer vision to identify missing components in an industrial product, damage to vehicles or structures,
 * irregularities in production lines, and even minuscule defects in silicon wafers — or any other physical item where
 * quality is important such as a missing capacitor on printed circuit boards.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LookoutVisionClient extends SdkClient {
    String SERVICE_NAME = "lookoutvision";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "lookoutvision";

    /**
     * Create a {@link LookoutVisionClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LookoutVisionClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LookoutVisionClient}.
     */
    static LookoutVisionClientBuilder builder() {
        return new DefaultLookoutVisionClientBuilder();
    }

    /**
     * <p>
     * Creates a new dataset in an Amazon Lookout for Vision project. <code>CreateDataset</code> can create a training
     * or a test dataset from a valid dataset source (<code>DatasetSource</code>).
     * </p>
     * <p>
     * If you want a single dataset project, specify <code>train</code> for the value of <code>DatasetType</code>.
     * </p>
     * <p>
     * To have a project with separate training and test datasets, call <code>CreateDataset</code> twice. On the first
     * call, specify <code>train</code> for the value of <code>DatasetType</code>. On the second call, specify
     * <code>test</code> for the value of <code>DatasetType</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:CreateDataset</code> operation.
     * </p>
     *
     * @param createDatasetRequest
     * @return Result of the CreateDataset operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new dataset in an Amazon Lookout for Vision project. <code>CreateDataset</code> can create a training
     * or a test dataset from a valid dataset source (<code>DatasetSource</code>).
     * </p>
     * <p>
     * If you want a single dataset project, specify <code>train</code> for the value of <code>DatasetType</code>.
     * </p>
     * <p>
     * To have a project with separate training and test datasets, call <code>CreateDataset</code> twice. On the first
     * call, specify <code>train</code> for the value of <code>DatasetType</code>. On the second call, specify
     * <code>test</code> for the value of <code>DatasetType</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:CreateDataset</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatasetRequest#builder()}
     * </p>
     *
     * @param createDatasetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetRequest.Builder} to create a request.
     * @return Result of the CreateDataset operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDatasetResponse createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        return createDataset(CreateDatasetRequest.builder().applyMutation(createDatasetRequest).build());
    }

    /**
     * <p>
     * Creates a new version of a model within an an Amazon Lookout for Vision project. <code>CreateModel</code> is an
     * asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model.
     * </p>
     * <p>
     * To get the current status, check the <code>Status</code> field returned in the response from
     * <a>DescribeModel</a>.
     * </p>
     * <p>
     * If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training
     * and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective
     * datasets to train and test the model.
     * </p>
     * <p>
     * After training completes, the evaluation metrics are stored at the location specified in
     * <code>OutputConfig</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:CreateModel</code> operation. If you want
     * to tag your model, you also require permission to the <code>lookoutvision:TagResource</code> operation.
     * </p>
     *
     * @param createModelRequest
     * @return Result of the CreateModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelResponse createModel(CreateModelRequest createModelRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of a model within an an Amazon Lookout for Vision project. <code>CreateModel</code> is an
     * asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model.
     * </p>
     * <p>
     * To get the current status, check the <code>Status</code> field returned in the response from
     * <a>DescribeModel</a>.
     * </p>
     * <p>
     * If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training
     * and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective
     * datasets to train and test the model.
     * </p>
     * <p>
     * After training completes, the evaluation metrics are stored at the location specified in
     * <code>OutputConfig</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:CreateModel</code> operation. If you want
     * to tag your model, you also require permission to the <code>lookoutvision:TagResource</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelRequest.Builder} to create a request.
     * @return Result of the CreateModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelResponse createModel(Consumer<CreateModelRequest.Builder> createModelRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling
     * <a>CreateDataset</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:CreateProject</code> operation.
     * </p>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling
     * <a>CreateDataset</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:CreateProject</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectRequest.Builder} to create a request.
     * @return Result of the CreateProject operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Lookout for Vision <code>dataset</code>.
     * </p>
     * <p>
     * If your the project has a single dataset, you must create a new dataset before you can create a model.
     * </p>
     * <p>
     * If you project has a training dataset and a test dataset consider the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you delete the test dataset, your project reverts to a single dataset project. If you then train the model,
     * Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you delete the training dataset, you must create a training dataset before you can create a model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DeleteDataset</code> operation.
     * </p>
     *
     * @param deleteDatasetRequest
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Lookout for Vision <code>dataset</code>.
     * </p>
     * <p>
     * If your the project has a single dataset, you must create a new dataset before you can create a model.
     * </p>
     * <p>
     * If you project has a training dataset and a test dataset consider the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you delete the test dataset, your project reverts to a single dataset project. If you then train the model,
     * Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you delete the training dataset, you must create a training dataset before you can create a model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DeleteDataset</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatasetRequest.Builder} to create a request.
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return deleteDataset(DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the
     * <a>StopModel</a> operation.
     * </p>
     * <p>
     * It might take a few seconds to delete a model. To determine if a model has been deleted, call <a>ListModels</a>
     * and check if the version of the model (<code>ModelVersion</code>) is in the <code>Models</code> array.
     * </p>
     * <p/>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DeleteModel</code> operation.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the
     * <a>StopModel</a> operation.
     * </p>
     * <p>
     * It might take a few seconds to delete a model. To determine if a model has been deleted, call <a>ListModels</a>
     * and check if the version of the model (<code>ModelVersion</code>) is in the <code>Models</code> array.
     * </p>
     * <p/>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DeleteModel</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelRequest.Builder} to create a request.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelResponse deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * To delete a project, you must first delete each version of the model associated with the project. To delete a
     * model use the <a>DeleteModel</a> operation.
     * </p>
     * <p>
     * You also have to delete the dataset(s) associated with the model. For more information, see <a>DeleteDataset</a>.
     * The images referenced by the training and test datasets aren't deleted.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DeleteProject</code> operation.
     * </p>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteProject" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * To delete a project, you must first delete each version of the model associated with the project. To delete a
     * model use the <a>DeleteModel</a> operation.
     * </p>
     * <p>
     * You also have to delete the dataset(s) associated with the model. For more information, see <a>DeleteDataset</a>.
     * The images referenced by the training and test datasets aren't deleted.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DeleteProject</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectRequest.Builder} to create a request.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteProject" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Describe an Amazon Lookout for Vision dataset.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DescribeDataset</code> operation.
     * </p>
     *
     * @param describeDatasetRequest
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an Amazon Lookout for Vision dataset.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DescribeDataset</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetRequest.Builder} to create a request.
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Describes a version of an Amazon Lookout for Vision model.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DescribeModel</code> operation.
     * </p>
     *
     * @param describeModelRequest
     * @return Result of the DescribeModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeModel" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeModelResponse describeModel(DescribeModelRequest describeModelRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a version of an Amazon Lookout for Vision model.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DescribeModel</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeModelRequest#builder()}
     * </p>
     *
     * @param describeModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelRequest.Builder} to create a request.
     * @return Result of the DescribeModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeModel" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeModelResponse describeModel(Consumer<DescribeModelRequest.Builder> describeModelRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return describeModel(DescribeModelRequest.builder().applyMutation(describeModelRequest).build());
    }

    /**
     * <p>
     * Describes an Amazon Lookout for Vision model packaging job.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DescribeModelPackagingJob</code>
     * operation.
     * </p>
     * <p>
     * For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon
     * Lookout for Vision Developer Guide.
     * </p>
     *
     * @param describeModelPackagingJobRequest
     * @return Result of the DescribeModelPackagingJob operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DescribeModelPackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeModelPackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelPackagingJobResponse describeModelPackagingJob(
            DescribeModelPackagingJobRequest describeModelPackagingJobRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Amazon Lookout for Vision model packaging job.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DescribeModelPackagingJob</code>
     * operation.
     * </p>
     * <p>
     * For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon
     * Lookout for Vision Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelPackagingJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeModelPackagingJobRequest#builder()}
     * </p>
     *
     * @param describeModelPackagingJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelPackagingJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeModelPackagingJob operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DescribeModelPackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeModelPackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelPackagingJobResponse describeModelPackagingJob(
            Consumer<DescribeModelPackagingJobRequest.Builder> describeModelPackagingJobRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        return describeModelPackagingJob(DescribeModelPackagingJobRequest.builder()
                .applyMutation(describeModelPackagingJobRequest).build());
    }

    /**
     * <p>
     * Describes an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DescribeProject</code> operation.
     * </p>
     *
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DescribeProject</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProjectRequest.Builder} to create a request.
     * @return Result of the DescribeProject operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProjectResponse describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Detects anomalies in an image that you supply.
     * </p>
     * <p>
     * The response from <code>DetectAnomalies</code> includes a boolean prediction that the image contains one or more
     * anomalies and a confidence value for the prediction. If the model is an image segmentation model, the response
     * also includes segmentation information for each type of anomaly found in the image.
     * </p>
     * <note>
     * <p>
     * Before calling <code>DetectAnomalies</code>, you must first start your model with the <a>StartModel</a>
     * operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly
     * detection units that your model uses. If you are not using a model, use the <a>StopModel</a> operation to stop
     * your model.
     * </p>
     * </note>
     * <p>
     * For more information, see <i>Detecting anomalies in an image</i> in the Amazon Lookout for Vision developer
     * guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DetectAnomalies</code> operation.
     * </p>
     *
     * @param detectAnomaliesRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows '
     *        <p>
     *        The unencrypted image bytes that you want to analyze.
     *        </p>
     *        '
     * @return Result of the DetectAnomalies operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DetectAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DetectAnomalies" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectAnomaliesResponse detectAnomalies(DetectAnomaliesRequest detectAnomaliesRequest, RequestBody requestBody)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects anomalies in an image that you supply.
     * </p>
     * <p>
     * The response from <code>DetectAnomalies</code> includes a boolean prediction that the image contains one or more
     * anomalies and a confidence value for the prediction. If the model is an image segmentation model, the response
     * also includes segmentation information for each type of anomaly found in the image.
     * </p>
     * <note>
     * <p>
     * Before calling <code>DetectAnomalies</code>, you must first start your model with the <a>StartModel</a>
     * operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly
     * detection units that your model uses. If you are not using a model, use the <a>StopModel</a> operation to stop
     * your model.
     * </p>
     * </note>
     * <p>
     * For more information, see <i>Detecting anomalies in an image</i> in the Amazon Lookout for Vision developer
     * guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DetectAnomalies</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectAnomaliesRequest.Builder} avoiding the need
     * to create one manually via {@link DetectAnomaliesRequest#builder()}
     * </p>
     *
     * @param detectAnomaliesRequest
     *        A {@link Consumer} that will call methods on {@link DetectAnomaliesRequest.Builder} to create a request.
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows '
     *        <p>
     *        The unencrypted image bytes that you want to analyze.
     *        </p>
     *        '
     * @return Result of the DetectAnomalies operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DetectAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DetectAnomalies" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectAnomaliesResponse detectAnomalies(Consumer<DetectAnomaliesRequest.Builder> detectAnomaliesRequest,
            RequestBody requestBody) throws AccessDeniedException, InternalServerException, ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            LookoutVisionException {
        return detectAnomalies(DetectAnomaliesRequest.builder().applyMutation(detectAnomaliesRequest).build(), requestBody);
    }

    /**
     * <p>
     * Detects anomalies in an image that you supply.
     * </p>
     * <p>
     * The response from <code>DetectAnomalies</code> includes a boolean prediction that the image contains one or more
     * anomalies and a confidence value for the prediction. If the model is an image segmentation model, the response
     * also includes segmentation information for each type of anomaly found in the image.
     * </p>
     * <note>
     * <p>
     * Before calling <code>DetectAnomalies</code>, you must first start your model with the <a>StartModel</a>
     * operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly
     * detection units that your model uses. If you are not using a model, use the <a>StopModel</a> operation to stop
     * your model.
     * </p>
     * </note>
     * <p>
     * For more information, see <i>Detecting anomalies in an image</i> in the Amazon Lookout for Vision developer
     * guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DetectAnomalies</code> operation.
     * </p>
     *
     * @param detectAnomaliesRequest
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        The unencrypted image bytes that you want to analyze.
     *        </p>
     *        '
     * @return Result of the DetectAnomalies operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DetectAnomalies
     * @see #detectAnomalies(DetectAnomaliesRequest, RequestBody)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DetectAnomalies" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectAnomaliesResponse detectAnomalies(DetectAnomaliesRequest detectAnomaliesRequest, Path sourcePath)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return detectAnomalies(detectAnomaliesRequest, RequestBody.fromFile(sourcePath));
    }

    /**
     * <p>
     * Detects anomalies in an image that you supply.
     * </p>
     * <p>
     * The response from <code>DetectAnomalies</code> includes a boolean prediction that the image contains one or more
     * anomalies and a confidence value for the prediction. If the model is an image segmentation model, the response
     * also includes segmentation information for each type of anomaly found in the image.
     * </p>
     * <note>
     * <p>
     * Before calling <code>DetectAnomalies</code>, you must first start your model with the <a>StartModel</a>
     * operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly
     * detection units that your model uses. If you are not using a model, use the <a>StopModel</a> operation to stop
     * your model.
     * </p>
     * </note>
     * <p>
     * For more information, see <i>Detecting anomalies in an image</i> in the Amazon Lookout for Vision developer
     * guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:DetectAnomalies</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectAnomaliesRequest.Builder} avoiding the need
     * to create one manually via {@link DetectAnomaliesRequest#builder()}
     * </p>
     *
     * @param detectAnomaliesRequest
     *        A {@link Consumer} that will call methods on {@link DetectAnomaliesRequest.Builder} to create a request.
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        The unencrypted image bytes that you want to analyze.
     *        </p>
     *        '
     * @return Result of the DetectAnomalies operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.DetectAnomalies
     * @see #detectAnomalies(DetectAnomaliesRequest, RequestBody)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DetectAnomalies" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectAnomaliesResponse detectAnomalies(Consumer<DetectAnomaliesRequest.Builder> detectAnomaliesRequest,
            Path sourcePath) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return detectAnomalies(DetectAnomaliesRequest.builder().applyMutation(detectAnomaliesRequest).build(), sourcePath);
    }

    /**
     * <p>
     * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information
     * for a single image, including the image location and the assigned label.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListDatasetEntries</code> operation.
     * </p>
     *
     * @param listDatasetEntriesRequest
     * @return Result of the ListDatasetEntries operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListDatasetEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListDatasetEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetEntriesResponse listDatasetEntries(ListDatasetEntriesRequest listDatasetEntriesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information
     * for a single image, including the image location and the assigned label.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListDatasetEntries</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetEntriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetEntriesRequest#builder()}
     * </p>
     *
     * @param listDatasetEntriesRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetEntriesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDatasetEntries operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListDatasetEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListDatasetEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetEntriesResponse listDatasetEntries(Consumer<ListDatasetEntriesRequest.Builder> listDatasetEntriesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return listDatasetEntries(ListDatasetEntriesRequest.builder().applyMutation(listDatasetEntriesRequest).build());
    }

    /**
     * <p>
     * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information
     * for a single image, including the image location and the assigned label.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListDatasetEntries</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetEntries(software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesIterable responses = client.listDatasetEntriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesIterable responses = client
     *             .listDatasetEntriesPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesIterable responses = client.listDatasetEntriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetEntries(software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatasetEntriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListDatasetEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListDatasetEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetEntriesIterable listDatasetEntriesPaginator(ListDatasetEntriesRequest listDatasetEntriesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information
     * for a single image, including the image location and the assigned label.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListDatasetEntries</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetEntries(software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesIterable responses = client.listDatasetEntriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesIterable responses = client
     *             .listDatasetEntriesPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesIterable responses = client.listDatasetEntriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetEntries(software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetEntriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetEntriesRequest#builder()}
     * </p>
     *
     * @param listDatasetEntriesRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetEntriesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListDatasetEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListDatasetEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetEntriesIterable listDatasetEntriesPaginator(
            Consumer<ListDatasetEntriesRequest.Builder> listDatasetEntriesRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        return listDatasetEntriesPaginator(ListDatasetEntriesRequest.builder().applyMutation(listDatasetEntriesRequest).build());
    }

    /**
     * <p>
     * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListModelPackagingJobs</code> operation.
     * </p>
     * <p>
     * For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon
     * Lookout for Vision Developer Guide.
     * </p>
     *
     * @param listModelPackagingJobsRequest
     * @return Result of the ListModelPackagingJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListModelPackagingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModelPackagingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelPackagingJobsResponse listModelPackagingJobs(ListModelPackagingJobsRequest listModelPackagingJobsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListModelPackagingJobs</code> operation.
     * </p>
     * <p>
     * For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon
     * Lookout for Vision Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelPackagingJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelPackagingJobsRequest#builder()}
     * </p>
     *
     * @param listModelPackagingJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelPackagingJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListModelPackagingJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListModelPackagingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModelPackagingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelPackagingJobsResponse listModelPackagingJobs(
            Consumer<ListModelPackagingJobsRequest.Builder> listModelPackagingJobsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        return listModelPackagingJobs(ListModelPackagingJobsRequest.builder().applyMutation(listModelPackagingJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListModelPackagingJobs</code> operation.
     * </p>
     * <p>
     * For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon
     * Lookout for Vision Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelPackagingJobs(software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsIterable responses = client.listModelPackagingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsIterable responses = client
     *             .listModelPackagingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsIterable responses = client.listModelPackagingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelPackagingJobs(software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelPackagingJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListModelPackagingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModelPackagingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelPackagingJobsIterable listModelPackagingJobsPaginator(
            ListModelPackagingJobsRequest listModelPackagingJobsRequest) throws AccessDeniedException, InternalServerException,
            ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListModelPackagingJobs</code> operation.
     * </p>
     * <p>
     * For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon
     * Lookout for Vision Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listModelPackagingJobs(software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsIterable responses = client.listModelPackagingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsIterable responses = client
     *             .listModelPackagingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsIterable responses = client.listModelPackagingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelPackagingJobs(software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelPackagingJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelPackagingJobsRequest#builder()}
     * </p>
     *
     * @param listModelPackagingJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelPackagingJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListModelPackagingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModelPackagingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelPackagingJobsIterable listModelPackagingJobsPaginator(
            Consumer<ListModelPackagingJobsRequest.Builder> listModelPackagingJobsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        return listModelPackagingJobsPaginator(ListModelPackagingJobsRequest.builder()
                .applyMutation(listModelPackagingJobsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of a model in an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * The <code>ListModels</code> operation is eventually consistent. Recent calls to <code>CreateModel</code> might
     * take a while to appear in the response from <code>ListProjects</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListModels</code> operation.
     * </p>
     *
     * @param listModelsRequest
     * @return Result of the ListModels operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsResponse listModels(ListModelsRequest listModelsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of a model in an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * The <code>ListModels</code> operation is eventually consistent. Recent calls to <code>CreateModel</code> might
     * take a while to appear in the response from <code>ListProjects</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListModels</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListModelsRequest#builder()}
     * </p>
     *
     * @param listModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelsRequest.Builder} to create a request.
     * @return Result of the ListModels operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsResponse listModels(Consumer<ListModelsRequest.Builder> listModelsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        return listModels(ListModelsRequest.builder().applyMutation(listModelsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of a model in an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * The <code>ListModels</code> operation is eventually consistent. Recent calls to <code>CreateModel</code> might
     * take a while to appear in the response from <code>ListProjects</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListModels</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listModels(software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutvision.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest)} operation.</b>
     * </p>
     *
     * @param listModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsIterable listModelsPaginator(ListModelsRequest listModelsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of a model in an Amazon Lookout for Vision project.
     * </p>
     * <p>
     * The <code>ListModels</code> operation is eventually consistent. Recent calls to <code>CreateModel</code> might
     * take a while to appear in the response from <code>ListProjects</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListModels</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listModels(software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutvision.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListModelsRequest#builder()}
     * </p>
     *
     * @param listModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsIterable listModelsPaginator(Consumer<ListModelsRequest.Builder> listModelsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return listModelsPaginator(ListModelsRequest.builder().applyMutation(listModelsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Lookout for Vision projects in your AWS account that are in the AWS Region in which you call
     * <code>ListProjects</code>.
     * </p>
     * <p>
     * The <code>ListProjects</code> operation is eventually consistent. Recent calls to <code>CreateProject</code> and
     * <code>DeleteProject</code> might take a while to appear in the response from <code>ListProjects</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListProjects</code> operation.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Lookout for Vision projects in your AWS account that are in the AWS Region in which you call
     * <code>ListProjects</code>.
     * </p>
     * <p>
     * The <code>ListProjects</code> operation is eventually consistent. Recent calls to <code>CreateProject</code> and
     * <code>DeleteProject</code> might take a while to appear in the response from <code>ListProjects</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListProjects</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return Result of the ListProjects operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Lookout for Vision projects in your AWS account that are in the AWS Region in which you call
     * <code>ListProjects</code>.
     * </p>
     * <p>
     * The <code>ListProjects</code> operation is eventually consistent. Recent calls to <code>CreateProject</code> and
     * <code>DeleteProject</code> might take a while to appear in the response from <code>ListProjects</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListProjects</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProjects(software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsIterable responses = client
     *             .listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Lookout for Vision projects in your AWS account that are in the AWS Region in which you call
     * <code>ListProjects</code>.
     * </p>
     * <p>
     * The <code>ListProjects</code> operation is eventually consistent. Recent calls to <code>CreateProject</code> and
     * <code>DeleteProject</code> might take a while to appear in the response from <code>ListProjects</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListProjects</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProjects(software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsIterable responses = client
     *             .listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags attached to the specified Amazon Lookout for Vision model.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListTagsForResource</code> operation.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags attached to the specified Amazon Lookout for Vision model.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:ListTagsForResource</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to
     * complete. To check the current state of the model, use <a>DescribeModel</a>.
     * </p>
     * <p>
     * A model is ready to use when its status is <code>HOSTED</code>.
     * </p>
     * <p>
     * Once the model is running, you can detect custom labels in new images by calling <a>DetectAnomalies</a>.
     * </p>
     * <note>
     * <p>
     * You are charged for the amount of time that the model is running. To stop a running model, call <a>StopModel</a>.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:StartModel</code> operation.
     * </p>
     *
     * @param startModelRequest
     * @return Result of the StartModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.StartModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StartModel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartModelResponse startModel(StartModelRequest startModelRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to
     * complete. To check the current state of the model, use <a>DescribeModel</a>.
     * </p>
     * <p>
     * A model is ready to use when its status is <code>HOSTED</code>.
     * </p>
     * <p>
     * Once the model is running, you can detect custom labels in new images by calling <a>DetectAnomalies</a>.
     * </p>
     * <note>
     * <p>
     * You are charged for the amount of time that the model is running. To stop a running model, call <a>StopModel</a>.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:StartModel</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartModelRequest.Builder} avoiding the need to
     * create one manually via {@link StartModelRequest#builder()}
     * </p>
     *
     * @param startModelRequest
     *        A {@link Consumer} that will call methods on {@link StartModelRequest.Builder} to create a request.
     * @return Result of the StartModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.StartModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StartModel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartModelResponse startModel(Consumer<StartModelRequest.Builder> startModelRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        return startModel(StartModelRequest.builder().applyMutation(startModelRequest).build());
    }

    /**
     * <p>
     * Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an AWS IoT Greengrass
     * component for a Lookout for Vision model. You can use the component to deploy your model to an edge device
     * managed by Greengrass.
     * </p>
     * <p>
     * Use the <a>DescribeModelPackagingJob</a> API to determine the current status of the job. The model packaging job
     * is complete if the value of <code>Status</code> is <code>SUCCEEDED</code>.
     * </p>
     * <p>
     * To deploy the component to the target device, use the component name and component version with the AWS IoT
     * Greengrass <a
     * href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_CreateDeployment.html">CreateDeployment</a> API.
     * </p>
     * <p>
     * This operation requires the following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lookoutvision:StartModelPackagingJob</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketLocation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>greengrass:CreateComponentVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>greengrass:DescribeComponent</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <code>greengrass:TagResource</code>. Only required if you want to tag the component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon
     * Lookout for Vision Developer Guide.
     * </p>
     *
     * @param startModelPackagingJobRequest
     * @return Result of the StartModelPackagingJob operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.StartModelPackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StartModelPackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartModelPackagingJobResponse startModelPackagingJob(StartModelPackagingJobRequest startModelPackagingJobRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an AWS IoT Greengrass
     * component for a Lookout for Vision model. You can use the component to deploy your model to an edge device
     * managed by Greengrass.
     * </p>
     * <p>
     * Use the <a>DescribeModelPackagingJob</a> API to determine the current status of the job. The model packaging job
     * is complete if the value of <code>Status</code> is <code>SUCCEEDED</code>.
     * </p>
     * <p>
     * To deploy the component to the target device, use the component name and component version with the AWS IoT
     * Greengrass <a
     * href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_CreateDeployment.html">CreateDeployment</a> API.
     * </p>
     * <p>
     * This operation requires the following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lookoutvision:StartModelPackagingJob</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketLocation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>greengrass:CreateComponentVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>greengrass:DescribeComponent</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <code>greengrass:TagResource</code>. Only required if you want to tag the component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon
     * Lookout for Vision Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartModelPackagingJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartModelPackagingJobRequest#builder()}
     * </p>
     *
     * @param startModelPackagingJobRequest
     *        A {@link Consumer} that will call methods on {@link StartModelPackagingJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartModelPackagingJob operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.StartModelPackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StartModelPackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartModelPackagingJobResponse startModelPackagingJob(
            Consumer<StartModelPackagingJobRequest.Builder> startModelPackagingJobRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        return startModelPackagingJob(StartModelPackagingJobRequest.builder().applyMutation(startModelPackagingJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops the hosting of a running model. The operation might take a while to complete. To check the current status,
     * call <a>DescribeModel</a>.
     * </p>
     * <p>
     * After the model hosting stops, the <code>Status</code> of the model is <code>TRAINED</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:StopModel</code> operation.
     * </p>
     *
     * @param stopModelRequest
     * @return Result of the StopModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.StopModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StopModel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopModelResponse stopModel(StopModelRequest stopModelRequest) throws AccessDeniedException, InternalServerException,
            ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the hosting of a running model. The operation might take a while to complete. To check the current status,
     * call <a>DescribeModel</a>.
     * </p>
     * <p>
     * After the model hosting stops, the <code>Status</code> of the model is <code>TRAINED</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:StopModel</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopModelRequest.Builder} avoiding the need to
     * create one manually via {@link StopModelRequest#builder()}
     * </p>
     *
     * @param stopModelRequest
     *        A {@link Consumer} that will call methods on {@link StopModelRequest.Builder} to create a request.
     * @return Result of the StopModel operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.StopModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StopModel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopModelResponse stopModel(Consumer<StopModelRequest.Builder> stopModelRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        return stopModel(StopModelRequest.builder().applyMutation(stopModelRequest).build());
    }

    /**
     * <p>
     * Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see <i>Tagging a
     * model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:TagResource</code> operation.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see <i>Tagging a
     * model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:TagResource</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for
     *         Vision in the Amazon Lookout for Vision Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, LookoutVisionException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from an Amazon Lookout for Vision model. For more information, see <i>Tagging a
     * model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:UntagResource</code> operation.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from an Amazon Lookout for Vision model. For more information, see <i>Tagging a
     * model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:UntagResource</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes information about an image used
     * for training or testing an Amazon Lookout for Vision model.
     * </p>
     * <p>
     * To update an existing JSON Line, use the <code>source-ref</code> field to identify the JSON Line. The JSON line
     * that you supply replaces the existing JSON line. Any existing annotations that are not in the new JSON line are
     * removed from the dataset.
     * </p>
     * <p>
     * For more information, see <i>Defining JSON lines for anomaly classification</i> in the Amazon Lookout for Vision
     * Developer Guide.
     * </p>
     * <note>
     * <p>
     * The images you reference in the <code>source-ref</code> field of a JSON line, must be in the same S3 bucket as
     * the existing images in the dataset.
     * </p>
     * </note>
     * <p>
     * Updating a dataset might take a while to complete. To check the current status, call <a>DescribeDataset</a> and
     * check the <code>Status</code> field in the response.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:UpdateDatasetEntries</code> operation.
     * </p>
     *
     * @param updateDatasetEntriesRequest
     * @return Result of the UpdateDatasetEntries operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.UpdateDatasetEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/UpdateDatasetEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDatasetEntriesResponse updateDatasetEntries(UpdateDatasetEntriesRequest updateDatasetEntriesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes information about an image used
     * for training or testing an Amazon Lookout for Vision model.
     * </p>
     * <p>
     * To update an existing JSON Line, use the <code>source-ref</code> field to identify the JSON Line. The JSON line
     * that you supply replaces the existing JSON line. Any existing annotations that are not in the new JSON line are
     * removed from the dataset.
     * </p>
     * <p>
     * For more information, see <i>Defining JSON lines for anomaly classification</i> in the Amazon Lookout for Vision
     * Developer Guide.
     * </p>
     * <note>
     * <p>
     * The images you reference in the <code>source-ref</code> field of a JSON line, must be in the same S3 bucket as
     * the existing images in the dataset.
     * </p>
     * </note>
     * <p>
     * Updating a dataset might take a while to complete. To check the current status, call <a>DescribeDataset</a> and
     * check the <code>Status</code> field in the response.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lookoutvision:UpdateDatasetEntries</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatasetEntriesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDatasetEntriesRequest#builder()}
     * </p>
     *
     * @param updateDatasetEntriesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatasetEntriesRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDatasetEntries operation returned by the service.
     * @throws AccessDeniedException
     *         You are not authorized to perform the action.
     * @throws InternalServerException
     *         Amazon Lookout for Vision experienced a service issue. Try your call again.
     * @throws ValidationException
     *         An input validation error occured. For example, invalid characters in a project name, or if a pagination
     *         token is invalid.
     * @throws ConflictException
     *         The update or deletion of a resource caused an inconsistent state.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ThrottlingException
     *         Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LookoutVisionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LookoutVisionClient.UpdateDatasetEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/UpdateDatasetEntries"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDatasetEntriesResponse updateDatasetEntries(
            Consumer<UpdateDatasetEntriesRequest.Builder> updateDatasetEntriesRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, LookoutVisionException {
        return updateDatasetEntries(UpdateDatasetEntriesRequest.builder().applyMutation(updateDatasetEntriesRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
