/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartModelRequest extends LookoutVisionRequest implements
        ToCopyableBuilder<StartModelRequest.Builder, StartModelRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(StartModelRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(StartModelRequest::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelVersion").build()).build();

    private static final SdkField<Integer> MIN_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinInferenceUnits").getter(getter(StartModelRequest::minInferenceUnits))
            .setter(setter(Builder::minInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInferenceUnits").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            MODEL_VERSION_FIELD, MIN_INFERENCE_UNITS_FIELD, CLIENT_TOKEN_FIELD));

    private final String projectName;

    private final String modelVersion;

    private final Integer minInferenceUnits;

    private final String clientToken;

    private StartModelRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.modelVersion = builder.modelVersion;
        this.minInferenceUnits = builder.minInferenceUnits;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the project that contains the model that you want to start.
     * </p>
     * 
     * @return The name of the project that contains the model that you want to start.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The version of the model that you want to start.
     * </p>
     * 
     * @return The version of the model that you want to start.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can
     * support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model.
     * You are charged for the number of inference units that you use.
     * </p>
     * 
     * @return The minimum number of inference units to use. A single inference unit represents 1 hour of processing and
     *         can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of
     *         your model. You are charged for the number of inference units that you use.
     */
    public final Integer minInferenceUnits() {
        return minInferenceUnits;
    }

    /**
     * <p>
     * ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You
     * choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a
     * response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using
     * the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same
     * as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to
     * <code>StartModel</code>. An idempotency token is active for 8 hours.
     * </p>
     * 
     * @return ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once.
     *         You choose the value to pass. For example, An issue, such as an network outage, might prevent you from
     *         getting a response from <code>StartModel</code>. In this case, safely retry your call to
     *         <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs if
     *         the other input parameters are not the same as in the first request. Using a different value for
     *         <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is
     *         active for 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(minInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartModelRequest)) {
            return false;
        }
        StartModelRequest other = (StartModelRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(minInferenceUnits(), other.minInferenceUnits())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartModelRequest").add("ProjectName", projectName()).add("ModelVersion", modelVersion())
                .add("MinInferenceUnits", minInferenceUnits()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "MinInferenceUnits":
            return Optional.ofNullable(clazz.cast(minInferenceUnits()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartModelRequest, T> g) {
        return obj -> g.apply((StartModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartModelRequest> {
        /**
         * <p>
         * The name of the project that contains the model that you want to start.
         * </p>
         * 
         * @param projectName
         *        The name of the project that contains the model that you want to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The version of the model that you want to start.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model that you want to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can
         * support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your
         * model. You are charged for the number of inference units that you use.
         * </p>
         * 
         * @param minInferenceUnits
         *        The minimum number of inference units to use. A single inference unit represents 1 hour of processing
         *        and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS
         *        throughput of your model. You are charged for the number of inference units that you use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minInferenceUnits(Integer minInferenceUnits);

        /**
         * <p>
         * ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You
         * choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a
         * response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by
         * using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are
         * not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a
         * new call to <code>StartModel</code>. An idempotency token is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only
         *        once. You choose the value to pass. For example, An issue, such as an network outage, might prevent
         *        you from getting a response from <code>StartModel</code>. In this case, safely retry your call to
         *        <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs if
         *        the other input parameters are not the same as in the first request. Using a different value for
         *        <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is
         *        active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutVisionRequest.BuilderImpl implements Builder {
        private String projectName;

        private String modelVersion;

        private Integer minInferenceUnits;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartModelRequest model) {
            super(model);
            projectName(model.projectName);
            modelVersion(model.modelVersion);
            minInferenceUnits(model.minInferenceUnits);
            clientToken(model.clientToken);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        @Transient
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final Integer getMinInferenceUnits() {
            return minInferenceUnits;
        }

        public final void setMinInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
        }

        @Override
        @Transient
        public final Builder minInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartModelRequest build() {
            return new StartModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
