/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<DescribeProjectResponse.Builder, DescribeProjectResponse> {
    private static final SdkField<ProjectDescription> PROJECT_DESCRIPTION_FIELD = SdkField
            .<ProjectDescription> builder(MarshallingType.SDK_POJO).memberName("ProjectDescription")
            .getter(getter(DescribeProjectResponse::projectDescription)).setter(setter(Builder::projectDescription))
            .constructor(ProjectDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_DESCRIPTION_FIELD));

    private final ProjectDescription projectDescription;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.projectDescription = builder.projectDescription;
    }

    /**
     * <p>
     * The description of the project.
     * </p>
     * 
     * @return The description of the project.
     */
    public final ProjectDescription projectDescription() {
        return projectDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse) obj;
        return Objects.equals(projectDescription(), other.projectDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProjectResponse").add("ProjectDescription", projectDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectResponse> {
        /**
         * <p>
         * The description of the project.
         * </p>
         * 
         * @param projectDescription
         *        The description of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(ProjectDescription projectDescription);

        /**
         * <p>
         * The description of the project.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectDescription.Builder} avoiding the
         * need to create one manually via {@link ProjectDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #projectDescription(ProjectDescription)}.
         * 
         * @param projectDescription
         *        a consumer that will call methods on {@link ProjectDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectDescription(ProjectDescription)
         */
        default Builder projectDescription(Consumer<ProjectDescription.Builder> projectDescription) {
            return projectDescription(ProjectDescription.builder().applyMutation(projectDescription).build());
        }
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private ProjectDescription projectDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            projectDescription(model.projectDescription);
        }

        public final ProjectDescription.Builder getProjectDescription() {
            return projectDescription != null ? projectDescription.toBuilder() : null;
        }

        public final void setProjectDescription(ProjectDescription.BuilderImpl projectDescription) {
            this.projectDescription = projectDescription != null ? projectDescription.build() : null;
        }

        @Override
        public final Builder projectDescription(ProjectDescription projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
