/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the AWS IoT Greengrass component created by a model packaging job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GreengrassOutputDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<GreengrassOutputDetails.Builder, GreengrassOutputDetails> {
    private static final SdkField<String> COMPONENT_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentVersionArn").getter(getter(GreengrassOutputDetails::componentVersionArn))
            .setter(setter(Builder::componentVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentVersionArn").build())
            .build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(GreengrassOutputDetails::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentVersion").getter(getter(GreengrassOutputDetails::componentVersion))
            .setter(setter(Builder::componentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_VERSION_ARN_FIELD,
            COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentVersionArn;

    private final String componentName;

    private final String componentVersion;

    private GreengrassOutputDetails(BuilderImpl builder) {
        this.componentVersionArn = builder.componentVersionArn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the component.
     */
    public final String componentVersionArn() {
        return componentVersionArn;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @return The version of the component.
     */
    public final String componentVersion() {
        return componentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GreengrassOutputDetails)) {
            return false;
        }
        GreengrassOutputDetails other = (GreengrassOutputDetails) obj;
        return Objects.equals(componentVersionArn(), other.componentVersionArn())
                && Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentVersion(), other.componentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GreengrassOutputDetails").add("ComponentVersionArn", componentVersionArn())
                .add("ComponentName", componentName()).add("ComponentVersion", componentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentVersionArn":
            return Optional.ofNullable(clazz.cast(componentVersionArn()));
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "ComponentVersion":
            return Optional.ofNullable(clazz.cast(componentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GreengrassOutputDetails, T> g) {
        return obj -> g.apply((GreengrassOutputDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GreengrassOutputDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the component.
         * </p>
         * 
         * @param componentVersionArn
         *        The Amazon Resource Name (ARN) of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersionArn(String componentVersionArn);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The version of the component.
         * </p>
         * 
         * @param componentVersion
         *        The version of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersion(String componentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String componentVersionArn;

        private String componentName;

        private String componentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GreengrassOutputDetails model) {
            componentVersionArn(model.componentVersionArn);
            componentName(model.componentName);
            componentVersion(model.componentVersion);
        }

        public final String getComponentVersionArn() {
            return componentVersionArn;
        }

        public final void setComponentVersionArn(String componentVersionArn) {
            this.componentVersionArn = componentVersionArn;
        }

        @Override
        public final Builder componentVersionArn(String componentVersionArn) {
            this.componentVersionArn = componentVersionArn;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        @Override
        public GreengrassOutputDetails build() {
            return new GreengrassOutputDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
