/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lookoutvision.DefaultLookoutVisionBaseClientBuilder;
import software.amazon.awssdk.services.lookoutvision.DefaultLookoutVisionClient;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionClient;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionClientBuilder;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionServiceClientConfiguration;
import software.amazon.awssdk.services.lookoutvision.endpoints.LookoutVisionEndpointProvider;

@SdkInternalApi
final class DefaultLookoutVisionClientBuilder
extends DefaultLookoutVisionBaseClientBuilder<LookoutVisionClientBuilder, LookoutVisionClient>
implements LookoutVisionClientBuilder {
    DefaultLookoutVisionClientBuilder() {
    }

    @Override
    public DefaultLookoutVisionClientBuilder endpointProvider(LookoutVisionEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LookoutVisionClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLookoutVisionClientBuilder.validateClientOptions(clientConfiguration);
        LookoutVisionServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLookoutVisionClient client = new DefaultLookoutVisionClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LookoutVisionServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LookoutVisionServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

