/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectAnomaliesRequest extends LookoutVisionRequest implements
        ToCopyableBuilder<DetectAnomaliesRequest.Builder, DetectAnomaliesRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(DetectAnomaliesRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(DetectAnomaliesRequest::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelVersion").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(DetectAnomaliesRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            MODEL_VERSION_FIELD, CONTENT_TYPE_FIELD));

    private final String projectName;

    private final String modelVersion;

    private final String contentType;

    private DetectAnomaliesRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.modelVersion = builder.modelVersion;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The name of the project that contains the model version that you want to use.
     * </p>
     * 
     * @return The name of the project that contains the model version that you want to use.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The version of the model that you want to use.
     * </p>
     * 
     * @return The version of the model that you want to use.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images)
     * and <code>image/jpeg</code> (JPG format images).
     * </p>
     * 
     * @return The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format
     *         images) and <code>image/jpeg</code> (JPG format images).
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectAnomaliesRequest)) {
            return false;
        }
        DetectAnomaliesRequest other = (DetectAnomaliesRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectAnomaliesRequest").add("ProjectName", projectName()).add("ModelVersion", modelVersion())
                .add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectAnomaliesRequest, T> g) {
        return obj -> g.apply((DetectAnomaliesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectAnomaliesRequest> {
        /**
         * <p>
         * The name of the project that contains the model version that you want to use.
         * </p>
         * 
         * @param projectName
         *        The name of the project that contains the model version that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The version of the model that you want to use.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format
         * images) and <code>image/jpeg</code> (JPG format images).
         * </p>
         * 
         * @param contentType
         *        The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format
         *        images) and <code>image/jpeg</code> (JPG format images).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutVisionRequest.BuilderImpl implements Builder {
        private String projectName;

        private String modelVersion;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectAnomaliesRequest model) {
            super(model);
            projectName(model.projectName);
            modelVersion(model.modelVersion);
            contentType(model.contentType);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectAnomaliesRequest build() {
            return new DetectAnomaliesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
