/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics about the images in a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetImageStats implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetImageStats.Builder, DatasetImageStats> {
    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Total")
            .getter(getter(DatasetImageStats::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<Integer> LABELED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Labeled").getter(getter(DatasetImageStats::labeled)).setter(setter(Builder::labeled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labeled").build()).build();

    private static final SdkField<Integer> NORMAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Normal").getter(getter(DatasetImageStats::normal)).setter(setter(Builder::normal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normal").build()).build();

    private static final SdkField<Integer> ANOMALY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Anomaly").getter(getter(DatasetImageStats::anomaly)).setter(setter(Builder::anomaly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Anomaly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD, LABELED_FIELD,
            NORMAL_FIELD, ANOMALY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Total", TOTAL_FIELD);
                    put("Labeled", LABELED_FIELD);
                    put("Normal", NORMAL_FIELD);
                    put("Anomaly", ANOMALY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer total;

    private final Integer labeled;

    private final Integer normal;

    private final Integer anomaly;

    private DatasetImageStats(BuilderImpl builder) {
        this.total = builder.total;
        this.labeled = builder.labeled;
        this.normal = builder.normal;
        this.anomaly = builder.anomaly;
    }

    /**
     * <p>
     * The total number of images in the dataset.
     * </p>
     * 
     * @return The total number of images in the dataset.
     */
    public final Integer total() {
        return total;
    }

    /**
     * <p>
     * The total number of labeled images.
     * </p>
     * 
     * @return The total number of labeled images.
     */
    public final Integer labeled() {
        return labeled;
    }

    /**
     * <p>
     * The total number of images labeled as normal.
     * </p>
     * 
     * @return The total number of images labeled as normal.
     */
    public final Integer normal() {
        return normal;
    }

    /**
     * <p>
     * the total number of images labeled as an anomaly.
     * </p>
     * 
     * @return the total number of images labeled as an anomaly.
     */
    public final Integer anomaly() {
        return anomaly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(labeled());
        hashCode = 31 * hashCode + Objects.hashCode(normal());
        hashCode = 31 * hashCode + Objects.hashCode(anomaly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetImageStats)) {
            return false;
        }
        DatasetImageStats other = (DatasetImageStats) obj;
        return Objects.equals(total(), other.total()) && Objects.equals(labeled(), other.labeled())
                && Objects.equals(normal(), other.normal()) && Objects.equals(anomaly(), other.anomaly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetImageStats").add("Total", total()).add("Labeled", labeled()).add("Normal", normal())
                .add("Anomaly", anomaly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "Labeled":
            return Optional.ofNullable(clazz.cast(labeled()));
        case "Normal":
            return Optional.ofNullable(clazz.cast(normal()));
        case "Anomaly":
            return Optional.ofNullable(clazz.cast(anomaly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasetImageStats, T> g) {
        return obj -> g.apply((DatasetImageStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetImageStats> {
        /**
         * <p>
         * The total number of images in the dataset.
         * </p>
         * 
         * @param total
         *        The total number of images in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);

        /**
         * <p>
         * The total number of labeled images.
         * </p>
         * 
         * @param labeled
         *        The total number of labeled images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labeled(Integer labeled);

        /**
         * <p>
         * The total number of images labeled as normal.
         * </p>
         * 
         * @param normal
         *        The total number of images labeled as normal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normal(Integer normal);

        /**
         * <p>
         * the total number of images labeled as an anomaly.
         * </p>
         * 
         * @param anomaly
         *        the total number of images labeled as an anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomaly(Integer anomaly);
    }

    static final class BuilderImpl implements Builder {
        private Integer total;

        private Integer labeled;

        private Integer normal;

        private Integer anomaly;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetImageStats model) {
            total(model.total);
            labeled(model.labeled);
            normal(model.normal);
            anomaly(model.anomaly);
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final Integer getLabeled() {
            return labeled;
        }

        public final void setLabeled(Integer labeled) {
            this.labeled = labeled;
        }

        @Override
        public final Builder labeled(Integer labeled) {
            this.labeled = labeled;
            return this;
        }

        public final Integer getNormal() {
            return normal;
        }

        public final void setNormal(Integer normal) {
            this.normal = normal;
        }

        @Override
        public final Builder normal(Integer normal) {
            this.normal = normal;
            return this;
        }

        public final Integer getAnomaly() {
            return anomaly;
        }

        public final void setAnomaly(Integer anomaly) {
            this.anomaly = anomaly;
        }

        @Override
        public final Builder anomaly(Integer anomaly) {
            this.anomaly = anomaly;
            return this;
        }

        @Override
        public DatasetImageStats build() {
            return new DatasetImageStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
