/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the location of a manifest file that Amazon Lookout for Vision uses to to create a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetSource implements SdkPojo, Serializable, ToCopyableBuilder<DatasetSource.Builder, DatasetSource> {
    private static final SdkField<DatasetGroundTruthManifest> GROUND_TRUTH_MANIFEST_FIELD = SdkField
            .<DatasetGroundTruthManifest> builder(MarshallingType.SDK_POJO).memberName("GroundTruthManifest")
            .getter(getter(DatasetSource::groundTruthManifest)).setter(setter(Builder::groundTruthManifest))
            .constructor(DatasetGroundTruthManifest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruthManifest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_TRUTH_MANIFEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("GroundTruthManifest", GROUND_TRUTH_MANIFEST_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final DatasetGroundTruthManifest groundTruthManifest;

    private DatasetSource(BuilderImpl builder) {
        this.groundTruthManifest = builder.groundTruthManifest;
    }

    /**
     * <p>
     * Location information for the manifest file.
     * </p>
     * 
     * @return Location information for the manifest file.
     */
    public final DatasetGroundTruthManifest groundTruthManifest() {
        return groundTruthManifest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groundTruthManifest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSource)) {
            return false;
        }
        DatasetSource other = (DatasetSource) obj;
        return Objects.equals(groundTruthManifest(), other.groundTruthManifest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetSource").add("GroundTruthManifest", groundTruthManifest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroundTruthManifest":
            return Optional.ofNullable(clazz.cast(groundTruthManifest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasetSource, T> g) {
        return obj -> g.apply((DatasetSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetSource> {
        /**
         * <p>
         * Location information for the manifest file.
         * </p>
         * 
         * @param groundTruthManifest
         *        Location information for the manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundTruthManifest(DatasetGroundTruthManifest groundTruthManifest);

        /**
         * <p>
         * Location information for the manifest file.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetGroundTruthManifest.Builder}
         * avoiding the need to create one manually via {@link DatasetGroundTruthManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetGroundTruthManifest.Builder#build()} is called immediately
         * and its result is passed to {@link #groundTruthManifest(DatasetGroundTruthManifest)}.
         * 
         * @param groundTruthManifest
         *        a consumer that will call methods on {@link DatasetGroundTruthManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groundTruthManifest(DatasetGroundTruthManifest)
         */
        default Builder groundTruthManifest(Consumer<DatasetGroundTruthManifest.Builder> groundTruthManifest) {
            return groundTruthManifest(DatasetGroundTruthManifest.builder().applyMutation(groundTruthManifest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DatasetGroundTruthManifest groundTruthManifest;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSource model) {
            groundTruthManifest(model.groundTruthManifest);
        }

        public final DatasetGroundTruthManifest.Builder getGroundTruthManifest() {
            return groundTruthManifest != null ? groundTruthManifest.toBuilder() : null;
        }

        public final void setGroundTruthManifest(DatasetGroundTruthManifest.BuilderImpl groundTruthManifest) {
            this.groundTruthManifest = groundTruthManifest != null ? groundTruthManifest.build() : null;
        }

        @Override
        public final Builder groundTruthManifest(DatasetGroundTruthManifest groundTruthManifest) {
            this.groundTruthManifest = groundTruthManifest;
            return this;
        }

        @Override
        public DatasetSource build() {
            return new DatasetSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
