/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelPackagingJobResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<DescribeModelPackagingJobResponse.Builder, DescribeModelPackagingJobResponse> {
    private static final SdkField<ModelPackagingDescription> MODEL_PACKAGING_DESCRIPTION_FIELD = SdkField
            .<ModelPackagingDescription> builder(MarshallingType.SDK_POJO).memberName("ModelPackagingDescription")
            .getter(getter(DescribeModelPackagingJobResponse::modelPackagingDescription))
            .setter(setter(Builder::modelPackagingDescription)).constructor(ModelPackagingDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MODEL_PACKAGING_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ModelPackagingDescription", MODEL_PACKAGING_DESCRIPTION_FIELD);
                }
            });

    private final ModelPackagingDescription modelPackagingDescription;

    private DescribeModelPackagingJobResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackagingDescription = builder.modelPackagingDescription;
    }

    /**
     * <p>
     * The description of the model packaging job.
     * </p>
     * 
     * @return The description of the model packaging job.
     */
    public final ModelPackagingDescription modelPackagingDescription() {
        return modelPackagingDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelPackagingDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelPackagingJobResponse)) {
            return false;
        }
        DescribeModelPackagingJobResponse other = (DescribeModelPackagingJobResponse) obj;
        return Objects.equals(modelPackagingDescription(), other.modelPackagingDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelPackagingJobResponse")
                .add("ModelPackagingDescription", modelPackagingDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackagingDescription":
            return Optional.ofNullable(clazz.cast(modelPackagingDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelPackagingJobResponse, T> g) {
        return obj -> g.apply((DescribeModelPackagingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeModelPackagingJobResponse> {
        /**
         * <p>
         * The description of the model packaging job.
         * </p>
         * 
         * @param modelPackagingDescription
         *        The description of the model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackagingDescription(ModelPackagingDescription modelPackagingDescription);

        /**
         * <p>
         * The description of the model packaging job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelPackagingDescription.Builder}
         * avoiding the need to create one manually via {@link ModelPackagingDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelPackagingDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #modelPackagingDescription(ModelPackagingDescription)}.
         * 
         * @param modelPackagingDescription
         *        a consumer that will call methods on {@link ModelPackagingDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackagingDescription(ModelPackagingDescription)
         */
        default Builder modelPackagingDescription(Consumer<ModelPackagingDescription.Builder> modelPackagingDescription) {
            return modelPackagingDescription(ModelPackagingDescription.builder().applyMutation(modelPackagingDescription).build());
        }
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private ModelPackagingDescription modelPackagingDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelPackagingJobResponse model) {
            super(model);
            modelPackagingDescription(model.modelPackagingDescription);
        }

        public final ModelPackagingDescription.Builder getModelPackagingDescription() {
            return modelPackagingDescription != null ? modelPackagingDescription.toBuilder() : null;
        }

        public final void setModelPackagingDescription(ModelPackagingDescription.BuilderImpl modelPackagingDescription) {
            this.modelPackagingDescription = modelPackagingDescription != null ? modelPackagingDescription.build() : null;
        }

        @Override
        public final Builder modelPackagingDescription(ModelPackagingDescription modelPackagingDescription) {
            this.modelPackagingDescription = modelPackagingDescription;
            return this;
        }

        @Override
        public DescribeModelPackagingJobResponse build() {
            return new DescribeModelPackagingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
